/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.model;

import java.util.Locale;
import org.graalvm.component.installer.Feedback;

public enum StabilityLevel {
    Undefined,
    Supported,
    EarlyAdopter,
    Experimental;


    public String displayName(Feedback fb) {
        return fb.withBundle(StabilityLevel.class).l10n("ComponentStabilityLevel_" + this.name().toLowerCase(), new Object[0]);
    }

    public String toString() {
        if (this == Undefined) {
            return "";
        }
        return this.name();
    }

    public static StabilityLevel valueOfMixedCase(String mcs) {
        if (mcs.isEmpty()) {
            return Undefined;
        }
        for (StabilityLevel l : StabilityLevel.values()) {
            if (!l.name().toLowerCase(Locale.ENGLISH).equalsIgnoreCase(mcs)) continue;
            return l;
        }
        throw new IllegalArgumentException(mcs);
    }
}

