/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.gds.GraalChannel;
import org.graalvm.component.installer.gds.MailStorage;

public class GraalChannelFactory
implements SoftwareChannel.Factory {
    private static final String PROTOCOL_OLDS_PREFIX = "gds:";
    private static final String PROTOCOL_HTTTPS_PREFIX = "https:";
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private MailStorage mailStorage;
    private Feedback feedback;

    private MailStorage initMailStorage(CommandInput input, Feedback output) {
        if (this.mailStorage == null) {
            MailStorage ms = new MailStorage(input.getLocalRegistry(), output);
            ms.setStorage(input.getGraalHomePath());
            this.mailStorage = ms;
        }
        return this.mailStorage;
    }

    @Override
    public SoftwareChannel createChannel(SoftwareChannelSource source, CommandInput input, Feedback output) {
        URL u;
        this.feedback = output;
        String urlString = source.getLocationURL();
        if (!urlString.startsWith(PROTOCOL_OLDS_PREFIX)) {
            return null;
        }
        String rest = urlString.substring(PROTOCOL_OLDS_PREFIX.length());
        try {
            u = rest.startsWith("http") || rest.startsWith("file:") || rest.startsWith("test:") ? new URL(rest) : new URL(PROTOCOL_HTTTPS_PREFIX + rest);
        }
        catch (MalformedURLException ex) {
            throw output.failure("YUM_InvalidLocation", ex, urlString, ex.getLocalizedMessage());
        }
        GraalChannel ch = new GraalChannel(input, output, input.getLocalRegistry());
        ch.setEdition(source.getParameter("edition"));
        ch.setReleasesIndexURL(u);
        ch.setMailStorage(this.initMailStorage(input, output));
        return ch;
    }

    @Override
    public Map<String, String> globalOptions() {
        return OPTIONS;
    }

    @Override
    public String globalOptionsHelp() {
        return this.feedback.l10n("GDS_ExtraOptionsHelp", new Object[0]);
    }

    @Override
    public void init(CommandInput input, Feedback output) {
        this.feedback = output;
    }

    static {
        OPTIONS.put("^", "s");
        OPTIONS.put("email", "^");
    }
}

