/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds;

import com.oracle.truffle.tools.utils.json.JSONException;
import com.oracle.truffle.tools.utils.json.JSONObject;
import com.oracle.truffle.tools.utils.json.JSONTokener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.IncompatibleException;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SuppressFBWarnings;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.ce.WebCatalog;
import org.graalvm.component.installer.gds.MailStorage;
import org.graalvm.component.installer.gds.ReleaseEntry;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.graalvm.component.installer.persist.MetadataLoaderAdapter;
import org.graalvm.component.installer.remote.FileDownloader;
import org.graalvm.component.installer.remote.MergeStorage;
import org.graalvm.component.installer.remote.RemotePropertiesStorage;

public class GraalChannel
implements SoftwareChannel,
ComponentCatalog.DownloadInterceptor {
    private static final Logger LOG = Logger.getLogger(GraalChannel.class.getName());
    private final ComponentRegistry localRegistry;
    private final CommandInput input;
    private final Feedback fb;
    private URL releasesIndexURL;
    private Delayed delayedStorage = new Delayed();
    private ComponentStorage storage;
    private final List<String> invalidReleases = new ArrayList<String>();
    private final List<String> invalidOsArchEntries = new ArrayList<String>();
    private final List<String> invalidURLs = new ArrayList<String>();
    private static final String KEY_RELEASES = "Releases";
    private static final String KEY_RELEASE_NAME = "name";
    private static final String KEY_RELEASE_BASES = "base";
    private static final String KEY_RELEASE_CATALOG = "catalog";
    private static final String KEY_RELEASE_LICENSE = "license";
    private static final String KEY_RELEASE_LICENSE_LABEL = "licenseLabel";
    private static final String KEY_RELEASE_VRESION = "version";
    private static final String KEY_RELEASE_EDITION = "edition";
    private static final String KEY_RELEASE_JAVA = "java";
    private MailStorage mailStorage;
    private boolean prompted;
    private String edition;
    private boolean allowUpdates = false;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$");
    private static final String KEY_BASE_URL = "url";
    private static final String KEY_BASE_ARCH = "arch";
    private static final String KEY_BASE_OS = "os";

    public GraalChannel(CommandInput aInput, Feedback aFeedback, ComponentRegistry aRegistry) {
        this.input = aInput;
        this.fb = aFeedback.withBundle(GraalChannel.class);
        this.localRegistry = aRegistry;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public boolean isAllowUpdates() {
        return this.allowUpdates;
    }

    public void setAllowUpdates(boolean allowUpdates) {
        this.allowUpdates = allowUpdates;
    }

    void setMailStorage(MailStorage s) {
        this.mailStorage = s;
    }

    private MailStorage initMailStorage() {
        if (this.mailStorage == null) {
            this.mailStorage = new MailStorage(this.localRegistry, this.fb);
        }
        return this.mailStorage;
    }

    URL getReleasesIndexURL() {
        return this.releasesIndexURL;
    }

    public void setReleasesIndexURL(URL releasesIndexURL) {
        this.releasesIndexURL = releasesIndexURL;
    }

    @Override
    public ComponentStorage getStorage() throws IOException {
        return this.delayedStorage;
    }

    @Override
    public FileDownloader configureDownloader(ComponentInfo info, FileDownloader dn) {
        this.ensureMailAddress();
        return dn;
    }

    private void ensureMailAddress() {
        String reportEmailAddress = this.initMailStorage().getEmailAddress();
        if (reportEmailAddress == null) {
            if (this.input == null) {
                throw this.fb.failure("ERR_EmailAddressMissing", null, new Object[0]);
            }
            reportEmailAddress = this.checkEmailAddress(this.receiveEmailAddress());
            try {
                this.mailStorage.setEmailAddress(reportEmailAddress);
                this.mailStorage.save();
            }
            catch (IOException ex) {
                this.fb.error("WARN_CannotSaveEmailAddress", ex, ex.getLocalizedMessage());
            }
        }
    }

    @Override
    public FileDownloader processDownloader(ComponentInfo info, FileDownloader dn) {
        return this.configureDownloader(info, dn);
    }

    @Override
    public MetadataLoader interceptMetadataLoader(ComponentInfo info, MetadataLoader delegate) {
        return new MetadataLoaderAdapter(delegate){

            @Override
            public Boolean recordLicenseAccepted(ComponentInfo nfo, String licenseID, String licenseText, Date d) throws IOException {
                GraalChannel.this.ensureMailAddress();
                return GraalChannel.this.initMailStorage().getEmailAddress() != null ? null : Boolean.valueOf(false);
            }
        };
    }

    String checkEmailAddress(String mail) {
        if (mail == null) {
            return null;
        }
        String m = mail.trim();
        if ("".equals(m)) {
            return null;
        }
        if (!EMAIL_PATTERN.matcher(m).matches()) {
            throw this.fb.failure("ERR_EmailNotValid", null, m);
        }
        return mail;
    }

    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="AUTO_YES is a special tag value instance")
    String receiveEmailAddress() {
        String mail = this.input.optValue("^");
        if (mail == null) {
            this.fb.output("MSG_EmailAddressEntry", new Object[0]);
            this.fb.outputPart("PROMPT_EmailAddressEntry", new Object[0]);
            if (this.prompted || this.fb.isNonInteractive()) {
                return null;
            }
            mail = this.fb.acceptLine(true);
            if (mail == "<automatic-yes>") {
                mail = null;
            }
            this.prompted = true;
        }
        return mail;
    }

    ComponentStorage throwEmptyStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        Map<String, String> caps = this.localRegistry.getGraalCapabilities();
        String os = caps.get("os_name");
        String arch = caps.get("os_arch");
        this.storage = new NullStorage();
        throw new IncompatibleException(this.fb.l10n("OLDS_IncompatibleRelease", SystemUtils.normalizeOSName(os, arch), SystemUtils.normalizeArchitecture(os, arch), this.localRegistry.getJavaVersion()));
    }

    ComponentStorage loadStorage() throws IOException {
        FileDownloader dn = new FileDownloader(this.fb.l10n("OLDS_ReleaseFile", new Object[0]), this.releasesIndexURL, this.fb);
        dn.download();
        Path storagePath = dn.getLocalFile().toPath();
        List<ReleaseEntry> releases = this.loadReleasesIndex(storagePath);
        if (releases.isEmpty()) {
            return this.throwEmptyStorage();
        }
        MergeStorage store = new MergeStorage(this.localRegistry, this.fb);
        store.setAcceptAllSources(true);
        for (ReleaseEntry en : releases) {
            URL catURL = en.getCatalogURL();
            final Version v = Version.fromString(en.getVersion().displayString());
            SoftwareChannelSource src = new SoftwareChannelSource(catURL.toString(), en.getLabel());
            WebCatalog cata = new WebCatalog(src.getLocationURL(), src){

                @Override
                protected RemotePropertiesStorage createPropertiesStorage(Feedback aFeedback, ComponentRegistry aLocal, Properties props, String selector, URL baseURL) {
                    return new RemotePropertiesStorage(aFeedback, aLocal, props, selector, v, baseURL);
                }
            };
            cata.init(this.localRegistry, this.fb);
            cata.setMatchVersion(en.getVersion().match(Version.Match.Type.EXACT));
            cata.setRemoteProcessor(i -> GraalChannel.configureLicense(i, en));
            store.addChannel(src, cata);
        }
        return store;
    }

    private static ComponentInfo configureLicense(ComponentInfo info, ReleaseEntry en) {
        if (info.getLicensePath() != null) {
            return info;
        }
        String urlString = en.getLicenseURL().toString();
        String label = en.getLicenseLabel();
        if (label == null) {
            label = urlString;
        }
        info.setLicenseType(label);
        info.setLicensePath(urlString);
        return info;
    }

    private boolean acceptsVersion(Version graalVersion, Version vers) {
        int c = graalVersion.installVersion().compareTo(vers.installVersion());
        return this.allowUpdates ? c <= 0 : c == 0;
    }

    List<ReleaseEntry> loadReleasesIndex(Path releasesIndexPath) throws IOException {
        if (this.edition == null) {
            this.edition = this.localRegistry.getGraalCapabilities().get(KEY_RELEASE_EDITION);
        }
        ArrayList<ReleaseEntry> result = new ArrayList<ReleaseEntry>();
        try (InputStreamReader urlReader = new InputStreamReader(Files.newInputStream(releasesIndexPath, new OpenOption[0]));){
            JSONTokener tokener = new JSONTokener((Reader)urlReader);
            JSONObject obj = new JSONObject(tokener);
            JSONObject releases = obj.getJSONObject(KEY_RELEASES);
            if (releases == null) {
                throw new IncompatibleException(this.fb.l10n("OLDS_InvalidReleasesFile", new Object[0]));
            }
            Version v = this.localRegistry.getGraalVersion();
            for (String k : releases.keySet()) {
                JSONObject jo = releases.getJSONObject(k);
                ReleaseEntry e = null;
                try {
                    e = this.jsonToRelease(k, jo);
                }
                catch (JSONException | IllegalArgumentException ex) {
                    this.fb.error("OLDS_ErrorReadingRelease", ex, k, ex.getLocalizedMessage());
                }
                if (e == null) {
                    this.invalidReleases.add(k);
                    continue;
                }
                if (!this.localRegistry.getJavaVersion().equals(e.getJavaVersion())) {
                    LOG.log(Level.FINER, "Invalid Java: {0}", k);
                    continue;
                }
                if (e.getBasePackages().isEmpty()) {
                    LOG.log(Level.FINER, "No distribution packages: {0}", k);
                    continue;
                }
                if (this.edition != null && !this.edition.equals(e.getEdition())) {
                    LOG.log(Level.FINER, "Incorrect edition: {0}", k);
                    continue;
                }
                if (!this.acceptsVersion(v, e.getVersion())) {
                    LOG.log(Level.FINER, "Old version: {0}", k);
                    continue;
                }
                result.add(e);
            }
        }
        return result;
    }

    private URL resolveURL(String u) throws MalformedURLException {
        return this.releasesIndexURL == null ? new URL(u) : new URL(this.releasesIndexURL, u);
    }

    boolean verifyOsArch(String rk, ReleaseEntry.BasePackage bp) {
        String bparch;
        String bpos;
        if (bp.getOs() != null && !(bpos = SystemUtils.normalizeOSName(bp.getOs(), null)).equals(this.localRegistry.getGraalCapabilities().get("os_name"))) {
            LOG.log(Level.FINER, "OS mismatch ({0}) for {1}", new Object[]{bp.getOs(), rk});
            return false;
        }
        if (bp.getArch() != null && !(bparch = SystemUtils.normalizeArchitecture(null, bp.getArch())).equals(this.localRegistry.getGraalCapabilities().get("os_arch"))) {
            LOG.log(Level.FINER, "Arch mismatch ({0}) for {1}", new Object[]{bp.getArch(), rk});
            return false;
        }
        return true;
    }

    ReleaseEntry jsonToRelease(String rk, JSONObject jo) throws IOException {
        String jv;
        String name = jo.getString(KEY_RELEASE_NAME);
        String licenseString = jo.has(KEY_RELEASE_LICENSE) ? jo.getString(KEY_RELEASE_LICENSE) : null;
        String catalogString = jo.getString(KEY_RELEASE_CATALOG);
        JSONObject bases = jo.getJSONObject(KEY_RELEASE_BASES);
        if (catalogString == null || catalogString.isEmpty()) {
            return null;
        }
        String versionString = jo.getString(KEY_RELEASE_VRESION);
        String javaString = jo.getString(KEY_RELEASE_JAVA);
        String editionString = jo.getString(KEY_RELEASE_EDITION);
        String licenseLabel = jo.has(KEY_RELEASE_LICENSE_LABEL) ? jo.getString(KEY_RELEASE_LICENSE_LABEL) : null;
        Version v = Version.fromUserString(versionString).onlyVersion();
        if (javaString.startsWith("jdk")) {
            jv = "" + SystemUtils.interpretJavaMajorVersion(javaString.substring(3));
        } else if (javaString.startsWith(KEY_RELEASE_JAVA)) {
            jv = "" + SystemUtils.interpretJavaMajorVersion(javaString.substring(4));
        } else {
            return null;
        }
        String u = null;
        try {
            u = licenseString;
            URL licenseURL = licenseString == null || licenseString.isEmpty() ? null : this.resolveURL(licenseString);
            u = catalogString;
            URL catalogURL = this.resolveURL(catalogString);
            ReleaseEntry e = new ReleaseEntry(rk, name, v, licenseURL, catalogURL);
            e.setEdition(editionString);
            e.setJavaVersion(jv);
            e.setLicenseLabel(licenseLabel);
            LOG.log(Level.FINEST, "Reading: {0}", rk);
            if (bases == null) {
                LOG.log(Level.FINER, "Release {0} has no bases.", rk);
                return null;
            }
            for (String k : bases.keySet()) {
                ReleaseEntry.BasePackage bp = this.jsonToBase(k, bases.getJSONObject(k));
                if (bp == null) {
                    LOG.log(Level.FINER, "Invalid base: {0}", k);
                    continue;
                }
                if (!this.verifyOsArch(rk + "-" + k, bp)) continue;
                e.addBasePackage(bp);
            }
            return e;
        }
        catch (MalformedURLException ex) {
            this.invalidURLs.add(u);
            return null;
        }
    }

    ReleaseEntry.BasePackage jsonToBase(String s, JSONObject jo) {
        String urlString;
        String arch;
        String os;
        try {
            os = jo.getString(KEY_BASE_OS);
            arch = jo.getString(KEY_BASE_ARCH);
            urlString = jo.getString(KEY_BASE_URL);
        }
        catch (JSONException ex) {
            this.invalidOsArchEntries.add(s);
            return null;
        }
        try {
            URL u = this.resolveURL(urlString);
            return new ReleaseEntry.BasePackage(SystemUtils.normalizeOSName(os, arch), SystemUtils.normalizeArchitecture(os, arch), u);
        }
        catch (MalformedURLException ex) {
            this.invalidURLs.add(urlString);
            return null;
        }
    }

    ReleaseEntry.BasePackage jsonToBase(String s, String urlString) {
        String[] parts = s.split("-");
        if (parts.length != 2) {
            this.invalidOsArchEntries.add(s);
            return null;
        }
        if (urlString == null || urlString.isEmpty()) {
            this.invalidOsArchEntries.add(s);
            return null;
        }
        try {
            URL u = this.resolveURL(urlString);
            return new ReleaseEntry.BasePackage(SystemUtils.normalizeOSName(parts[0], parts[1]), SystemUtils.normalizeArchitecture(parts[0], parts[1]), u);
        }
        catch (MalformedURLException ex) {
            this.invalidURLs.add(urlString);
            return null;
        }
    }

    static final class NullStorage
    implements ComponentStorage {
        NullStorage() {
        }

        @Override
        public Set<String> listComponentIDs() throws IOException {
            return Collections.emptySet();
        }

        @Override
        public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
            return null;
        }

        @Override
        public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
            return Collections.emptySet();
        }

        @Override
        public Map<String, String> loadGraalVersionInfo() {
            return Collections.emptyMap();
        }
    }

    class Delayed
    implements ComponentStorage {
        Delayed() {
        }

        private ComponentStorage init() throws IOException {
            if (GraalChannel.this.storage == null) {
                GraalChannel.this.allowUpdates = GraalChannel.this.input.getRegistry().isAllowDistUpdate();
                GraalChannel.this.storage = GraalChannel.this.loadStorage();
            }
            return GraalChannel.this.storage;
        }

        @Override
        public Set<String> listComponentIDs() throws IOException {
            return this.init().listComponentIDs();
        }

        @Override
        public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
            return this.init().loadComponentFiles(ci);
        }

        @Override
        public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
            return this.init().loadComponentMetadata(id);
        }

        @Override
        public Map<String, String> loadGraalVersionInfo() {
            return Collections.emptyMap();
        }
    }
}

