/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.UserAbortException;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.graalvm.component.installer.remote.FileDownloader;

public class LicensePresenter {
    private final Feedback feedback;
    private final ComponentRegistry localRegistry;
    private final Map<String, List<MetadataLoader>> licensesToAccept;
    private State state = State.NONE;
    private boolean multiLicenses;
    private String displayLicenseId;
    private static final Pattern ALL_NUMBERS = Pattern.compile("[0-9]+");
    private Map<String, String> remoteLicenseContents = new HashMap<String, String>();

    public LicensePresenter(Feedback feedback, ComponentRegistry localRegistry, Map<String, List<MetadataLoader>> licenseIDs) {
        this.feedback = feedback.withBundle(LicensePresenter.class);
        this.localRegistry = localRegistry;
        this.licensesToAccept = licenseIDs;
    }

    public Map<String, List<MetadataLoader>> getLicensesToAccept() {
        return this.licensesToAccept;
    }

    public void filterAcceptedLicenses() {
        for (String licId : new ArrayList<String>(this.licensesToAccept.keySet())) {
            Collection loaders = this.licensesToAccept.get(licId);
            for (MetadataLoader ldr : new ArrayList(loaders)) {
                ComponentInfo ci;
                Date accepted = ldr.isLicenseAccepted(ci = ldr.getComponentInfo(), licId);
                if (accepted == null) {
                    accepted = this.localRegistry.isLicenseAccepted(ci, licId);
                }
                if (accepted == null) continue;
                this.feedback.verboseOutput("INSTALL_LicenseAcceptedAt", ldr.getLicenseType(), accepted, ci.getId(), ci.getName());
                loaders.remove(ldr);
            }
            if (!loaders.isEmpty()) continue;
            this.licensesToAccept.remove(licId);
        }
        this.multiLicenses = this.licensesToAccept.size() > 1;
    }

    public State getState() {
        return this.state;
    }

    public boolean isMultiLicenses() {
        return this.multiLicenses;
    }

    public String getDisplayLicenseId() {
        return this.displayLicenseId;
    }

    String formatComponentList(String licId) {
        List<MetadataLoader> loaders = this.licensesToAccept.get(licId);
        String list = null;
        for (MetadataLoader l : loaders) {
            ComponentInfo ci = l.getComponentInfo();
            if (list == null) {
                list = this.feedback.l10n("INSTALL_LicenseComponentStart", ci.getName());
                continue;
            }
            list = this.feedback.l10n("INSTALL_LicenseComponentCont", list, ci.getName());
        }
        return list;
    }

    void displayLicenseList() {
        this.feedback.output("INSTALL_LicensesToAccept", new Object[0]);
        int idx = 1;
        for (String licId : this.licensesToAccept.keySet()) {
            List<MetadataLoader> loaders = this.licensesToAccept.get(licId);
            String list = this.formatComponentList(licId);
            this.feedback.output("INSTALL_AcceptLicenseComponents", loaders.get(0).getLicenseType(), list, idx);
            ++idx;
        }
        this.feedback.outputPart("INSTALL_AcceptAllLicensesPrompt", new Object[0]);
        this.state = State.LISTINPUT;
    }

    boolean isFinished() {
        return this.licensesToAccept.isEmpty();
    }

    void acceptAllLicenses() {
        for (String s : this.licensesToAccept.keySet()) {
            for (MetadataLoader ldr : this.licensesToAccept.get(s)) {
                ComponentInfo ci = ldr.getComponentInfo();
                try {
                    this.localRegistry.acceptLicense(ci, s, this.loadLicenseText(s));
                }
                catch (IOException ex) {
                    throw this.feedback.failure("INSTALL_ErrorHandlingLicenses", ex, ex.getLocalizedMessage());
                }
            }
        }
        this.licensesToAccept.clear();
    }

    boolean isYes(String userInput) {
        if (userInput == "<automatic-yes>") {
            return true;
        }
        Pattern p = Pattern.compile(this.feedback.l10n("INSTALL_AcceptPromptResponseYes@", new Object[0]), 2);
        return p.matcher(userInput).matches();
    }

    boolean isRead(String userInput) {
        Pattern p = Pattern.compile(this.feedback.l10n("INSTALL_AcceptPromptResponseRead@", new Object[0]), 2);
        return p.matcher(userInput).matches();
    }

    int processUserInputForList() {
        String userInput = this.feedback.acceptLine(true);
        Pattern p = Pattern.compile(this.feedback.l10n("INSTALL_AcceptPromptResponseAbort@", new Object[0]), 2);
        if (p.matcher(userInput).matches()) {
            throw new UserAbortException();
        }
        if (this.isYes(userInput)) {
            this.acceptAllLicenses();
            this.state = State.NONE;
            return 0;
        }
        if (!ALL_NUMBERS.matcher(userInput).matches()) {
            this.feedback.output("INSTALL_LicenseNumberInvalidEntry", this.licensesToAccept.size());
            return -1;
        }
        int n = Integer.parseInt(userInput);
        if (n < 0 || n > this.licensesToAccept.size()) {
            this.feedback.output("INSTALL_LicenseNumberOutOfRange", this.licensesToAccept.size());
            return -1;
        }
        return n;
    }

    protected void acceptLicense(String licenseId) {
        String licText;
        try {
            licText = this.loadLicenseText(licenseId);
        }
        catch (IOException ex) {
            throw this.feedback.failure("INSTALL_ErrorHandlingLicenses", ex, ex.getLocalizedMessage());
        }
        for (MetadataLoader ldr : this.licensesToAccept.get(licenseId)) {
            Boolean result = null;
            try {
                result = ldr.recordLicenseAccepted(ldr.getComponentInfo(), licenseId, licText, null);
            }
            catch (IOException ex) {
                this.feedback.error("WARN_LicenseNotRecorded", ex, licenseId, ex.getLocalizedMessage());
            }
            if (result != null) continue;
            this.localRegistry.acceptLicense(ldr.getComponentInfo(), licenseId, licText);
        }
        this.licensesToAccept.remove(licenseId);
    }

    void displaySingleLicense() {
        String licId = this.licensesToAccept.keySet().iterator().next();
        MetadataLoader ldr = this.licensesToAccept.get(licId).get(0);
        String type = ldr.getLicenseType();
        String compList = this.formatComponentList(licId);
        this.feedback.output("INSTALL_AcceptLicense", compList, type);
        this.feedback.outputPart("INSTALL_AcceptSingleLicense", new Object[0]);
        String input = this.feedback.acceptLine(true);
        if (this.isYes(input)) {
            this.acceptLicense(licId);
            return;
        }
        if (!this.isRead(input)) {
            throw new UserAbortException();
        }
        this.displayLicenseId = licId;
        this.state = State.LICENSE;
    }

    void displayLicenseText() throws IOException {
        String text = this.loadLicenseText(this.displayLicenseId);
        this.feedback.verbatimOut(text, false);
        this.feedback.output("INSTALL_AcceptLicensePrompt", new Object[0]);
        String input = this.feedback.acceptLine(true);
        if (this.isYes(input)) {
            this.acceptLicense(this.displayLicenseId);
            this.state = this.multiLicenses ? State.LIST : State.SINGLE;
        } else {
            if (!this.multiLicenses) {
                throw new UserAbortException();
            }
            this.state = State.LIST;
        }
    }

    boolean isLicenseRemote(String licenseId) {
        MetadataLoader ldr = this.licensesToAccept.get(licenseId).get(0);
        String licPath = ldr.getLicensePath();
        return licPath.contains("://");
    }

    String loadLicenseText(String licenseId) throws IOException {
        MetadataLoader ldr = this.licensesToAccept.get(licenseId).get(0);
        if (this.isLicenseRemote(licenseId)) {
            return this.downloadLicenseText(licenseId, ldr);
        }
        return this.loadFileLicenseText(ldr);
    }

    String downloadLicenseText(String id, MetadataLoader ldr) throws IOException {
        String c = this.remoteLicenseContents.get(id);
        if (c != null) {
            return c;
        }
        String t = ldr.getLicenseType();
        String label = !t.equals(ldr.getLicensePath()) ? this.feedback.l10n("INSTALL_DownloadLicenseName", t) : this.feedback.l10n("INSTALL_DownloadLicenseFile", new Object[0]);
        FileDownloader dn = new FileDownloader(label, new URL(ldr.getLicensePath()), this.feedback);
        dn.download();
        c = String.join((CharSequence)"\n", Files.readAllLines(dn.getLocalFile().toPath()));
        this.remoteLicenseContents.put(id, c);
        return c;
    }

    /*
     * Exception decompiling
     */
    String loadFileLicenseText(MetadataLoader ldr) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void init() {
        this.filterAcceptedLicenses();
        this.state = this.multiLicenses ? State.LIST : State.SINGLE;
    }

    void run() {
        this.init();
        try {
            while (!this.isFinished()) {
                this.singleStep();
            }
        }
        catch (IOException ex) {
            throw this.feedback.failure("INSTALL_ErrorHandlingLicenses", ex, ex.getLocalizedMessage());
        }
    }

    void singleStep() throws IOException {
        block0 : switch (this.state) {
            case LISTINPUT: {
                int choice = this.processUserInputForList();
                switch (choice) {
                    case -1: {
                        break block0;
                    }
                    case 0: {
                        this.state = State.NONE;
                        break block0;
                    }
                }
                ArrayList<String> ids = new ArrayList<String>(this.licensesToAccept.keySet());
                this.displayLicenseId = (String)ids.get(choice - 1);
                this.state = State.LICENSE;
                break;
            }
            case SINGLE: {
                this.displaySingleLicense();
                break;
            }
            case LICENSE: {
                this.displayLicenseText();
                break;
            }
            case NONE: {
                break;
            }
            case LIST: {
                this.displayLicenseList();
                break;
            }
            default: {
                throw new AssertionError((Object)this.state.name());
            }
        }
    }

    static enum State {
        LIST,
        LISTINPUT,
        SINGLE,
        LICENSE,
        NONE;

    }
}

