/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.net.URI;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleToLibGraal;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCallNode;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlanGen;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;

class HSTruffleInliningPlan
extends HSObject
implements TruffleMetaAccessProvider {
    final JNILibGraalScope<TruffleToLibGraal.Id> scope;

    HSTruffleInliningPlan(JNILibGraalScope<TruffleToLibGraal.Id> scope, JNI.JObject handle) {
        super(scope, handle);
        this.scope = scope;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.FindCallNode)
    public TruffleCallNode findCallNode(JavaConstant callNode) {
        long nodeHandle = LibGraal.translate((Object)callNode);
        JNI.JNIEnv env = this.scope.getEnv();
        Object res = HSTruffleInliningPlanGen.callFindCallNode(env, this.getHandle(), nodeHandle);
        if (res.isNull()) {
            return null;
        }
        return new HSTruffleCallNode(this.scope, (JNI.JObject)res);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetPosition)
    public TruffleSourceLanguagePosition getPosition(JavaConstant node) {
        long nodeHandle = LibGraal.translate((Object)node);
        JNI.JNIEnv env = this.scope.getEnv();
        Object res = HSTruffleInliningPlanGen.callGetPosition(env, this.getHandle(), nodeHandle);
        if (res.isNull()) {
            return null;
        }
        return new HSTruffleSourceLanguagePosition(this.scope, (JNI.JObject)res);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AddTargetToDequeue)
    public void addTargetToDequeue(CompilableTruffleAST target) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)target).getHandle();
        JNI.JNIEnv env = this.scope.getEnv();
        HSTruffleInliningPlanGen.callAddTargetToDequeue(env, this.getHandle(), hsCompilable);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.SetInlinedCallCount)
    public void setInlinedCallCount(int count) {
        HSTruffleInliningPlanGen.callSetInlinedCallCount(this.scope.getEnv(), this.getHandle(), count);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.SetCallCount)
    public void setCallCount(int count) {
        HSTruffleInliningPlanGen.callSetCallCount(this.scope.getEnv(), this.getHandle(), count);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AddInlinedTarget)
    public void addInlinedTarget(CompilableTruffleAST target) {
        JNI.JObject hsCompilable = ((HSCompilableTruffleAST)target).getHandle();
        HSTruffleInliningPlanGen.callAddInlinedTarget(this.scope.getEnv(), this.getHandle(), hsCompilable);
    }

    private static final class HSTruffleSourceLanguagePosition
    extends HSObject
    implements TruffleSourceLanguagePosition {
        HSTruffleSourceLanguagePosition(JNILibGraalScope<TruffleToLibGraal.Id> scope, JNI.JObject handle) {
            super(scope, handle);
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetStart)
        public int getOffsetStart() {
            return HSTruffleInliningPlanGen.callGetOffsetStart(JNILibGraalScope.env(), this.getHandle());
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetEnd)
        public int getOffsetEnd() {
            return HSTruffleInliningPlanGen.callGetOffsetEnd(JNILibGraalScope.env(), this.getHandle());
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLineNumber)
        public int getLineNumber() {
            return HSTruffleInliningPlanGen.callGetLineNumber(JNILibGraalScope.env(), this.getHandle());
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLanguage)
        public String getLanguage() {
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetLanguage(JNILibGraalScope.env(), this.getHandle());
            return JNIUtil.createString((JNI.JNIEnv)JNILibGraalScope.env(), (JNI.JString)res);
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetDescription)
        public String getDescription() {
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetDescription(JNILibGraalScope.env(), this.getHandle());
            return JNIUtil.createString((JNI.JNIEnv)JNILibGraalScope.env(), (JNI.JString)res);
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetURI)
        public URI getURI() {
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetURI(JNILibGraalScope.env(), this.getHandle());
            String stringifiedURI = JNIUtil.createString((JNI.JNIEnv)JNILibGraalScope.env(), (JNI.JString)res);
            return stringifiedURI == null ? null : URI.create(stringifiedURI);
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeClassName)
        public String getNodeClassName() {
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetNodeClassName(JNILibGraalScope.env(), this.getHandle());
            return JNIUtil.createString((JNI.JNIEnv)JNILibGraalScope.env(), (JNI.JString)res);
        }

        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeId)
        public int getNodeId() {
            return HSTruffleInliningPlanGen.callGetNodeId(JNILibGraalScope.env(), this.getHandle());
        }
    }
}

