/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleToLibGraal;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCallNodeGen;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;

final class HSTruffleCallNode
extends HSObject
implements TruffleCallNode {
    HSTruffleCallNode(JNILibGraalScope<TruffleToLibGraal.Id> scope, JNI.JObject handle) {
        super(scope, handle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCurrentCallTarget)
    public CompilableTruffleAST getCurrentCallTarget() {
        JNILibGraalScope scope = JNILibGraalScope.scope().narrow(TruffleToLibGraal.Id.class);
        Object hsCompilable = HSTruffleCallNodeGen.callGetCurrentCallTarget(scope.getEnv(), this.getHandle());
        if (hsCompilable.isNull()) {
            return null;
        }
        return new HSCompilableTruffleAST((JNILibGraalScope<TruffleToLibGraal.Id>)scope, (JNI.JObject)hsCompilable);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallCount)
    public int getCallCount() {
        return HSTruffleCallNodeGen.callGetCallCount(JNILibGraalScope.env(), this.getHandle());
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsInliningForced)
    public boolean isInliningForced() {
        return HSTruffleCallNodeGen.callIsInliningForced(JNILibGraalScope.env(), this.getHandle());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != HSTruffleCallNode.class) {
            return false;
        }
        return JNIUtil.IsSameObject((JNI.JNIEnv)JNILibGraalScope.env(), (JNI.JObject)this.getHandle(), (JNI.JObject)((HSTruffleCallNode)((Object)obj)).getHandle());
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CallNodeHashCode)
    public int hashCode() {
        return HSTruffleCallNodeGen.callCallNodeHashCode(JNILibGraalScope.env(), this.getHandle());
    }
}

