/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraalRepeated;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleToLibGraal;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleASTGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCallNode;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.LibGraalObjectHandles;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;

final class HSCompilableTruffleAST
extends HSObject
implements CompilableTruffleAST,
OptimizedAssumptionDependency {
    private volatile String cachedName;
    private Long cachedFailedSpeculationsAddress;
    private volatile String cachedString;

    HSCompilableTruffleAST(JNI.JNIEnv env, JNI.JObject handle) {
        super(env, handle);
    }

    HSCompilableTruffleAST(JNILibGraalScope<TruffleToLibGraal.Id> scope, JNI.JObject handle) {
        super(scope, handle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFailedSpeculationsAddress)
    public SpeculationLog getCompilationSpeculationLog() {
        Long res = this.cachedFailedSpeculationsAddress;
        if (res == null) {
            this.cachedFailedSpeculationsAddress = res = Long.valueOf(HSCompilableTruffleASTGen.callGetFailedSpeculationsAddress(JNILibGraalScope.env(), this.getHandle()));
        }
        return HotSpotGraalServices.newHotSpotSpeculationLog((long)this.cachedFailedSpeculationsAddress);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeRewritingAssumptionConstant)
    public JavaConstant getNodeRewritingAssumptionConstant() {
        long javaConstantHandle = HSCompilableTruffleASTGen.callGetNodeRewritingAssumptionConstant(JNILibGraalScope.env(), this.getHandle());
        return (JavaConstant)LibGraal.unhand(JavaConstant.class, (long)javaConstantHandle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetValidRootAssumptionConstant)
    public JavaConstant getValidRootAssumptionConstant() {
        long javaConstantHandle = HSCompilableTruffleASTGen.callGetValidRootAssumptionConstant(JNILibGraalScope.env(), this.getHandle());
        return (JavaConstant)LibGraal.unhand(JavaConstant.class, (long)javaConstantHandle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTrivial)
    public boolean isTrivial() {
        return HSCompilableTruffleASTGen.callIsTrivial(JNILibGraalScope.env(), this.getHandle());
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsJavaConstant)
    public JavaConstant asJavaConstant() {
        return (JavaConstant)LibGraal.unhand(JavaConstant.class, (long)HSCompilableTruffleASTGen.callAsJavaConstant(JNILibGraalScope.env(), this.getHandle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TruffleFromLibGraalRepeated(value={@TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateStringSupplier), @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCompilationFailed)})
    public void onCompilationFailed(Supplier<String> serializedException, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        long serializedExceptionHandle = LibGraalObjectHandles.create(serializedException);
        boolean success = false;
        JNI.JNIEnv env = JNILibGraalScope.env();
        try {
            Object instance = HSCompilableTruffleASTGen.callCreateStringSupplier(env, serializedExceptionHandle);
            HSCompilableTruffleASTGen.callOnCompilationFailed(env, this.getHandle(), instance, silent, bailout, permanentBailout, graphTooBig);
            success = true;
        }
        finally {
            if (!success) {
                LibGraalObjectHandles.remove(serializedExceptionHandle);
            }
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableName)
    public String getName() {
        String res = this.cachedName;
        if (res == null) {
            JNI.JNIEnv env = JNILibGraalScope.env();
            JNI.JString name = (JNI.JString)HSCompilableTruffleASTGen.callGetCompilableName(env, this.getHandle());
            this.cachedName = res = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)name);
        }
        return res;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNonTrivialNodeCount)
    public int getNonTrivialNodeCount() {
        return HSCompilableTruffleASTGen.callGetNonTrivialNodeCount(JNILibGraalScope.env(), this.getHandle());
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallNodes)
    public TruffleCallNode[] getCallNodes() {
        JNILibGraalScope scope = JNILibGraalScope.scope().narrow(TruffleToLibGraal.Id.class);
        JNI.JNIEnv env = scope.getEnv();
        JNI.JObjectArray peerArr = (JNI.JObjectArray)HSCompilableTruffleASTGen.callGetCallNodes(env, this.getHandle());
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)peerArr);
        TruffleCallNode[] res = new TruffleCallNode[len];
        for (int i = 0; i < len; ++i) {
            JNI.JObject peerTruffleCallNode = JNIUtil.GetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)peerArr, (int)i);
            res[i] = new HSTruffleCallNode((JNILibGraalScope<TruffleToLibGraal.Id>)scope, peerTruffleCallNode);
        }
        return res;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableCallCount)
    public int getCallCount() {
        return HSCompilableTruffleASTGen.callGetCompilableCallCount(JNILibGraalScope.env(), this.getHandle());
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CompilableToString)
    public String toString() {
        String res = this.cachedString;
        if (res == null) {
            JNI.JNIEnv env = JNILibGraalScope.env();
            JNI.JString value = (JNI.JString)HSCompilableTruffleASTGen.callCompilableToString(env, this.getHandle());
            this.cachedString = res = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)value);
        }
        return res;
    }

    private IllegalArgumentException error() {
        throw new IllegalArgumentException("Cannot call method on libgraal proxy to HotSpotOptimizedCallTarget " + (Object)((Object)this));
    }

    public CompilableTruffleAST getCompilable() {
        return this;
    }

    public void onAssumptionInvalidated(Object source, CharSequence reason) {
        throw this.error();
    }

    public boolean isValid() {
        throw this.error();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CancelCompilation)
    public boolean cancelCompilation(CharSequence reason) {
        JNI.JNIEnv env = JNILibGraalScope.env();
        JNI.JString jniReason = JNIUtil.createHSString((JNI.JNIEnv)env, (String)reason.toString());
        return HSCompilableTruffleASTGen.callCancelCompilation(env, this.getHandle(), (JNI.JObject)jniReason);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.DequeueInlined)
    public void dequeueInlined() {
        HSCompilableTruffleASTGen.callDequeueInlined(JNILibGraalScope.env(), this.getHandle());
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSameOrSplit)
    public boolean isSameOrSplit(CompilableTruffleAST ast) {
        JNI.JObject astHandle = ((HSCompilableTruffleAST)ast).getHandle();
        return HSCompilableTruffleASTGen.callIsSameOrSplit(JNILibGraalScope.env(), this.getHandle(), astHandle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetKnownCallSiteCount)
    public int getKnownCallSiteCount() {
        return HSCompilableTruffleASTGen.callGetKnownCallSiteCount(JNILibGraalScope.env(), this.getHandle());
    }
}

