/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.coverage;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.coverage.AbstractCoverageNode;
import com.oracle.truffle.tools.coverage.BooleanCoverageNode;
import com.oracle.truffle.tools.coverage.CountingCoverageNode;
import com.oracle.truffle.tools.coverage.RootCoverage;
import com.oracle.truffle.tools.coverage.SectionCoverage;
import com.oracle.truffle.tools.coverage.SourceCoverage;
import com.oracle.truffle.tools.coverage.impl.CoverageInstrument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class CoverageTracker
implements AutoCloseable {
    private static final SourceSectionFilter DEFAULT_FILTER = SourceSectionFilter.newBuilder().includeInternal(false).build();
    private final List<AbstractCoverageNode> coverageNodes = new ArrayList<AbstractCoverageNode>();
    private final List<LoadSourceSectionEvent> loadedRoots = new ArrayList<LoadSourceSectionEvent>();
    private final List<LoadSourceSectionEvent> loadedStatements = new ArrayList<LoadSourceSectionEvent>();
    private final TruffleInstrument.Env env;
    private boolean tracking;
    private boolean closed;
    private EventBinding<LoadSourceSectionListener> loadedRootsBinding;
    private EventBinding<ExecutionEventNodeFactory> coveredBinding;
    private EventBinding<LoadSourceSectionListener> loadedStatementBinding;
    private Assumption noReset;

    private CoverageTracker(TruffleInstrument.Env env) {
        this.env = env;
    }

    private static SourceCoverage[] sourceCoverage(Map<Source, Map<SourceSection, RootData>> mapping) {
        SourceCoverage[] coverage = new SourceCoverage[mapping.size()];
        int i = 0;
        for (Map.Entry<Source, Map<SourceSection, RootData>> entry : mapping.entrySet()) {
            coverage[i++] = new SourceCoverage(entry.getKey(), CoverageTracker.rootCoverage(entry.getValue()));
        }
        return coverage;
    }

    private static RootCoverage[] rootCoverage(Map<SourceSection, RootData> perRootData) {
        RootCoverage[] rootCoverage = new RootCoverage[perRootData.size()];
        int i = 0;
        for (Map.Entry<SourceSection, RootData> entry : perRootData.entrySet()) {
            RootData rootData = entry.getValue();
            rootCoverage[i++] = new RootCoverage(CoverageTracker.sectionCoverage(rootData), rootData.covered, rootData.count, rootData.sourceSection, rootData.name);
        }
        return rootCoverage;
    }

    private static SectionCoverage[] sectionCoverage(RootData rootData) {
        Set loadedStatements = rootData.loadedStatements;
        SectionCoverage[] sectionCoverage = new SectionCoverage[loadedStatements.size()];
        int i = 0;
        for (SourceSection statement : loadedStatements) {
            Long count = (Long)rootData.coveredStatements.get(statement);
            sectionCoverage[i++] = new SectionCoverage(statement, count != null, count == null ? -1L : count);
        }
        return sectionCoverage;
    }

    private static AbstractCoverageNode makeCoverageNode(EventContext context, Config config, Assumption noReset) {
        boolean isRoot = context.hasTag(StandardTags.RootTag.class);
        boolean isStatement = context.hasTag(StandardTags.StatementTag.class);
        if (config.count) {
            return new CountingCoverageNode(context.getInstrumentedSourceSection(), context.getInstrumentedNode(), isRoot, isStatement);
        }
        return new BooleanCoverageNode(context.getInstrumentedSourceSection(), context.getInstrumentedNode(), isRoot, isStatement, noReset);
    }

    private static long getCount(AbstractCoverageNode coverageNode) {
        return coverageNode instanceof CountingCoverageNode ? ((CountingCoverageNode)coverageNode).getCount() : -1L;
    }

    public synchronized void start(Config config) {
        if (this.closed) {
            throw new IllegalStateException("Coverage Tracker is closed");
        }
        if (this.tracking) {
            throw new IllegalStateException("Coverage Tracker is already tracking");
        }
        this.clearData();
        this.tracking = true;
        this.noReset = Truffle.getRuntime().createAssumption("No reset assumption");
        Instrumenter instrumenter = this.env.getInstrumenter();
        this.instrument(config, instrumenter);
    }

    private synchronized void clearData() {
        this.loadedRoots.clear();
        this.loadedStatements.clear();
        this.coverageNodes.clear();
    }

    public synchronized void end() {
        if (!this.tracking) {
            throw new IllegalStateException("Coverage tracker is not tracking");
        }
        this.tracking = false;
        this.disposeBindings();
    }

    public synchronized SourceCoverage[] getCoverage() {
        return CoverageTracker.sourceCoverage(this.mapping(false));
    }

    public synchronized SourceCoverage[] resetCoverage() {
        SourceCoverage[] coverages = CoverageTracker.sourceCoverage(this.mapping(true));
        this.noReset.invalidate();
        return coverages;
    }

    private Map<Source, Map<SourceSection, RootData>> mapping(boolean reset) {
        HashMap<Source, Map<SourceSection, RootData>> sourceCoverage = new HashMap<Source, Map<SourceSection, RootData>>();
        this.processLoaded(sourceCoverage);
        this.processCovered(sourceCoverage, reset);
        return sourceCoverage;
    }

    private void processLoaded(Map<Source, Map<SourceSection, RootData>> sourceCoverage) {
        this.processLoadedRoots(sourceCoverage);
        this.processLoadedSections(sourceCoverage);
    }

    private void processLoadedSections(Map<Source, Map<SourceSection, RootData>> sourceCoverage) {
        for (LoadSourceSectionEvent loadedEvent : this.loadedStatements) {
            SourceSection section = loadedEvent.getSourceSection();
            Source source = section.getSource();
            Node node = loadedEvent.getNode();
            RootNode rootNode = node.getRootNode();
            Map perSourceData = sourceCoverage.computeIfAbsent(source, s -> new HashMap());
            RootData rootData = perSourceData.computeIfAbsent(rootNode.getSourceSection(), s -> new RootData((SourceSection)s, rootNode.getName()));
            rootData.loadedStatements.add(section);
        }
    }

    private void processLoadedRoots(Map<Source, Map<SourceSection, RootData>> sourceCoverage) {
        for (LoadSourceSectionEvent loadedEvent : this.loadedRoots) {
            SourceSection section = loadedEvent.getSourceSection();
            Source source = section.getSource();
            Map perRootData = sourceCoverage.computeIfAbsent(source, s -> new HashMap());
            Node node = loadedEvent.getNode();
            RootNode rootNode = node.getRootNode();
            if (rootNode == null) continue;
            perRootData.put(rootNode.getSourceSection(), new RootData(section, rootNode.getName()));
        }
    }

    private void processCovered(Map<Source, Map<SourceSection, RootData>> mapping, boolean reset) {
        for (AbstractCoverageNode coverageNode : this.coverageNodes) {
            SourceSection section = coverageNode.sourceSection;
            Source source = section.getSource();
            Node node = coverageNode.instrumentedNode;
            RootNode rootNode = node.getRootNode();
            if (rootNode == null || !coverageNode.isCovered()) continue;
            RootData rootData = mapping.get(source).get(rootNode.getSourceSection());
            long count = CoverageTracker.getCount(coverageNode);
            if (coverageNode.isRoot && coverageNode.isCovered()) {
                rootData.covered = true;
                rootData.count = count;
            } else if (coverageNode.isStatement) {
                rootData.coveredStatements.put(section, count);
            }
            if (!reset) continue;
            coverageNode.reset();
        }
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.tracking) {
            this.end();
        }
    }

    private void instrument(Config config, Instrumenter instrumenter) {
        SourceSectionFilter f = config.sourceSectionFilter;
        if (f == null) {
            f = DEFAULT_FILTER;
        }
        this.instrumentLoadedRoots(instrumenter, f);
        this.instrumentLoadedStatements(instrumenter, f);
        this.instrumentExecution(config, instrumenter, f);
    }

    private void instrumentExecution(final Config config, Instrumenter instrumenter, SourceSectionFilter f) {
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class, StandardTags.StatementTag.class}).and(f).build();
        this.coveredBinding = instrumenter.attachExecutionEventFactory(filter, new ExecutionEventNodeFactory(){

            public ExecutionEventNode create(EventContext context) {
                AbstractCoverageNode coverageNode = CoverageTracker.makeCoverageNode(context, config, CoverageTracker.this.noReset);
                CoverageTracker.this.addCoverageNode(coverageNode);
                return coverageNode;
            }
        });
    }

    private synchronized void addCoverageNode(AbstractCoverageNode coverageNode) {
        this.coverageNodes.add(coverageNode);
    }

    private void instrumentLoadedStatements(Instrumenter instrumenter, SourceSectionFilter f) {
        SourceSectionFilter statementFilter = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.StatementTag.class}).and(f).build();
        this.loadedStatementBinding = instrumenter.attachLoadSourceSectionListener(statementFilter, new LoadSourceSectionListener(){

            public void onLoad(LoadSourceSectionEvent event) {
                CoverageTracker.this.addStatement(event);
            }
        }, true);
    }

    private void instrumentLoadedRoots(Instrumenter instrumenter, SourceSectionFilter f) {
        SourceSectionFilter rootFilter = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).and(f).build();
        this.loadedRootsBinding = instrumenter.attachLoadSourceSectionListener(rootFilter, new LoadSourceSectionListener(){

            public void onLoad(LoadSourceSectionEvent event) {
                CoverageTracker.this.addRoot(event);
            }
        }, true);
    }

    private synchronized void addRoot(LoadSourceSectionEvent event) {
        this.loadedRoots.add(event);
    }

    private synchronized void addStatement(LoadSourceSectionEvent event) {
        this.loadedStatements.add(event);
    }

    private void disposeBindings() {
        this.loadedRootsBinding.dispose();
        this.loadedStatementBinding.dispose();
        this.coveredBinding.dispose();
    }

    static {
        CoverageInstrument.setFactory(new Function<TruffleInstrument.Env, CoverageTracker>(){

            @Override
            public CoverageTracker apply(TruffleInstrument.Env env) {
                return new CoverageTracker(env);
            }
        });
    }

    public static class Config {
        private final SourceSectionFilter sourceSectionFilter;
        private final boolean count;

        public Config(SourceSectionFilter sourceSectionFilter, boolean count) {
            this.sourceSectionFilter = sourceSectionFilter;
            this.count = count;
        }
    }

    private static class RootData {
        private final SourceSection sourceSection;
        private final Set<SourceSection> loadedStatements = new HashSet<SourceSection>();
        private final Map<SourceSection, Long> coveredStatements = new HashMap<SourceSection, Long>();
        private final String name;
        private long count;
        private boolean covered;

        RootData(SourceSection sourceSection, String name) {
            this.sourceSection = sourceSection;
            this.name = name;
        }
    }
}

