/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.APHotSpotSignature;
import org.graalvm.compiler.replacements.processor.AnnotationHandler;
import org.graalvm.compiler.replacements.processor.ClassSubstitutionHandler;
import org.graalvm.compiler.replacements.processor.PluginGenerator;

public final class MethodSubstitutionHandler
extends AnnotationHandler {
    private static final String METHOD_SUBSTITUTION_CLASS_NAME = "org.graalvm.compiler.api.replacements.MethodSubstitution";
    private static final boolean DEBUG = false;
    private static final String ORIGINAL_METHOD_NAME = "value";
    private static final String ORIGINAL_IS_STATIC = "isStatic";
    private static final String ORIGINAL_SIGNATURE = "signature";
    private static final String ORIGINAL_METHOD_NAME_DEFAULT = "";
    private static final String ORIGINAL_SIGNATURE_DEFAULT = "";

    public MethodSubstitutionHandler(AbstractProcessor processor) {
        super(processor, METHOD_SUBSTITUTION_CLASS_NAME);
    }

    @Override
    public void process(Element element, AnnotationMirror annotation, PluginGenerator generator) {
        if (element.getKind() != ElementKind.METHOD) {
            assert (false) : "Element is guaranteed to be a method.";
            return;
        }
        ExecutableElement substitutionMethod = (ExecutableElement)element;
        TypeElement substitutionType = MethodSubstitutionHandler.findEnclosingClass(substitutionMethod);
        assert (substitutionType != null);
        Messager messager = this.processor.env().getMessager();
        AnnotationMirror substitutionClassAnnotation = this.processor.getAnnotation(substitutionType, this.processor.getType("org.graalvm.compiler.api.replacements.ClassSubstitution"));
        if (substitutionClassAnnotation == null) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("A @%s annotation is required on the enclosing class.", AbstractProcessor.getSimpleName("org.graalvm.compiler.api.replacements.ClassSubstitution")), element, annotation);
            return;
        }
        boolean optional = AbstractProcessor.getAnnotationValue(substitutionClassAnnotation, "optional", Boolean.class);
        if (optional) {
            return;
        }
        TypeElement originalType = ClassSubstitutionHandler.resolveOriginalType(this.processor, substitutionType, substitutionClassAnnotation);
        if (originalType == null) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("The @%s annotation is invalid on the enclosing class.", AbstractProcessor.getSimpleName("org.graalvm.compiler.api.replacements.ClassSubstitution")), element, annotation);
            return;
        }
        if (!substitutionMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must be static.", AbstractProcessor.getSimpleName(METHOD_SUBSTITUTION_CLASS_NAME)), element, annotation);
        }
        if (substitutionMethod.getModifiers().contains((Object)Modifier.ABSTRACT) || substitutionMethod.getModifiers().contains((Object)Modifier.NATIVE)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must not be native or abstract.", AbstractProcessor.getSimpleName(METHOD_SUBSTITUTION_CLASS_NAME)), element, annotation);
        }
        String originalName = MethodSubstitutionHandler.originalName(substitutionMethod, annotation);
        boolean isStatic = AbstractProcessor.getAnnotationValue(annotation, ORIGINAL_IS_STATIC, Boolean.class);
        TypeMirror[] originalSignature = this.originalSignature(originalType, substitutionMethod, annotation, isStatic);
        if (originalSignature == null) {
            return;
        }
        ExecutableElement originalMethod = this.originalMethod(substitutionMethod, annotation, originalType, originalName, originalSignature, isStatic);
    }

    private TypeMirror[] originalSignature(TypeElement originalType, ExecutableElement method, AnnotationMirror annotation, boolean isStatic) {
        String signatureString = AbstractProcessor.getAnnotationValue(annotation, ORIGINAL_SIGNATURE, String.class);
        ArrayList<TypeMirror> parameters = new ArrayList<TypeMirror>();
        Messager messager = this.processor.env().getMessager();
        if (signatureString.equals("")) {
            for (int i = 0; i < method.getParameters().size(); ++i) {
                parameters.add(method.getParameters().get(i).asType());
            }
            if (!isStatic) {
                if (parameters.isEmpty()) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Method signature must be a static method with the 'this' object as its first parameter", method, annotation);
                    return null;
                }
                TypeMirror thisParam = (TypeMirror)parameters.remove(0);
                if (!this.isSubtype(originalType.asType(), thisParam)) {
                    Name thisName = method.getParameters().get(0).getSimpleName();
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("The type of %s must assignable from %s", thisName, originalType), method, annotation);
                }
            }
            parameters.add(0, method.getReturnType());
        } else {
            try {
                APHotSpotSignature signature = new APHotSpotSignature(signatureString);
                parameters.add(signature.getReturnType(this.processor.env()));
                for (int i = 0; i < signature.getParameterCount(false); ++i) {
                    parameters.add(signature.getParameterType(this.processor.env(), i));
                }
            }
            catch (Exception e) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Parsing the signature failed: %s", e.getMessage() != null ? e.getMessage() : e.toString()), method, annotation);
                return null;
            }
        }
        return parameters.toArray(new TypeMirror[parameters.size()]);
    }

    private static String originalName(ExecutableElement substituteMethod, AnnotationMirror substitution) {
        String originalMethodName = AbstractProcessor.getAnnotationValue(substitution, ORIGINAL_METHOD_NAME, String.class);
        if (originalMethodName.equals("")) {
            originalMethodName = substituteMethod.getSimpleName().toString();
        }
        return originalMethodName;
    }

    private ExecutableElement originalMethod(ExecutableElement substitutionMethod, AnnotationMirror substitutionAnnotation, TypeElement originalType, String originalName, TypeMirror[] originalSignature, boolean isStatic) {
        TypeMirror signatureReturnType = originalSignature[0];
        Object[] signatureParameters = Arrays.copyOfRange(originalSignature, 1, originalSignature.length);
        List<ExecutableElement> searchElements = originalName.equals("<init>") ? ElementFilter.constructorsIn(originalType.getEnclosedElements()) : ElementFilter.methodsIn(originalType.getEnclosedElements());
        Messager messager = this.processor.env().getMessager();
        Element originalMethod = null;
        block0: for (ExecutableElement searchElement : searchElements) {
            if (!searchElement.getSimpleName().toString().equals(originalName) || searchElement.getParameters().size() != signatureParameters.length) continue;
            for (int i = 0; i < signatureParameters.length; ++i) {
                VariableElement parameter = searchElement.getParameters().get(i);
                if (!this.isTypeCompatible(parameter.asType(), (TypeMirror)signatureParameters[i])) continue block0;
            }
            originalMethod = searchElement;
            break;
        }
        if (originalMethod == null) {
            boolean optional = AbstractProcessor.getAnnotationValue(substitutionAnnotation, "optional", Boolean.class);
            if (!optional) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Could not find the original method with name '%s' and parameters '%s'.", originalName, Arrays.toString(signatureParameters)), substitutionMethod, substitutionAnnotation);
            }
            return null;
        }
        if (originalMethod.getModifiers().contains((Object)Modifier.STATIC) != isStatic) {
            boolean optional = AbstractProcessor.getAnnotationValue(substitutionAnnotation, "optional", Boolean.class);
            if (!optional) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("The %s element must be set to %s.", ORIGINAL_IS_STATIC, !isStatic), substitutionMethod, substitutionAnnotation);
            }
            return null;
        }
        if (!this.isTypeCompatible(originalMethod.getReturnType(), signatureReturnType)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("The return type of the substitution method '%s' must match with the return type of the original method '%s'.", signatureReturnType, originalMethod.getReturnType()), substitutionMethod, substitutionAnnotation);
            return null;
        }
        return originalMethod;
    }

    private boolean isTypeCompatible(TypeMirror originalType, TypeMirror substitutionType) {
        TypeMirror original = originalType;
        TypeMirror substitution = substitutionType;
        if (MethodSubstitutionHandler.needsErasure(original)) {
            original = this.processor.env().getTypeUtils().erasure(original);
        }
        if (MethodSubstitutionHandler.needsErasure(substitution)) {
            substitution = this.processor.env().getTypeUtils().erasure(substitution);
        }
        return this.processor.env().getTypeUtils().isSameType(original, substitution);
    }

    private boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        TypeMirror t1Erased = t1;
        TypeMirror t2Erased = t2;
        if (MethodSubstitutionHandler.needsErasure(t1Erased)) {
            t1Erased = this.processor.env().getTypeUtils().erasure(t1Erased);
        }
        if (MethodSubstitutionHandler.needsErasure(t2Erased)) {
            t2Erased = this.processor.env().getTypeUtils().erasure(t2Erased);
        }
        return this.processor.env().getTypeUtils().isSubtype(t1Erased, t2Erased);
    }

    private static boolean needsErasure(TypeMirror typeMirror) {
        return typeMirror.getKind() != TypeKind.NONE && typeMirror.getKind() != TypeKind.VOID && !typeMirror.getKind().isPrimitive() && typeMirror.getKind() != TypeKind.OTHER && typeMirror.getKind() != TypeKind.NULL;
    }

    private static TypeElement findEnclosingClass(Element element) {
        if (element.getKind().isClass()) {
            return (TypeElement)element;
        }
        for (Element enclosing = element.getEnclosingElement(); enclosing != null && enclosing.getKind() != ElementKind.PACKAGE; enclosing = enclosing.getEnclosingElement()) {
            if (!enclosing.getKind().isClass()) continue;
            return (TypeElement)enclosing;
        }
        return null;
    }
}

