/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.serialization;

import com.oracle.truffle.js.runtime.array.TypedArrayFactory;

public enum ArrayBufferViewTag {
    INT8_ARRAY('b', TypedArrayFactory.Int8Array),
    UINT8_ARRAY('B', TypedArrayFactory.Uint8Array),
    UINT8_CLAMPED_ARRAY('C', TypedArrayFactory.Uint8ClampedArray),
    INT16_ARRAY('w', TypedArrayFactory.Int16Array),
    UINT16_ARRAY('W', TypedArrayFactory.Uint16Array),
    INT32_ARRAY('d', TypedArrayFactory.Int32Array),
    UINT32_ARRAY('D', TypedArrayFactory.Uint32Array),
    FLOAT32_ARRAY('f', TypedArrayFactory.Float32Array),
    FLOAT64_ARRAY('F', TypedArrayFactory.Float64Array),
    DATA_VIEW('?', null);

    private final byte tag;
    private final TypedArrayFactory factory;

    private ArrayBufferViewTag(char tag, TypedArrayFactory factory) {
        this.tag = (byte)tag;
        this.factory = factory;
    }

    public byte getTag() {
        return this.tag;
    }

    public TypedArrayFactory getFactory() {
        return this.factory;
    }

    public static ArrayBufferViewTag fromTag(byte tag) {
        for (ArrayBufferViewTag t : ArrayBufferViewTag.values()) {
            if (t.tag != tag) continue;
            return t;
        }
        return null;
    }

    public static ArrayBufferViewTag fromFactory(TypedArrayFactory factory) {
        for (ArrayBufferViewTag t : ArrayBufferViewTag.values()) {
            if (t.factory != factory) continue;
            return t;
        }
        return null;
    }
}

