/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.info;

import com.oracle.truffle.trufflenode.info.Accessor;
import com.oracle.truffle.trufflenode.info.FunctionTemplate;
import com.oracle.truffle.trufflenode.info.PropertyHandler;
import com.oracle.truffle.trufflenode.info.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ObjectTemplate {
    private List<Accessor> accessors;
    private List<Value> values;
    private PropertyHandler indexedPropertyHandler;
    private PropertyHandler namedPropertyHandler;
    private boolean stringKeysOnly;
    private FunctionTemplate functionHandler;
    private FunctionTemplate parentFunctionTemplate;

    public List<Accessor> getAccessors() {
        return this.accessors == null ? Collections.emptyList() : this.accessors;
    }

    public void addAccessor(Accessor accessor) {
        if (this.accessors == null) {
            this.accessors = new ArrayList<Accessor>();
        }
        this.accessors.add(accessor);
    }

    public List<Value> getValues() {
        return this.values == null ? Collections.emptyList() : this.values;
    }

    public void addValue(Value value) {
        if (this.values == null) {
            this.values = new ArrayList<Value>();
        }
        this.values.add(value);
    }

    public void setIndexedPropertyHandler(PropertyHandler indexedPropertyHandler) {
        this.indexedPropertyHandler = indexedPropertyHandler;
    }

    public PropertyHandler getIndexedPropertyHandler() {
        return this.indexedPropertyHandler;
    }

    public void setNamedPropertyHandler(PropertyHandler namedPropertyHandler, boolean stringKeysOnly) {
        this.namedPropertyHandler = namedPropertyHandler;
        this.stringKeysOnly = stringKeysOnly;
    }

    public PropertyHandler getNamedPropertyHandler() {
        return this.namedPropertyHandler;
    }

    public boolean getStringKeysOnly() {
        return this.stringKeysOnly;
    }

    public boolean hasPropertyHandler() {
        return this.namedPropertyHandler != null || this.indexedPropertyHandler != null;
    }

    public void setFunctionHandler(FunctionTemplate functionHandler) {
        this.functionHandler = functionHandler;
    }

    public FunctionTemplate getFunctionHandler() {
        return this.functionHandler;
    }

    public void setParentFunctionTemplate(FunctionTemplate parentFunctionTemplate) {
        this.parentFunctionTemplate = parentFunctionTemplate;
    }

    public FunctionTemplate getParentFunctionTemplate() {
        return this.parentFunctionTemplate;
    }
}

