/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.buffer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.buffer.NIOBufferAccessNode;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class NIOBufferUTF8WriteNode
extends NIOBufferAccessNode {
    @Node.Child
    protected JSToIntegerAsIntNode toInt;
    protected final BranchProfile nativePath = BranchProfile.create();
    protected final BranchProfile errorBranch = BranchProfile.create();

    public NIOBufferUTF8WriteNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
        this.toInt = JSToIntegerAsIntNode.create();
    }

    private DynamicObject getNativeUtf8Write() {
        return GraalJSAccess.getRealmEmbedderData(this.getContext().getRealm()).getNativeUtf8Write();
    }

    @Specialization(guards={"accept(target)"})
    public Object write(DynamicObject target, String str, int destOffset, int bytes) {
        try {
            return this.doWrite(target, str, destOffset, bytes);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization(guards={"accept(target)", "isUndefined(bytes)"})
    public Object writeDefaultOffset(DynamicObject target, String str, int destOffset, Object bytes) {
        try {
            return this.doWrite(target, str, destOffset, NIOBufferUTF8WriteNode.getBytes(str).length);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization(guards={"accept(target)", "isUndefined(destOffset)", "isUndefined(bytes)"})
    public Object writeDefaultValues(DynamicObject target, String str, Object destOffset, Object bytes) {
        try {
            return this.doWrite(target, str, 0, NIOBufferUTF8WriteNode.getBytes(str).length);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization(guards={"accept(target)"})
    public Object write(DynamicObject target, String str, double destOffset, double bytes) {
        try {
            return this.doWrite(target, str, this.toInt.executeInt((Object)destOffset), this.toInt.executeInt((Object)bytes));
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, str, destOffset, bytes);
        }
    }

    @Specialization
    public Object writeDefault(DynamicObject target, Object str, Object destOffset, Object bytes) {
        return JSFunction.call((DynamicObject)this.getNativeUtf8Write(), (Object)target, (Object[])new Object[]{str, destOffset, bytes});
    }

    @Specialization(guards={"!isJSArrayBufferView(target)"})
    public Object writeAbort(Object target, Object str, Object destOffset, Object bytes) {
        throw Errors.createTypeErrorArrayBufferViewExpected();
    }

    private Object doNativeFallback(DynamicObject target, String str, Object destOffset, Object bytes) {
        this.nativePath.enter();
        return JSFunction.call((DynamicObject)this.getNativeUtf8Write(), (Object)target, (Object[])new Object[]{str, destOffset, bytes});
    }

    private int doWrite(DynamicObject target, String str, int destOffset, int bytes) throws CharacterCodingException {
        DynamicObject arrayBuffer = NIOBufferUTF8WriteNode.getArrayBuffer(target);
        int bufferOffset = this.getOffset(target);
        int bufferLen = this.getLength(target);
        if (destOffset > bufferLen || bytes < 0 || destOffset < 0) {
            this.errorBranch.enter();
            this.outOfBoundsFail();
        }
        ByteBuffer rawBuffer = NIOBufferUTF8WriteNode.getDirectByteBuffer(arrayBuffer);
        int destLimit = Math.min(bufferLen, destOffset + bytes);
        ByteBuffer buffer = Boundaries.byteBufferSlice((ByteBuffer)rawBuffer, (int)(bufferOffset + destOffset), (int)(bufferOffset + destLimit));
        NIOBufferUTF8WriteNode.doEncode(str, buffer);
        return buffer.position();
    }

    @CompilerDirectives.TruffleBoundary
    private static CoderResult doEncode(String str, ByteBuffer buffer) throws CharacterCodingException {
        CharsetEncoder encoder = utf8.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPORT);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cb = CharBuffer.wrap(str);
        CoderResult res = encoder.encode(cb, buffer, true);
        if (res.isUnderflow()) {
            encoder.encode(cb, buffer, true);
            res = encoder.flush(buffer);
        }
        assert (res.isError() == (res.isMalformed() || res.isUnmappable()));
        if (res.isError()) {
            res.throwException();
        }
        return res;
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] getBytes(String str) {
        return str.getBytes(utf8);
    }
}

