/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public interface TruffleObjectArrayItemNode<O extends TruffleObject> {
    public ArrayItemValue getItem();

    public String getItemName();

    public static class Renderer
    extends MultiRenderer
    implements HeapViewerRenderer {
        private final NormalBoldGrayRenderer fieldRenderer;
        private final LabelRenderer equalsRenderer;
        private final TruffleObjectNode.Renderer dobjectRenderer;
        private final ProfilerRenderer[] renderers;
        private final Heap heap;

        public Renderer(Heap heap, Icon icon) {
            this(heap, icon, "=");
        }

        public Renderer(Heap heap, Icon icon, String divider) {
            this.heap = heap;
            this.fieldRenderer = new NormalBoldGrayRenderer(){

                public void setValue(Object value, int row) {
                    TruffleObjectArrayItemNode node = (TruffleObjectArrayItemNode)value;
                    String name = node.getItemName();
                    if (name.startsWith("static ")) {
                        this.setNormalValue("static ");
                        this.setBoldValue(name.substring("static ".length()));
                    } else {
                        this.setNormalValue("");
                        this.setBoldValue(name);
                    }
                    this.setIcon(Icons.getIcon((String)"ProfilerIcons.NodeForward"));
                }
            };
            this.equalsRenderer = new LabelRenderer(){

                public String toString() {
                    return " " + this.getText() + " ";
                }
            };
            this.equalsRenderer.setText(divider);
            this.equalsRenderer.setMargin(3, 0, 3, 0);
            this.dobjectRenderer = new TruffleObjectNode.Renderer(heap, icon);
            this.renderers = new ProfilerRenderer[]{this.fieldRenderer, this.equalsRenderer, this.dobjectRenderer};
        }

        protected ProfilerRenderer[] valueRenderers() {
            return this.renderers;
        }

        public void setValue(Object value, int row) {
            HeapViewerNode node = (HeapViewerNode)value;
            HeapViewerNode loop = (HeapViewerNode)HeapViewerNode.getValue((HeapViewerNode)node, (DataType)DataType.LOOP, (Heap)this.heap);
            if (loop != null) {
                node = loop;
            }
            this.fieldRenderer.setValue((Object)node, row);
            this.dobjectRenderer.setValue(value, row);
        }

        public Icon getIcon() {
            return this.fieldRenderer.getIcon();
        }

        public String getShortName() {
            return this.fieldRenderer.toString();
        }
    }

    public static abstract class InstanceBased<O extends TruffleObject.InstanceBased>
    extends TruffleObjectNode.InstanceBased<O>
    implements TruffleObjectArrayItemNode<O> {
        private ArrayItemValue item;

        public InstanceBased(O object, String type, ArrayItemValue item) {
            super(object, type);
            this.item = item;
        }

        @Override
        public String getName(Heap heap) {
            return this.getItemName() + " = " + this.getObjectName(heap);
        }

        @Override
        public String getItemName() {
            return "[" + this.item.getIndex() + "]";
        }

        @Override
        public ArrayItemValue getItem() {
            return this.item;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceBased)) {
                return false;
            }
            return this.item.equals(((InstanceBased)o).item);
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public InstanceNode createCopy() {
            return null;
        }

        protected void setupCopy(InstanceBased copy) {
            super.setupCopy(copy);
            copy.item = this.item;
        }
    }
}

