/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptLanguage;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

class JavaScriptObject
extends DynamicObject {
    JavaScriptObject(Instance instance) {
        super(instance);
    }

    JavaScriptObject(String type, Instance instance) {
        super(type, instance);
    }

    @Override
    protected String computeType(Heap heap) {
        return ((JavaScriptHeapFragment)((Object)JavaScriptLanguage.instance().fragmentFromHeap(heap))).getObjectType(this.getInstance(), this.getShape());
    }

    String computeDisplayType(Heap heap) {
        String type = this.getType(heap);
        if (type.startsWith("<") && (type = super.computeType(heap)).startsWith("JS")) {
            type = type.substring(2);
        }
        return type;
    }

    boolean isJavaScriptObject() {
        return "com.oracle.truffle.js.runtime.builtins.JSClass".equals(this.getLanguageId().getName());
    }

    static boolean isJavaScriptObject(Instance instance) {
        return DynamicObject.isDynamicObject(instance) && "com.oracle.truffle.js.runtime.builtins.JSClass".equals(DynamicObject.getLanguageId(instance).getName());
    }
}

