/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

public class TruffleObjectsProvider<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>> {
    private final L language;

    public TruffleObjectsProvider(L language) {
        this.language = language;
    }

    public HeapViewerNode[] getAllObjects(HeapViewerNode parent, HeapContext context, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress, int aggregation) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        HeapViewerNode[] nodes;
        final TruffleLanguageHeapFragment fragment = (TruffleLanguageHeapFragment)context.getFragment();
        final Heap heap = fragment.getHeap();
        if (aggregation == 0) {
            NodesComputer computer = new NodesComputer<O>(UIThresholds.MAX_TOPLEVEL_INSTANCES){

                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                protected HeapViewerNode createNode(O object) {
                    return (HeapViewerNode)TruffleObjectsProvider.this.language.createObjectNode(object, ((TruffleObject)object).getType(heap));
                }

                protected ProgressIterator<O> objectsIterator(int index, Progress progress) {
                    Iterator objects = fragment.getObjectsIterator();
                    return new ProgressIterator(objects, index, true, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectsProvider_MoreNodesObjects(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectsProvider_SamplesContainerObjects(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectsProvider_NodesContainerObjects(firstNodeIdx, lastNodeIdx);
                }
            };
            nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        } else {
            NodesComputer computer = new NodesComputer<T>(UIThresholds.MAX_TOPLEVEL_CLASSES){

                protected boolean sorts(DataType dataType) {
                    return true;
                }

                protected HeapViewerNode createNode(T type) {
                    return TruffleObjectsProvider.this.language.createTypeNode(type, heap);
                }

                protected ProgressIterator<T> objectsIterator(int index, Progress progress) {
                    List types = fragment.getTypes(progress);
                    ListIterator typesI = types.listIterator(index);
                    return new ProgressIterator(typesI, index, false, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectsProvider_MoreNodesTypes(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectsProvider_SamplesContainerTypes(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectsProvider_NodesContainerTypes(firstNodeIdx, lastNodeIdx);
                }
            };
            nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        }
        if (nodes == null || nodes.length > 0) {
            heapViewerNodeArray = nodes;
        } else {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(Bundle.TruffleObjectsProvider_NoObjects());
        }
        return heapViewerNodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapViewerNode[] getDominators(HeapViewerNode parent, HeapContext context, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress, int aggregation) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        HeapViewerNode[] nodes;
        final Heap heap = context.getFragment().getHeap();
        if (!DataType.RETAINED_SIZE.valuesAvailable(heap)) {
            return new HeapViewerNode[]{new TextNode(Bundle.TruffleObjectsProvider_NoRetainedSizes())};
        }
        int maxSearchInstances = 10000;
        List searchInstances = heap.getBiggestObjectsByRetainedSize(maxSearchInstances);
        Iterator searchInstancesIt = searchInstances.iterator();
        try {
            progress.setupKnownSteps((long)searchInstances.size());
            while (searchInstancesIt.hasNext()) {
                Instance instance = (Instance)searchInstancesIt.next();
                progress.step();
                if (((TruffleLanguage)((Object)this.language)).isLanguageObject(instance)) continue;
                searchInstancesIt.remove();
            }
        }
        finally {
            progress.finish();
        }
        final ArrayList<Instance> dominators = new ArrayList<Instance>(TruffleObjectsProvider.getDominatorRoots(searchInstances));
        if (aggregation == 0) {
            NodesComputer<Instance> computer = new NodesComputer<Instance>(UIThresholds.MAX_TOPLEVEL_INSTANCES){

                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                protected HeapViewerNode createNode(Instance instance) {
                    Object object = TruffleObjectsProvider.this.language.createObject(instance);
                    return (HeapViewerNode)TruffleObjectsProvider.this.language.createObjectNode(object, ((TruffleObject)object).getType(heap));
                }

                protected ProgressIterator<Instance> objectsIterator(int index, Progress progress) {
                    ListIterator dominatorsIt = dominators.listIterator(index);
                    return new ProgressIterator(dominatorsIt, index, false, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectsProvider_MoreNodesDominators(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectsProvider_SamplesContainerDominators(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectsProvider_NodesContainerDominators(firstNodeIdx, lastNodeIdx);
                }
            };
            nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        } else {
            TruffleType.TypesComputer tcomputer = new TruffleType.TypesComputer(this.language, heap);
            try {
                progress.setupKnownSteps((long)dominators.size());
                for (Instance dominator : dominators) {
                    progress.step();
                    tcomputer.addObject(((TruffleLanguage)((Object)this.language)).createObject(dominator));
                }
            }
            finally {
                progress.finish();
            }
            final List types = tcomputer.getTypes();
            NodesComputer computer = new NodesComputer<T>(UIThresholds.MAX_TOPLEVEL_INSTANCES){

                protected boolean sorts(DataType dataType) {
                    return true;
                }

                protected HeapViewerNode createNode(T type) {
                    return TruffleObjectsProvider.this.language.createTypeNode(type, heap);
                }

                protected ProgressIterator<T> objectsIterator(int index, Progress progress) {
                    ListIterator typesIt = types.listIterator(index);
                    return new ProgressIterator(typesIt, index, false, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectsProvider_MoreNodesDominators(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectsProvider_SamplesContainerDominators(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectsProvider_NodesContainerDominators(firstNodeIdx, lastNodeIdx);
                }
            };
            nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        }
        if (nodes.length > 0) {
            heapViewerNodeArray = nodes;
        } else {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(Bundle.TruffleObjectsProvider_NoDominators());
        }
        return heapViewerNodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapViewerNode[] getGCRoots(HeapViewerNode parent, HeapContext context, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress, int aggregation) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        HeapViewerNode[] nodes;
        final Heap heap = context.getFragment().getHeap();
        Collection gcroots = heap.getGCRoots();
        final List gcrootInstances = gcroots.stream().map(GCRoot::getInstance).distinct().collect(Collectors.toList());
        try {
            progress.setupUnknownSteps();
            Iterator gcrootsI = gcrootInstances.iterator();
            while (gcrootsI.hasNext()) {
                Instance instance = (Instance)gcrootsI.next();
                if (!((TruffleLanguage)((Object)this.language)).isLanguageObject(instance)) {
                    gcrootsI.remove();
                }
                progress.step();
            }
        }
        finally {
            progress.finish();
        }
        if (aggregation == 0) {
            NodesComputer<Instance> computer = new NodesComputer<Instance>(UIThresholds.MAX_TOPLEVEL_INSTANCES){

                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                protected HeapViewerNode createNode(Instance gcRootInstance) {
                    Object object = TruffleObjectsProvider.this.language.createObject(gcRootInstance);
                    return (HeapViewerNode)TruffleObjectsProvider.this.language.createObjectNode(object, ((TruffleObject)object).getType(heap));
                }

                protected ProgressIterator<Instance> objectsIterator(int index, Progress progress) {
                    ListIterator iterator = gcrootInstances.listIterator(index);
                    return new ProgressIterator(iterator, index, false, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectsProvider_MoreNodesGcRoots(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectsProvider_SamplesContainerGcRoots(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectsProvider_NodesContainerGcRoots(firstNodeIdx, lastNodeIdx);
                }
            };
            nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        } else {
            TruffleType.TypesComputer tcomputer = new TruffleType.TypesComputer(this.language, heap);
            try {
                progress.setupUnknownSteps();
                for (Instance gcroot : gcrootInstances) {
                    tcomputer.addObject(((TruffleLanguage)((Object)this.language)).createObject(gcroot));
                    progress.step();
                }
            }
            finally {
                progress.finish();
            }
            final List types = tcomputer.getTypes();
            NodesComputer computer = new NodesComputer<T>(UIThresholds.MAX_TOPLEVEL_INSTANCES){

                protected boolean sorts(DataType dataType) {
                    return true;
                }

                protected HeapViewerNode createNode(T type) {
                    return TruffleObjectsProvider.this.language.createTypeNode(type, heap);
                }

                protected ProgressIterator<T> objectsIterator(int index, Progress progress) {
                    ListIterator typesIt = types.listIterator(index);
                    return new ProgressIterator(typesIt, index, false, progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectsProvider_MoreNodesGcRoots(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectsProvider_SamplesContainerGcRoots(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectsProvider_NodesContainerGcRoots(firstNodeIdx, lastNodeIdx);
                }
            };
            nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        }
        if (nodes.length > 0) {
            heapViewerNodeArray = nodes;
        } else {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(Bundle.TruffleObjectsProvider_NoGcRoots());
        }
        return heapViewerNodeArray;
    }

    public static Set<Instance> getDominatorRoots(List<Instance> searchInstances) {
        HashSet<Instance> dominators = new HashSet<Instance>(searchInstances);
        HashSet<Instance> removed = new HashSet<Instance>();
        block0: for (Instance instance : searchInstances) {
            if (!dominators.contains(instance)) continue;
            Instance dom = instance;
            long retainedSize = instance.getRetainedSize();
            while (!instance.isGCRoot()) {
                if (dominators.contains(instance = instance.getNearestGCRootPointer()) && instance.getRetainedSize() >= retainedSize) {
                    dominators.remove(dom);
                    removed.add(dom);
                    dom = instance;
                    retainedSize = instance.getRetainedSize();
                }
                if (!removed.contains(instance)) continue;
                dominators.remove(dom);
                removed.add(dom);
                continue block0;
            }
        }
        return dominators;
    }
}

