/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.word.WordBase;

public class SerializationChecksumCalculator {
    private static MessageDigest createMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5");
    }

    private static void updateMessageDigest(MessageDigest md, long value) {
        byte[] longBytes = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
        md.update(longBytes);
    }

    private static String messageDigestResult(MessageDigest md) {
        return LambdaUtils.toHex((byte[])md.digest());
    }

    private static void updateMessageDigest(MessageDigest md, String value) {
        md.update(value.getBytes(StandardCharsets.UTF_8));
    }

    public static abstract class JavaCalculator {
        public String calculateChecksum(String targetConstructorClassName, String serializationClassName, Class<?> serializationClass) throws NoSuchAlgorithmException {
            if (this.isClassAbstract(serializationClass)) {
                return "0";
            }
            Holder.printUsageWarning();
            MessageDigest md = SerializationChecksumCalculator.createMessageDigest();
            if (targetConstructorClassName != null && targetConstructorClassName.length() > 0) {
                String currentClassName = serializationClassName;
                Class<?> currentClass = serializationClass;
                while (!targetConstructorClassName.equals(currentClassName)) {
                    long classSUID = this.calculateFromComputeDefaultSUID(currentClass);
                    SerializationChecksumCalculator.updateMessageDigest(md, classSUID);
                    currentClass = this.getSuperClass(currentClass);
                    currentClassName = this.getClassName(currentClass);
                }
                SerializationChecksumCalculator.updateMessageDigest(md, targetConstructorClassName);
            }
            return SerializationChecksumCalculator.messageDigestResult(md);
        }

        protected abstract String getClassName(Class<?> var1);

        protected abstract Class<?> getSuperClass(Class<?> var1);

        protected abstract Long calculateFromComputeDefaultSUID(Class<?> var1);

        protected abstract boolean isClassAbstract(Class<?> var1);
    }

    private static class Holder {
        static final boolean warningPrinted;

        private Holder() {
        }

        public static boolean printUsageWarning() {
            return warningPrinted;
        }

        static {
            System.out.println("Warning: Object checksum calculation is not resistant against collisions. Deserialization of untrusted data is not supported.");
            warningPrinted = true;
        }
    }

    public static abstract class JVMCIAgentCalculator {
        public String calculateChecksum(String targetConstructorClassName, String serializationClassName, WordBase serializationClass) throws NoSuchAlgorithmException {
            if (this.isClassAbstract(serializationClass)) {
                return "0";
            }
            MessageDigest md = SerializationChecksumCalculator.createMessageDigest();
            if (targetConstructorClassName != null && targetConstructorClassName.length() > 0) {
                String currentClassName = serializationClassName;
                WordBase currentClass = serializationClass;
                while (!targetConstructorClassName.equals(currentClassName)) {
                    long classSUID = this.calculateFromComputeDefaultSUID(currentClass);
                    SerializationChecksumCalculator.updateMessageDigest(md, classSUID);
                    currentClass = this.getSuperClass(currentClass);
                    currentClassName = this.getClassName(currentClass);
                }
                SerializationChecksumCalculator.updateMessageDigest(md, targetConstructorClassName);
            }
            return SerializationChecksumCalculator.messageDigestResult(md);
        }

        protected abstract String getClassName(WordBase var1);

        protected abstract WordBase getSuperClass(WordBase var1);

        protected abstract Long calculateFromComputeDefaultSUID(WordBase var1);

        protected abstract boolean isClassAbstract(WordBase var1);
    }
}

