/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.threaddump.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceRepository;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.coredump.CoreDump;
import org.graalvm.visualvm.threaddump.ThreadDumpSupport;
import org.graalvm.visualvm.threaddump.impl.ThreadDumpImpl;
import org.graalvm.visualvm.tools.sa.SaModel;
import org.graalvm.visualvm.tools.sa.SaModelFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ThreadDumpProvider {
    public void createThreadDump(final Application application, final boolean openView) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle pHandleF;
                Jvm jvm = JvmFactory.getJVMFor((Application)application);
                if (!jvm.isTakeThreadDumpSupported()) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)(NbBundle.getMessage(ThreadDumpProvider.class, (String)"MSG_Cannot_take_thread_dump_for_") + DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName()), 0));
                    return;
                }
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ThreadDumpProvider.class, (String)"MSG_Creating_Thread_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        final ThreadDumpImpl threadDump = new ThreadDumpImpl(jvm.takeThreadDump(), (DataSource)application);
                        application.getRepository().addDataSource((DataSource)threadDump);
                        if (openView) {
                            DataSource.EVENT_QUEUE.post(new Runnable(){

                                @Override
                                public void run() {
                                    DataSourceWindowManager.sharedInstance().openDataSource((DataSource)threadDump);
                                }
                            });
                        }
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        @Override
                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void createThreadDump(final CoreDump coreDump, final boolean openView) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ThreadDumpProvider.class, (String)"MSG_Creating_Thread_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    File snapshotDir = coreDump.getStorage().getDirectory();
                    String name = ThreadDumpSupport.getInstance().getCategory().createFileName();
                    File dumpFile = new File(snapshotDir, name);
                    SaModel saAget = SaModelFactory.getSAAgentFor((DataSource)coreDump);
                    String dump = saAget.takeThreadDump();
                    if (dump != null) {
                        try {
                            FileOutputStream os = new FileOutputStream(dumpFile);
                            ((OutputStream)os).write(dump.getBytes("UTF-8"));
                            ((OutputStream)os).close();
                            final ThreadDumpImpl threadDump = new ThreadDumpImpl(dumpFile, (DataSource)coreDump);
                            coreDump.getRepository().addDataSource((DataSource)threadDump);
                            if (openView) {
                                DataSource.EVENT_QUEUE.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)threadDump);
                                    }
                                });
                            }
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        @Override
                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof ThreadDumpImpl) {
            return;
        }
        boolean appSnapshot = snapshot instanceof ApplicationSnapshot;
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            File[] files = snapshotFile.listFiles(ThreadDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<ThreadDumpImpl> threadDumps = new HashSet<ThreadDumpImpl>();
            for (File file : files) {
                ThreadDumpImpl threadDump = new ThreadDumpImpl(file, (DataSource)snapshot);
                if (appSnapshot) {
                    threadDump.forceViewClosable(true);
                }
                threadDumps.add(new ThreadDumpImpl(file, (DataSource)snapshot));
            }
            snapshot.getRepository().addDataSources(threadDumps);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            File[] files = storage.getDirectory().listFiles(ThreadDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<ThreadDumpImpl> threadDumps = new HashSet<ThreadDumpImpl>();
            for (File file : files) {
                threadDumps.add(new ThreadDumpImpl(file, (DataSource)application));
            }
            application.getRepository().addDataSources(threadDumps);
        }
    }

    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Application application : applications) {
                            ThreadDumpProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            ThreadDumpProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

