/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.promise.UnwrapPromiseNode;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.interop.InteropAsyncFunction;
import com.oracle.truffle.js.runtime.interop.InteropFunction;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InteropAsyncFunction.class)
final class InteropAsyncFunctionGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private InteropAsyncFunctionGen() {
    }

    static {
        LibraryExport.register(InteropAsyncFunction.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=InteropAsyncFunction.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet((LibraryFactory)InteropAsyncFunctionGen.access$100(), (String[])new String[]{"isIdenticalOrUndefined", "identityHashCode", "isExecutable", "execute"});

        private InteropLibraryExports() {
            super(InteropLibrary.class, InteropAsyncFunction.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof InteropAsyncFunction);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Uncached());
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof InteropAsyncFunction);
            return (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=InteropAsyncFunction.class)
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((InteropAsyncFunction)receiver_).function;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropAsyncFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof InteropAsyncFunction;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isIdenticalOrUndefined(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropFunction)receiver).identityHashCode();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropAsyncFunction)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropAsyncFunction arg0Value = (InteropAsyncFunction)arg0Value_;
                return arg0Value.execute(arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropExecuteNodeGen.getUncached(), ExportValueNode.getUncached(), UnwrapPromiseNode.getUncached());
            }
        }

        @GeneratedBy(value=InteropAsyncFunction.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverFunctionInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @Node.Child
            private InteropLibrary isIdenticalOrUndefinedNode__thisLib_;
            @Node.Child
            private InteropLibrary isIdenticalOrUndefinedNode__otherLib_;
            @Node.Child
            private JSInteropExecuteNode executeNode__callNode_;
            @Node.Child
            private ExportValueNode executeNode__exportNode_;
            @Node.Child
            private UnwrapPromiseNode executeNode__unwrapPromise_;

            protected Cached(Object receiver) {
                InteropAsyncFunction castReceiver = (InteropAsyncFunction)receiver;
                this.receiverFunctionInteropLibrary_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver.function)));
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((InteropAsyncFunction)receiver_).function;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverFunctionInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropAsyncFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof InteropAsyncFunction)) {
                    return false;
                }
                return this.receiverFunctionInteropLibrary_.accepts((Object)((InteropAsyncFunction)receiver).function);
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (arg0Value_ instanceof InteropAsyncFunction) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                InteropAsyncFunction arg0Value = (InteropAsyncFunction)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    return arg0Value.isIdenticalOrUndefined(arg1Value, this.isIdenticalOrUndefinedNode__thisLib_, this.isIdenticalOrUndefinedNode__otherLib_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TriState isIdenticalOrUndefinedNode_AndSpecialize(InteropFunction arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.isIdenticalOrUndefinedNode__thisLib_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    this.isIdenticalOrUndefinedNode__otherLib_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    TriState triState = arg0Value.isIdenticalOrUndefined(arg1Value, this.isIdenticalOrUndefinedNode__thisLib_, this.isIdenticalOrUndefinedNode__otherLib_);
                    return triState;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof InteropAsyncFunction) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((InteropAsyncFunction)receiver).identityHashCode();
            }

            public boolean isExecutable(Object receiver) {
                assert (receiver instanceof InteropAsyncFunction) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((InteropAsyncFunction)receiver).isExecutable();
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (arg0Value_ instanceof InteropAsyncFunction) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                InteropAsyncFunction arg0Value = (InteropAsyncFunction)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage executeNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm executeNode__realm__ = (JSRealm)javaScriptLanguageContextReference__.get();
                    return arg0Value.execute(arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.executeNode__exportNode_, this.executeNode__unwrapPromise_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(InteropAsyncFunction arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    JSRealm executeNode__realm__ = null;
                    JavaScriptLanguage executeNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    executeNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    executeNode__realm__ = (JSRealm)javaScriptLanguageContextReference__1.get();
                    this.executeNode__callNode_ = (JSInteropExecuteNode)super.insert((Node)JSInteropExecuteNodeGen.create());
                    this.executeNode__exportNode_ = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    this.executeNode__unwrapPromise_ = (UnwrapPromiseNode)super.insert((Node)UnwrapPromiseNode.create(executeNode__realm__.getContext()));
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.execute(arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.executeNode__exportNode_, this.executeNode__unwrapPromise_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

