/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.BigEndianByteArrayAccess;
import com.oracle.truffle.js.runtime.array.ByteArrayAccess;
import com.oracle.truffle.js.runtime.array.LittleEndianByteArrayAccess;
import java.nio.ByteOrder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ByteArraySupport {
    private ByteArraySupport() {
    }

    static ByteArrayAccess littleEndian() {
        return LittleEndianByteArrayAccess.INSTANCE;
    }

    static ByteArrayAccess bigEndian() {
        return BigEndianByteArrayAccess.INSTANCE;
    }

    static ByteArrayAccess nativeOrder() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? ByteArraySupport.littleEndian() : ByteArraySupport.bigEndian();
    }
}

