/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseReactionJobNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.PromiseReactionRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.Triple;
import java.util.Set;

public class ImportCallNode
extends JavaScriptNode {
    @Node.Child
    private JavaScriptNode argRefNode;
    @Node.Child
    private JavaScriptNode activeScriptOrModuleNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private JSToStringNode toStringNode;
    @Node.Child
    private PromiseReactionJobNode promiseReactionJobNode;
    @Node.Child
    private JSFunctionCallNode callRejectNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
    @Node.Child
    private InteropLibrary exceptions;
    private final JSContext context;

    protected ImportCallNode(JSContext context, JavaScriptNode argRefNode, JavaScriptNode activeScriptOrModuleNode) {
        this.context = context;
        this.argRefNode = argRefNode;
        this.activeScriptOrModuleNode = activeScriptOrModuleNode;
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.toStringNode = JSToStringNode.create();
        this.promiseReactionJobNode = PromiseReactionJobNode.create(context);
    }

    public static ImportCallNode create(JSContext context, JavaScriptNode argRefNode, JavaScriptNode activeScriptOrModuleNode) {
        return new ImportCallNode(context, argRefNode, activeScriptOrModuleNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        String specifierString;
        Object referencingScriptOrModule = this.getActiveScriptOrModule(frame);
        Object specifier = this.argRefNode.execute(frame);
        try {
            specifierString = this.toStringNode.executeString(specifier);
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                return this.newRejectedPromiseFromException(ex);
            }
            throw ex;
        }
        return this.hostImportModuleDynamically(referencingScriptOrModule, specifierString);
    }

    private Object getActiveScriptOrModule(VirtualFrame frame) {
        if (this.activeScriptOrModuleNode != null) {
            return this.activeScriptOrModuleNode.execute(frame);
        }
        return new ScriptOrModule(this.context, this.getEncapsulatingSourceSection().getSource());
    }

    private DynamicObject hostImportModuleDynamically(Object referencingScriptOrModule, String specifier) {
        JSRealm realm = this.context.getRealm();
        if (this.context.hasImportModuleDynamicallyCallbackBeenSet()) {
            DynamicObject promise = this.context.hostImportModuleDynamically(realm, (ScriptOrModule)referencingScriptOrModule, specifier);
            if (promise == null) {
                return this.newRejectedPromiseFromException((Throwable)((Object)ImportCallNode.createTypeErrorCannotImport(specifier)));
            }
            assert (JSPromise.isJSPromise(promise));
            return promise;
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.context.promiseEnqueueJob(realm, this.createImportModuleDynamicallyJob((ScriptOrModule)referencingScriptOrModule, specifier, promiseCapability));
        return promiseCapability.getPromise();
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        if (this.newPromiseCapabilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.newPromiseCapabilityNode = (NewPromiseCapabilityNode)this.insert(NewPromiseCapabilityNode.create(this.context));
        }
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private DynamicObject newRejectedPromiseFromException(Throwable ex) {
        if (this.callRejectNode == null || this.getErrorObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.callRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), this.getErrorObjectNode.execute(ex)));
        return promiseCapability.getPromise();
    }

    private InteropLibrary exceptions() {
        InteropLibrary e = this.exceptions;
        if (e == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptions = e = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
        }
        return e;
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createTypeErrorCannotImport(String specifier) {
        return Errors.createError("Cannot dynamically import module: " + specifier);
    }

    public DynamicObject createImportModuleDynamicallyJob(ScriptOrModule referencingScriptOrModule, String specifier, PromiseCapabilityRecord promiseCapability) {
        if (this.context.isOptionTopLevelAwait()) {
            Triple<ScriptOrModule, String, PromiseCapabilityRecord> request = new Triple<ScriptOrModule, String, PromiseCapabilityRecord>(referencingScriptOrModule, specifier, promiseCapability);
            PromiseCapabilityRecord startModuleLoadCapability = this.newPromiseCapability();
            PromiseReactionRecord startModuleLoad = PromiseReactionRecord.create(startModuleLoadCapability, this.createImportModuleDynamicallyHandler(), true);
            return this.promiseReactionJobNode.execute(startModuleLoad, request);
        }
        Pair<ScriptOrModule, String> request = new Pair<ScriptOrModule, String>(referencingScriptOrModule, specifier);
        return this.promiseReactionJobNode.execute(PromiseReactionRecord.create(promiseCapability, this.createImportModuleDynamicallyHandler(), true), request);
    }

    private DynamicObject createImportModuleDynamicallyHandler() {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ImportModuleDynamically, c -> ImportCallNode.createImportModuleDynamicallyHandlerImpl(c));
        return JSFunction.create(this.context.getRealm(), functionData);
    }

    private static JSFunctionData createImportModuleDynamicallyHandlerImpl(JSContext context) {
        class TopLevelAwaitImportModuleDynamicallyRootNode
        extends ImportModuleDynamicallyRootNode {
            @Node.Child
            private PerformPromiseThenNode promiseThenNode;
            @Node.Child
            private JSFunctionCallNode callPromiseReaction;
            @Node.Child
            private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
            @Node.Child
            private InteropLibrary exceptions;
            final /* synthetic */ JSContext val$context;

            TopLevelAwaitImportModuleDynamicallyRootNode(JSContext jSContext) {
                this.val$context = jSContext;
                class ImportModuleDynamicallyRootNode
                extends JavaScriptRootNode {
                    @Node.Child
                    protected JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);
                    final /* synthetic */ JSContext val$context;

                    ImportModuleDynamicallyRootNode(JSContext jSContext) {
                        this.val$context = jSContext;
                    }

                    public Object execute(VirtualFrame frame) {
                        Pair request = (Pair)this.argumentNode.execute(frame);
                        ScriptOrModule referencingScriptOrModule = (ScriptOrModule)request.getFirst();
                        String specifier = (String)request.getSecond();
                        JSModuleRecord moduleRecord = this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, specifier);
                        return this.finishDynamicImport(this.val$context.getRealm(), moduleRecord, referencingScriptOrModule, specifier);
                    }

                    protected Object finishDynamicImport(JSRealm realm, JSModuleRecord moduleRecord, ScriptOrModule referencingScriptOrModule, String specifier) {
                        this.val$context.getEvaluator().moduleInstantiation(realm, moduleRecord);
                        this.val$context.getEvaluator().moduleEvaluation(realm, moduleRecord);
                        if (moduleRecord.getEvaluationError() != null) {
                            throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
                        }
                        assert (moduleRecord == this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, specifier));
                        assert (moduleRecord.isEvaluated());
                        return this.val$context.getEvaluator().getModuleNamespace(moduleRecord);
                    }
                }
                super(jSContext);
                this.promiseThenNode = PerformPromiseThenNode.create(this.val$context);
                this.callPromiseReaction = JSFunctionCallNode.createCall();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Triple request = (Triple)this.argumentNode.execute(frame);
                ScriptOrModule referencingScriptOrModule = (ScriptOrModule)request.getFirst();
                String specifier = (String)request.getSecond();
                PromiseCapabilityRecord moduleLoadedCapability = (PromiseCapabilityRecord)request.getThird();
                try {
                    JSModuleRecord moduleRecord = this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, specifier);
                    JSRealm realm = this.val$context.getRealm();
                    if (moduleRecord.isTopLevelAsync()) {
                        this.val$context.getEvaluator().moduleInstantiation(realm, moduleRecord);
                        Object moduleLoadedStartPromise = this.val$context.getEvaluator().moduleEvaluation(realm, moduleRecord);
                        assert (JSPromise.isJSPromise(moduleLoadedStartPromise));
                        this.promiseThenNode.execute((DynamicObject)moduleLoadedStartPromise, moduleLoadedCapability.getResolve(), moduleLoadedCapability.getReject(), moduleLoadedCapability);
                    } else {
                        Object result = this.finishDynamicImport(realm, moduleRecord, referencingScriptOrModule, specifier);
                        if (moduleRecord.isAsyncEvaluating()) {
                            PromiseCapabilityRecord topLevelCapability = moduleRecord.getTopLevelCapability();
                            this.promiseThenNode.execute(topLevelCapability.getPromise(), moduleLoadedCapability.getResolve(), moduleLoadedCapability.getReject(), null);
                        } else {
                            this.callPromiseReaction.executeCall(JSArguments.create((Object)Undefined.instance, moduleLoadedCapability.getResolve(), result));
                        }
                    }
                }
                catch (Throwable t) {
                    if (this.shouldCatch(t)) {
                        Object errorObject = this.getErrorObjectNode.execute(t);
                        this.callPromiseReaction.executeCall(JSArguments.create((Object)Undefined.instance, moduleLoadedCapability.getReject(), errorObject));
                    }
                    throw t;
                }
                return Undefined.instance;
            }

            private boolean shouldCatch(Throwable exception) {
                if (this.getErrorObjectNode == null || this.exceptions == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.val$context));
                    this.exceptions = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
                }
                return TryCatchNode.shouldCatch(exception, this.exceptions);
            }
        }
        ImportModuleDynamicallyRootNode root = context.isOptionTopLevelAwait() ? new TopLevelAwaitImportModuleDynamicallyRootNode(context) : new ImportModuleDynamicallyRootNode(context);
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)root);
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 0, "");
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ImportCallNode.create(this.context, ImportCallNode.cloneUninitialized(this.argRefNode, materializedTags), ImportCallNode.cloneUninitialized(this.activeScriptOrModuleNode, materializedTags));
    }
}

