/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.intl.DefaultNumberOptionNode;
import com.oracle.truffle.js.nodes.intl.GetNumberOptionNode;
import com.oracle.truffle.js.nodes.intl.SetNumberFormatDigitOptionsNodeGen;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class SetNumberFormatDigitOptionsNode
extends JavaScriptBaseNode {
    @Node.Child
    GetNumberOptionNode getMinIntDigitsOption;
    @Node.Child
    PropertyGetNode getMinFracDigitsOption;
    @Node.Child
    PropertyGetNode getMaxFracDigitsOption;
    @Node.Child
    PropertyGetNode getMinSignificantDigitsOption;
    @Node.Child
    PropertyGetNode getMaxSignificantDigitsOption;
    @Node.Child
    DefaultNumberOptionNode getMnsdDNO;
    @Node.Child
    DefaultNumberOptionNode getMxsdDNO;
    @Node.Child
    DefaultNumberOptionNode getMnfdDNO;
    @Node.Child
    DefaultNumberOptionNode getMxfdDNO;

    protected SetNumberFormatDigitOptionsNode(JSContext context) {
        this.getMinIntDigitsOption = GetNumberOptionNode.create(context, "minimumIntegerDigits");
        this.getMinFracDigitsOption = PropertyGetNode.create("minimumFractionDigits", context);
        this.getMaxFracDigitsOption = PropertyGetNode.create("maximumFractionDigits", context);
        this.getMinSignificantDigitsOption = PropertyGetNode.create("minimumSignificantDigits", context);
        this.getMaxSignificantDigitsOption = PropertyGetNode.create("maximumSignificantDigits", context);
        this.getMnsdDNO = DefaultNumberOptionNode.create();
        this.getMxsdDNO = DefaultNumberOptionNode.create();
        this.getMnfdDNO = DefaultNumberOptionNode.create();
        this.getMxfdDNO = DefaultNumberOptionNode.create();
    }

    public static SetNumberFormatDigitOptionsNode create(JSContext context) {
        return SetNumberFormatDigitOptionsNodeGen.create(context);
    }

    public abstract Object execute(JSNumberFormat.BasicInternalState var1, Object var2, int var3, int var4, boolean var5);

    @Specialization
    public Object setNumberFormatDigitOptions(JSNumberFormat.BasicInternalState intlObj, Object options, int mnfdDefault, int mxfdDefault, boolean compactNotation) {
        int mnid = this.getMinIntDigitsOption.executeInt(options, 1, 21, 1);
        Object mnfdValue = this.getMinFracDigitsOption.getValue(options);
        Object mxfdValue = this.getMaxFracDigitsOption.getValue(options);
        Object mnsdValue = this.getMinSignificantDigitsOption.getValue(options);
        Object mxsdValue = this.getMaxSignificantDigitsOption.getValue(options);
        intlObj.setMinimumIntegerDigits(mnid);
        if (mnsdValue != Undefined.instance || mxsdValue != Undefined.instance) {
            int mnsd = this.getMnsdDNO.executeInt(mnsdValue, 1, 21, 1);
            int mxsd = this.getMxsdDNO.executeInt(mxsdValue, mnsd, 21, 21);
            intlObj.setMinimumSignificantDigits(mnsd);
            intlObj.setMaximumSignificantDigits(mxsd);
        } else if (mnfdValue != Undefined.instance || mxfdValue != Undefined.instance) {
            int mnfd = this.getMnfdDNO.executeInt(mnfdValue, 0, 20, mnfdDefault);
            int mxfdActualDefualt = Math.max(mnfd, mxfdDefault);
            int mxfd = this.getMxfdDNO.executeInt(mxfdValue, mnfd, 20, mxfdActualDefualt);
            intlObj.setMinimumFractionDigits(mnfd);
            intlObj.setMaximumFractionDigits(mxfd);
        } else if (!compactNotation) {
            intlObj.setMinimumFractionDigits(mnfdDefault);
            intlObj.setMaximumFractionDigits(mxfdDefault);
        }
        return Undefined.instance;
    }
}

