/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNodeGen;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=KeyInfoNode.class)
public final class KeyInfoNodeGen
extends KeyInfoNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<DynamicObjectLibrary> DYNAMIC_OBJECT_LIBRARY_ = LibraryFactory.resolve(DynamicObjectLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private CachedOwnPropertyData cachedOwnProperty_cache;
    @Node.Child
    private MemberData member_cache;

    private KeyInfoNodeGen() {
    }

    @Override
    @ExplodeLoop
    public boolean execute(DynamicObject arg0Value, String arg1Value, int arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 3) != 0) {
            MemberData s2_;
            if ((state_0 & 1) != 0) {
                CachedOwnPropertyData s1_ = this.cachedOwnProperty_cache;
                while (s1_ != null) {
                    Property property__;
                    if (s1_.objectLibrary_.accepts((Object)arg0Value) && !JSGuards.isJSProxy(arg0Value) && (property__ = s1_.objectLibrary_.getProperty(arg0Value, (Object)arg1Value)) != null) {
                        return KeyInfoNode.cachedOwnProperty(arg0Value, arg1Value, arg2Value, s1_.objectLibrary_, property__, s1_.isCallable_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0 && (s2_ = this.member_cache) != null) {
                return KeyInfoNode.member(arg0Value, arg1Value, arg2Value, s2_.getPrototype_, s2_.isCallable_, s2_.isExtensible_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(DynamicObject arg0Value, String arg1Value, int arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            Property property__ = null;
            if (exclude == 0) {
                DynamicObjectLibrary objectLibrary__;
                int count1_ = 0;
                CachedOwnPropertyData s1_ = this.cachedOwnProperty_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null && (!s1_.objectLibrary_.accepts((Object)arg0Value) || JSGuards.isJSProxy(arg0Value) || (property__ = s1_.objectLibrary_.getProperty(arg0Value, (Object)arg1Value)) == null)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && !JSGuards.isJSProxy(arg0Value) && (property__ = (objectLibrary__ = (DynamicObjectLibrary)super.insert((Node)((DynamicObjectLibrary)DYNAMIC_OBJECT_LIBRARY_.create((Object)arg0Value)))).getProperty(arg0Value, (Object)arg1Value)) != null && count1_ < 2) {
                    s1_ = (CachedOwnPropertyData)super.insert((Node)new CachedOwnPropertyData(this.cachedOwnProperty_cache));
                    s1_.objectLibrary_ = s1_.insertAccessor(objectLibrary__);
                    s1_.isCallable_ = s1_.insertAccessor(IsCallableNode.create());
                    this.cachedOwnProperty_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = KeyInfoNode.cachedOwnProperty(arg0Value, arg1Value, arg2Value, s1_.objectLibrary_, property__, s1_.isCallable_);
                    return bl;
                }
            }
            MemberData s2_ = (MemberData)super.insert((Node)new MemberData());
            s2_.getPrototype_ = s2_.insertAccessor(GetPrototypeNode.create());
            s2_.isCallable_ = s2_.insertAccessor(IsCallableNode.create());
            s2_.isExtensible_ = s2_.insertAccessor(IsExtensibleNode.create());
            this.member_cache = s2_;
            this.exclude_ = exclude |= 1;
            this.cachedOwnProperty_cache = null;
            state_0 &= 0xFFFFFFFE;
            this.state_0_ = state_0 |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = KeyInfoNode.member(arg0Value, arg1Value, arg2Value, s2_.getPrototype_, s2_.isCallable_, s2_.isExtensible_);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedOwnPropertyData s1_;
        int state_0 = this.state_0_;
        if ((state_0 & 3) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s1_ = this.cachedOwnProperty_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "cachedOwnProperty";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            CachedOwnPropertyData s1_ = this.cachedOwnProperty_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(new Node[]{s1_.objectLibrary_, s1_.isCallable_}));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "member";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            MemberData s2_ = this.member_cache;
            if (s2_ != null) {
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{s2_.getPrototype_, s2_.isCallable_, s2_.isExtensible_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static KeyInfoNode create() {
        return new KeyInfoNodeGen();
    }

    public static KeyInfoNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=KeyInfoNode.class)
    private static final class Uncached
    extends KeyInfoNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean execute(DynamicObject arg0Value, String arg1Value, int arg2Value) {
            return KeyInfoNode.member(arg0Value, arg1Value, arg2Value, GetPrototypeNodeGen.getUncached(), IsCallableNodeGen.getUncached(), IsExtensibleNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=KeyInfoNode.class)
    private static final class MemberData
    extends Node {
        @Node.Child
        GetPrototypeNode getPrototype_;
        @Node.Child
        IsCallableNode isCallable_;
        @Node.Child
        IsExtensibleNode isExtensible_;

        MemberData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=KeyInfoNode.class)
    private static final class CachedOwnPropertyData
    extends Node {
        @Node.Child
        CachedOwnPropertyData next_;
        @Node.Child
        DynamicObjectLibrary objectLibrary_;
        @Node.Child
        IsCallableNode isCallable_;

        CachedOwnPropertyData(CachedOwnPropertyData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

