/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.array.JSArrayDeleteIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DeletePropertyNode.class)
public final class DeletePropertyNodeGen
extends DeletePropertyNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private JSToPropertyKeyNode toPropertyKey;
    @Node.Child
    private ToArrayIndexNode toArrayIndex;
    @Node.Child
    private InteropLibrary interop;
    @Node.Child
    private IsArrayNode jSObject_isArrayNode_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile jSObject_arrayProfile_;
    @Node.Child
    private ToArrayIndexNode jSObject_toArrayIndexNode_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile jSObject_arrayIndexProfile_;
    @Node.Child
    private JSArrayDeleteIndexNode jSObject_deleteArrayIndexNode_;
    @CompilerDirectives.CompilationFinal
    private JSClassProfile jSObject_jsclassProfile_;

    private DeletePropertyNodeGen(boolean strict, JSContext context, JavaScriptNode targetNode, JavaScriptNode propertyNode) {
        super(strict, context, targetNode, propertyNode);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3BF) == 0 && (state_0 & 0x3FF) != 0) {
            return this.executeWithTarget_int0(state_0, frameValue, targetNodeValue);
        }
        return this.executeWithTarget_generic1(state_0, frameValue, targetNodeValue);
    }

    private Object executeWithTarget_int0(int state_0, VirtualFrame frameValue, Object targetNodeValue) {
        int propertyNodeValue_;
        try {
            propertyNodeValue_ = this.propertyNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(targetNodeValue, ex.getResult());
        }
        assert ((state_0 & 0x40) != 0);
        if (JSGuards.isForeignObject(targetNodeValue)) {
            return this.arrayElementInt(targetNodeValue, propertyNodeValue_, this.interop);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, propertyNodeValue_);
    }

    private Object executeWithTarget_generic1(int state_0, VirtualFrame frameValue, Object targetNodeValue) {
        Object propertyNodeValue_ = this.propertyNode.execute(frameValue);
        if ((state_0 & 0x1F) != 0) {
            Object targetNodeValue_;
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(targetNodeValue) && JSGuards.isJSDynamicObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return this.doJSObject((DynamicObject)targetNodeValue_, propertyNodeValue_, this.jSObject_isArrayNode_, this.jSObject_arrayProfile_, this.jSObject_toArrayIndexNode_, this.jSObject_arrayIndexProfile_, this.jSObject_deleteArrayIndexNode_, this.jSObject_jsclassProfile_, this.toPropertyKey);
            }
            if ((state_0 & 2) != 0 && targetNodeValue instanceof Symbol) {
                targetNodeValue_ = (Symbol)targetNodeValue;
                return DeletePropertyNode.doSymbol((Symbol)targetNodeValue_, propertyNodeValue_, this.toPropertyKey);
            }
            if ((state_0 & 4) != 0 && targetNodeValue instanceof SafeInteger) {
                targetNodeValue_ = (SafeInteger)targetNodeValue;
                return DeletePropertyNode.doSafeInteger((SafeInteger)targetNodeValue_, propertyNodeValue_, this.toPropertyKey);
            }
            if ((state_0 & 8) != 0 && targetNodeValue instanceof BigInt) {
                targetNodeValue_ = (BigInt)targetNodeValue;
                return DeletePropertyNode.doBigInt((BigInt)targetNodeValue_, propertyNodeValue_, this.toPropertyKey);
            }
            if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, targetNodeValue)) {
                targetNodeValue_ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, targetNodeValue);
                return this.doString((String)targetNodeValue_, propertyNodeValue_, this.toArrayIndex);
            }
        }
        if ((state_0 & 0x3E0) != 0) {
            if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitString((state_0 & 0xE000) >>> 13, propertyNodeValue_)) {
                String propertyNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0xE000) >>> 13, propertyNodeValue_);
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    return this.member(targetNodeValue, propertyNodeValue__, this.interop);
                }
            }
            if ((state_0 & 0x40) != 0 && propertyNodeValue_ instanceof Integer) {
                int propertyNodeValue__ = (Integer)propertyNodeValue_;
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    return this.arrayElementInt(targetNodeValue, propertyNodeValue__, this.interop);
                }
            }
            if ((state_0 & 0x80) != 0 && propertyNodeValue_ instanceof Number) {
                Number propertyNodeValue__ = (Number)propertyNodeValue_;
                if (JSGuards.isForeignObject(targetNodeValue) && JSGuards.isNumber(propertyNodeValue__)) {
                    return this.arrayElement(targetNodeValue, propertyNodeValue__, this.interop);
                }
            }
            if ((state_0 & 0x300) != 0) {
                if ((state_0 & 0x100) != 0 && JSGuards.isForeignObject(targetNodeValue) && !JSGuards.isString(propertyNodeValue_) && !JSGuards.isNumber(propertyNodeValue_)) {
                    return this.foreignObject(targetNodeValue, propertyNodeValue_, this.interop, this.toArrayIndex);
                }
                if ((state_0 & 0x200) != 0 && !JSGuards.isTruffleObject(targetNodeValue) && !JSGuards.isString(targetNodeValue)) {
                    return this.doOther(targetNodeValue, propertyNodeValue_, this.toPropertyKey);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, propertyNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0x2BF) == 0 && (state_0 & 0x2FF) != 0) {
            return this.executeBoolean_int2(state_0, frameValue);
        }
        return this.executeBoolean_generic3(state_0, frameValue);
    }

    private boolean executeBoolean_int2(int state_0, VirtualFrame frameValue) throws UnexpectedResultException {
        int propertyNodeValue_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        try {
            propertyNodeValue_ = this.propertyNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(targetNodeValue_, ex.getResult()));
        }
        assert ((state_0 & 0x40) != 0);
        if (JSGuards.isForeignObject(targetNodeValue_)) {
            return this.arrayElementInt(targetNodeValue_, propertyNodeValue_, this.interop);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(targetNodeValue_, propertyNodeValue_));
    }

    private boolean executeBoolean_generic3(int state_0, VirtualFrame frameValue) throws UnexpectedResultException {
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object propertyNodeValue_ = this.propertyNode.execute(frameValue);
        if ((state_0 & 0x1F) != 0) {
            Object targetNodeValue__;
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(targetNodeValue_) && JSGuards.isJSDynamicObject(targetNodeValue__ = (DynamicObject)targetNodeValue_)) {
                return this.doJSObject((DynamicObject)targetNodeValue__, propertyNodeValue_, this.jSObject_isArrayNode_, this.jSObject_arrayProfile_, this.jSObject_toArrayIndexNode_, this.jSObject_arrayIndexProfile_, this.jSObject_deleteArrayIndexNode_, this.jSObject_jsclassProfile_, this.toPropertyKey);
            }
            if ((state_0 & 2) != 0 && targetNodeValue_ instanceof Symbol) {
                targetNodeValue__ = (Symbol)targetNodeValue_;
                return DeletePropertyNode.doSymbol((Symbol)targetNodeValue__, propertyNodeValue_, this.toPropertyKey);
            }
            if ((state_0 & 4) != 0 && targetNodeValue_ instanceof SafeInteger) {
                targetNodeValue__ = (SafeInteger)targetNodeValue_;
                return DeletePropertyNode.doSafeInteger((SafeInteger)targetNodeValue__, propertyNodeValue_, this.toPropertyKey);
            }
            if ((state_0 & 8) != 0 && targetNodeValue_ instanceof BigInt) {
                targetNodeValue__ = (BigInt)targetNodeValue_;
                return DeletePropertyNode.doBigInt((BigInt)targetNodeValue__, propertyNodeValue_, this.toPropertyKey);
            }
            if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, targetNodeValue_)) {
                targetNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, targetNodeValue_);
                return this.doString((String)targetNodeValue__, propertyNodeValue_, this.toArrayIndex);
            }
        }
        if ((state_0 & 0x2E0) != 0) {
            if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitString((state_0 & 0xE000) >>> 13, propertyNodeValue_)) {
                String propertyNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0xE000) >>> 13, propertyNodeValue_);
                if (JSGuards.isForeignObject(targetNodeValue_)) {
                    return this.member(targetNodeValue_, propertyNodeValue__, this.interop);
                }
            }
            if ((state_0 & 0x40) != 0 && propertyNodeValue_ instanceof Integer) {
                int propertyNodeValue__ = (Integer)propertyNodeValue_;
                if (JSGuards.isForeignObject(targetNodeValue_)) {
                    return this.arrayElementInt(targetNodeValue_, propertyNodeValue__, this.interop);
                }
            }
            if ((state_0 & 0x80) != 0 && propertyNodeValue_ instanceof Number) {
                Number propertyNodeValue__ = (Number)propertyNodeValue_;
                if (JSGuards.isForeignObject(targetNodeValue_) && JSGuards.isNumber(propertyNodeValue__)) {
                    return this.arrayElement(targetNodeValue_, propertyNodeValue__, this.interop);
                }
            }
            if ((state_0 & 0x200) != 0 && !JSGuards.isTruffleObject(targetNodeValue_) && !JSGuards.isString(targetNodeValue_)) {
                return this.doOther(targetNodeValue_, propertyNodeValue_, this.toPropertyKey);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(targetNodeValue_, propertyNodeValue_));
    }

    @Override
    public boolean executeEvaluated(Object targetNodeValue, Object propertyNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1F) != 0) {
            Object targetNodeValue_;
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(targetNodeValue) && JSGuards.isJSDynamicObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                return this.doJSObject((DynamicObject)targetNodeValue_, propertyNodeValue, this.jSObject_isArrayNode_, this.jSObject_arrayProfile_, this.jSObject_toArrayIndexNode_, this.jSObject_arrayIndexProfile_, this.jSObject_deleteArrayIndexNode_, this.jSObject_jsclassProfile_, this.toPropertyKey);
            }
            if ((state_0 & 2) != 0 && targetNodeValue instanceof Symbol) {
                targetNodeValue_ = (Symbol)targetNodeValue;
                return DeletePropertyNode.doSymbol((Symbol)targetNodeValue_, propertyNodeValue, this.toPropertyKey);
            }
            if ((state_0 & 4) != 0 && targetNodeValue instanceof SafeInteger) {
                targetNodeValue_ = (SafeInteger)targetNodeValue;
                return DeletePropertyNode.doSafeInteger((SafeInteger)targetNodeValue_, propertyNodeValue, this.toPropertyKey);
            }
            if ((state_0 & 8) != 0 && targetNodeValue instanceof BigInt) {
                targetNodeValue_ = (BigInt)targetNodeValue;
                return DeletePropertyNode.doBigInt((BigInt)targetNodeValue_, propertyNodeValue, this.toPropertyKey);
            }
            if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, targetNodeValue)) {
                targetNodeValue_ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, targetNodeValue);
                return this.doString((String)targetNodeValue_, propertyNodeValue, this.toArrayIndex);
            }
        }
        if ((state_0 & 0x2E0) != 0) {
            if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitString((state_0 & 0xE000) >>> 13, propertyNodeValue)) {
                String propertyNodeValue_ = JSTypesGen.asImplicitString((state_0 & 0xE000) >>> 13, propertyNodeValue);
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    return this.member(targetNodeValue, propertyNodeValue_, this.interop);
                }
            }
            if ((state_0 & 0x40) != 0 && propertyNodeValue instanceof Integer) {
                int propertyNodeValue_ = (Integer)propertyNodeValue;
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    return this.arrayElementInt(targetNodeValue, propertyNodeValue_, this.interop);
                }
            }
            if ((state_0 & 0x80) != 0 && propertyNodeValue instanceof Number) {
                Number propertyNodeValue_ = (Number)propertyNodeValue;
                if (JSGuards.isForeignObject(targetNodeValue) && JSGuards.isNumber(propertyNodeValue_)) {
                    return this.arrayElement(targetNodeValue, propertyNodeValue_, this.interop);
                }
            }
            if ((state_0 & 0x200) != 0 && !JSGuards.isTruffleObject(targetNodeValue) && !JSGuards.isString(targetNodeValue)) {
                return this.doOther(targetNodeValue, propertyNodeValue, this.toPropertyKey);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return (Boolean)this.executeAndSpecialize(targetNodeValue, propertyNodeValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0x100) == 0 && (state_0 & 0x3FF) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.executeBoolean(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object targetNodeValue, Object propertyNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            Boolean bl;
            Object targetNodeValue_;
            if (JSTypes.isDynamicObject(targetNodeValue) && JSGuards.isJSDynamicObject(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                this.jSObject_isArrayNode_ = (IsArrayNode)super.insert((Node)IsArrayNode.createIsFastArray());
                this.jSObject_arrayProfile_ = ConditionProfile.createBinaryProfile();
                this.jSObject_toArrayIndexNode_ = (ToArrayIndexNode)super.insert((Node)ToArrayIndexNode.create());
                this.jSObject_arrayIndexProfile_ = ConditionProfile.createBinaryProfile();
                this.jSObject_deleteArrayIndexNode_ = (JSArrayDeleteIndexNode)super.insert((Node)JSArrayDeleteIndexNode.create(this.context, this.strict));
                this.jSObject_jsclassProfile_ = JSClassProfile.create();
                if (this.toPropertyKey == null) {
                    this.toPropertyKey = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                }
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Boolean bl2 = this.doJSObject((DynamicObject)targetNodeValue_, propertyNodeValue, this.jSObject_isArrayNode_, this.jSObject_arrayProfile_, this.jSObject_toArrayIndexNode_, this.jSObject_arrayIndexProfile_, this.jSObject_deleteArrayIndexNode_, this.jSObject_jsclassProfile_, this.toPropertyKey);
                return bl2;
            }
            if (targetNodeValue instanceof Symbol) {
                targetNodeValue_ = (Symbol)targetNodeValue;
                if (this.toPropertyKey == null) {
                    this.toPropertyKey = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                }
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Boolean bl3 = DeletePropertyNode.doSymbol((Symbol)targetNodeValue_, propertyNodeValue, this.toPropertyKey);
                return bl3;
            }
            if (targetNodeValue instanceof SafeInteger) {
                targetNodeValue_ = (SafeInteger)targetNodeValue;
                if (this.toPropertyKey == null) {
                    this.toPropertyKey = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                }
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                Boolean bl4 = DeletePropertyNode.doSafeInteger((SafeInteger)targetNodeValue_, propertyNodeValue, this.toPropertyKey);
                return bl4;
            }
            if (targetNodeValue instanceof BigInt) {
                targetNodeValue_ = (BigInt)targetNodeValue;
                if (this.toPropertyKey == null) {
                    this.toPropertyKey = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                }
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                Boolean bl5 = DeletePropertyNode.doBigInt((BigInt)targetNodeValue_, propertyNodeValue, this.toPropertyKey);
                return bl5;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(targetNodeValue);
            if (stringCast0 != 0) {
                String targetNodeValue_2 = JSTypesGen.asImplicitString(stringCast0, targetNodeValue);
                if (this.toArrayIndex == null) {
                    this.toArrayIndex = (ToArrayIndexNode)super.insert((Node)ToArrayIndexNode.create());
                }
                state_0 |= stringCast0 << 10;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                Boolean bl6 = this.doString(targetNodeValue_2, propertyNodeValue, this.toArrayIndex);
                return bl6;
            }
            int stringCast1 = JSTypesGen.specializeImplicitString(propertyNodeValue);
            if (stringCast1 != 0) {
                String propertyNodeValue_ = JSTypesGen.asImplicitString(stringCast1, propertyNodeValue);
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    if (this.interop == null) {
                        this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    state_0 |= stringCast1 << 13;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl7 = this.member(targetNodeValue, propertyNodeValue_, this.interop);
                    return bl7;
                }
            }
            if (exclude == 0 && propertyNodeValue instanceof Integer) {
                int propertyNodeValue_ = (Integer)propertyNodeValue;
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    if (this.interop == null) {
                        this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    bl = this.arrayElementInt(targetNodeValue, propertyNodeValue_, this.interop);
                    return bl;
                }
            }
            if (propertyNodeValue instanceof Number) {
                Number propertyNodeValue_ = (Number)propertyNodeValue;
                if (JSGuards.isForeignObject(targetNodeValue) && JSGuards.isNumber(propertyNodeValue_)) {
                    if (this.interop == null) {
                        this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.exclude_ = exclude |= 1;
                    state_0 &= 0xFFFFFFBF;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    bl = this.arrayElement(targetNodeValue, propertyNodeValue_, this.interop);
                    return bl;
                }
            }
            if (JSGuards.isForeignObject(targetNodeValue) && !JSGuards.isString(propertyNodeValue) && !JSGuards.isNumber(propertyNodeValue)) {
                if (this.interop == null) {
                    this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                }
                if (this.toArrayIndex == null) {
                    this.toArrayIndex = (ToArrayIndexNode)super.insert((Node)ToArrayIndexNode.create());
                }
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                Object object = this.foreignObject(targetNodeValue, propertyNodeValue, this.interop, this.toArrayIndex);
                return object;
            }
            if (!JSGuards.isTruffleObject(targetNodeValue) && !JSGuards.isString(targetNodeValue)) {
                if (this.toPropertyKey == null) {
                    this.toPropertyKey = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                }
                this.state_0_ = state_0 |= 0x200;
                lock.unlock();
                hasLock = false;
                Boolean bl8 = this.doOther(targetNodeValue, propertyNodeValue, this.toPropertyKey);
                return bl8;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.targetNode, this.propertyNode}, new Object[]{targetNodeValue, propertyNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x3FF & (state_0 & 0x3FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[11];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doJSObject";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(new Cloneable[]{this.jSObject_isArrayNode_, this.jSObject_arrayProfile_, this.jSObject_toArrayIndexNode_, this.jSObject_arrayIndexProfile_, this.jSObject_deleteArrayIndexNode_, this.jSObject_jsclassProfile_, this.toPropertyKey}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.toPropertyKey));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.toPropertyKey));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state_0 & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.toPropertyKey));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state_0 & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.toArrayIndex));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "member";
        if ((state_0 & 0x20) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.interop));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "arrayElementInt";
        if ((state_0 & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.interop));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "arrayElement";
        if ((state_0 & 0x80) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.interop));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "foreignObject";
        if ((state_0 & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Node[]{this.interop, this.toArrayIndex}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doOther";
        if ((state_0 & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.toPropertyKey));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static DeletePropertyNode create(boolean strict, JSContext context, JavaScriptNode targetNode, JavaScriptNode propertyNode) {
        return new DeletePropertyNodeGen(strict, context, targetNode, propertyNode);
    }
}

