/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayToDenseObjectArrayNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSArrayToDenseObjectArrayNode.class)
public final class JSArrayToDenseObjectArrayNodeGen
extends JSArrayToDenseObjectArrayNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private FromDenseArrayData fromDenseArray_cache;
    @Node.Child
    private FromSparseArrayData fromSparseArray_cache;
    @Node.Child
    private UncachedData uncached_cache;

    private JSArrayToDenseObjectArrayNodeGen(JSContext context) {
        super(context);
    }

    @Override
    @ExplodeLoop
    public Object[] executeObjectArray(DynamicObject arg0Value, ScriptArray arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            UncachedData s3_;
            if ((state_0 & 1) != 0) {
                FromDenseArrayData s1_ = this.fromDenseArray_cache;
                while (s1_ != null) {
                    if (s1_.cachedArrayType_.isInstance(arg1Value)) {
                        assert (!s1_.cachedArrayType_.isHolesType());
                        if (!s1_.cachedArrayType_.hasHoles(arg0Value)) {
                            return this.fromDenseArray(arg0Value, arg1Value, arg2Value, s1_.cachedArrayType_, s1_.readNode_);
                        }
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                FromSparseArrayData s2_ = this.fromSparseArray_cache;
                while (s2_ != null) {
                    if (s2_.cachedArrayType_.isInstance(arg1Value) && (s2_.cachedArrayType_.isHolesType() || s2_.cachedArrayType_.hasHoles(arg0Value))) {
                        return this.fromSparseArray(arg0Value, arg1Value, arg2Value, s2_.cachedArrayType_, s2_.nextElementIndexNode_, s2_.growProfile_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state_0 & 4) != 0 && (s3_ = this.uncached_cache) != null) {
                return this.doUncached(arg0Value, arg1Value, arg2Value, s3_.nextElementIndexNode_, s3_.readNode_, s3_.growProfile_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] executeAndSpecialize(DynamicObject arg0Value, ScriptArray arg1Value, long arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            if ((exclude & 1) == 0) {
                Object[] cachedArrayType__;
                int count1_ = 0;
                FromDenseArrayData s1_ = this.fromDenseArray_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null) {
                        if (s1_.cachedArrayType_.isInstance((ScriptArray)arg1Value)) {
                            assert (!s1_.cachedArrayType_.isHolesType());
                            if (!s1_.cachedArrayType_.hasHoles(arg0Value)) break;
                        }
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedArrayType__ = arg1Value).isInstance((ScriptArray)arg1Value) && !cachedArrayType__.isHolesType() && !cachedArrayType__.hasHoles(arg0Value) && count1_ < 5) {
                    s1_ = (FromDenseArrayData)super.insert((Node)new FromDenseArrayData(this.fromDenseArray_cache));
                    s1_.cachedArrayType_ = cachedArrayType__;
                    s1_.readNode_ = s1_.insertAccessor(ReadElementNode.create(this.context));
                    this.fromDenseArray_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    cachedArrayType__ = this.fromDenseArray(arg0Value, (ScriptArray)arg1Value, arg2Value, s1_.cachedArrayType_, s1_.readNode_);
                    return cachedArrayType__;
                }
            }
            if ((exclude & 2) == 0) {
                Object[] cachedArrayType__1;
                int count2_ = 0;
                FromSparseArrayData s2_ = this.fromSparseArray_cache;
                if ((state_0 & 2) != 0) {
                    while (!(s2_ == null || s2_.cachedArrayType_.isInstance((ScriptArray)arg1Value) && (s2_.cachedArrayType_.isHolesType() || s2_.cachedArrayType_.hasHoles(arg0Value)))) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (cachedArrayType__1 = arg1Value).isInstance((ScriptArray)arg1Value) && (cachedArrayType__1.isHolesType() || cachedArrayType__1.hasHoles(arg0Value)) && count2_ < 5) {
                    s2_ = (FromSparseArrayData)super.insert((Node)new FromSparseArrayData(this.fromSparseArray_cache));
                    s2_.cachedArrayType_ = cachedArrayType__1;
                    s2_.nextElementIndexNode_ = s2_.insertAccessor(JSArrayNextElementIndexNode.create(this.context));
                    s2_.growProfile_ = BranchProfile.create();
                    this.fromSparseArray_cache = s2_;
                    this.state_0_ = state_0 |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object[] objectArray = this.fromSparseArray(arg0Value, (ScriptArray)arg1Value, arg2Value, s2_.cachedArrayType_, s2_.nextElementIndexNode_, s2_.growProfile_);
                    return objectArray;
                }
            }
            UncachedData s3_ = (UncachedData)super.insert((Node)new UncachedData());
            s3_.nextElementIndexNode_ = s3_.insertAccessor(JSArrayNextElementIndexNode.create(this.context));
            s3_.readNode_ = s3_.insertAccessor(ReadElementNode.create(this.context));
            s3_.growProfile_ = BranchProfile.create();
            this.uncached_cache = s3_;
            this.exclude_ = exclude |= 3;
            this.fromDenseArray_cache = null;
            this.fromSparseArray_cache = null;
            state_0 &= 0xFFFFFFFC;
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            Object[] objectArray = this.doUncached(arg0Value, (ScriptArray)arg1Value, arg2Value, s3_.nextElementIndexNode_, s3_.readNode_, s3_.growProfile_);
            return objectArray;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            FromDenseArrayData s1_ = this.fromDenseArray_cache;
            FromSparseArrayData s2_ = this.fromSparseArray_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "fromDenseArray";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            FromDenseArrayData s1_ = this.fromDenseArray_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedArrayType_, s1_.readNode_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "fromSparseArray";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            FromSparseArrayData s2_ = this.fromSparseArray_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(new Object[]{s2_.cachedArrayType_, s2_.nextElementIndexNode_, s2_.growProfile_}));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUncached";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            UncachedData s3_ = this.uncached_cache;
            if (s3_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s3_.nextElementIndexNode_, s3_.readNode_, s3_.growProfile_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSArrayToDenseObjectArrayNode create(JSContext context) {
        return new JSArrayToDenseObjectArrayNodeGen(context);
    }

    @GeneratedBy(value=JSArrayToDenseObjectArrayNode.class)
    private static final class UncachedData
    extends Node {
        @Node.Child
        JSArrayNextElementIndexNode nextElementIndexNode_;
        @Node.Child
        ReadElementNode readNode_;
        @CompilerDirectives.CompilationFinal
        BranchProfile growProfile_;

        UncachedData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSArrayToDenseObjectArrayNode.class)
    private static final class FromSparseArrayData
    extends Node {
        @Node.Child
        FromSparseArrayData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;
        @Node.Child
        JSArrayNextElementIndexNode nextElementIndexNode_;
        @CompilerDirectives.CompilationFinal
        BranchProfile growProfile_;

        FromSparseArrayData(FromSparseArrayData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSArrayToDenseObjectArrayNode.class)
    private static final class FromDenseArrayData
    extends Node {
        @Node.Child
        FromDenseArrayData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;
        @Node.Child
        ReadElementNode readNode_;

        FromDenseArrayData(FromDenseArrayData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

