/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.TypedArrayPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.ForEachIndexCallNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TypedArrayPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TypedArrayPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TypedArrayPrototypeBuiltins();

    protected TypedArrayPrototypeBuiltins() {
        super("TypedArray.prototype", TypedArrayPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TypedArrayPrototype builtinEnum) {
        switch (builtinEnum) {
            case subarray: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewSubarrayNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case set: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewSetNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case forEach: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewForEachNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case find: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case findIndex: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindIndexNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case fill: {
                return context.getEcmaScriptVersion() >= 9 ? TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewFillNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context)) : ArrayPrototypeBuiltinsFactory.JSArrayFillNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case reduce: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, true, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case reduceRight: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, true, false, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case sort: {
                return ArrayPrototypeBuiltinsFactory.JSArraySortNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case slice: {
                return ArrayPrototypeBuiltinsFactory.JSArraySliceNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case every: {
                return ArrayPrototypeBuiltinsFactory.JSArrayEveryNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case copyWithin: {
                return ArrayPrototypeBuiltinsFactory.JSArrayCopyWithinNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case indexOf: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, true, true, TypedArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case lastIndexOf: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, true, false, TypedArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case filter: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFilterNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case some: {
                return ArrayPrototypeBuiltinsFactory.JSArraySomeNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case map: {
                return ArrayPrototypeBuiltinsFactory.JSArrayMapNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case toLocaleString: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToLocaleStringNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case join: {
                return ArrayPrototypeBuiltinsFactory.JSArrayJoinNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case reverse: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewReverseNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case keys: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewIteratorNodeGen.create(context, builtin, 1, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case values: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewIteratorNodeGen.create(context, builtin, 2, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case entries: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewIteratorNodeGen.create(context, builtin, 3, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case includes: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIncludesNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case at: {
                return ArrayPrototypeBuiltinsFactory.JSArrayAtNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSArrayBufferViewIteratorNode
    extends JSBuiltinNode {
        @Node.Child
        private ArrayPrototypeBuiltins.CreateArrayIteratorNode createArrayIteratorNode;
        private final BranchProfile errorBranch = BranchProfile.create();

        public JSArrayBufferViewIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.createArrayIteratorNode = ArrayPrototypeBuiltins.CreateArrayIteratorNode.create(context, iterationKind);
        }

        @Specialization(guards={"isJSArrayBufferView(thisObj)"})
        protected DynamicObject doObject(VirtualFrame frame, DynamicObject thisObj) {
            this.checkHasDetachedBuffer(thisObj);
            return this.createArrayIteratorNode.execute(frame, thisObj);
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected DynamicObject doNotObject(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }

        protected final void checkHasDetachedBuffer(DynamicObject view) {
            if (JSArrayBufferView.hasDetachedBuffer(view, this.getContext())) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }
    }

    public static abstract class JSArrayBufferViewFillNode
    extends ArrayPrototypeBuiltins.JSArrayOperationWithToInt {
        private final ConditionProfile offsetProfile1 = ConditionProfile.createBinaryProfile();
        private final ConditionProfile offsetProfile2 = ConditionProfile.createBinaryProfile();
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSToBigIntNode toBigIntNode;

        public JSArrayBufferViewFillNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, true);
        }

        @Specialization
        protected DynamicObject fill(Object thisObj, Object value, Object start, Object end) {
            this.validateTypedArray(thisObj);
            DynamicObject thisJSObj = (DynamicObject)thisObj;
            long len = this.getLength(thisJSObj);
            Object convValue = JSArrayBufferView.isBigIntArrayBufferView(thisJSObj) ? this.toBigInt(value) : this.toNumber(value);
            long lStart = JSRuntime.getOffset(this.toIntegerAsLong(start), len, this.offsetProfile1);
            long lEnd = end == Undefined.instance ? len : JSRuntime.getOffset(this.toIntegerAsLong(end), len, this.offsetProfile2);
            this.checkHasDetachedBuffer(thisJSObj);
            for (long idx = lStart; idx < lEnd; ++idx) {
                this.write((Object)thisJSObj, idx, convValue);
            }
            return thisJSObj;
        }

        protected Object toNumber(Object value) {
            if (this.toNumberNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumberNode = (JSToNumberNode)this.insert(JSToNumberNode.create());
            }
            return this.toNumberNode.execute(value);
        }

        protected Object toBigInt(Object value) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = (JSToBigIntNode)this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.execute(value);
        }
    }

    public static abstract class JSArrayBufferViewReverseNode
    extends ArrayPrototypeBuiltins.JSArrayOperation {
        public JSArrayBufferViewReverseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, true);
        }

        @Specialization(guards={"isJSArrayBufferView(thisObj)"})
        protected DynamicObject reverse(DynamicObject thisObj, @Cached(value="create(THROW_ERROR, getContext())") DeletePropertyNode deletePropertyNode) {
            this.checkHasDetachedBuffer(thisObj);
            long len = this.getLength(thisObj);
            long middle = len / 2L;
            long lower = 0L;
            while (lower != middle) {
                boolean upperExists;
                long upper = len - lower - 1L;
                Object lowerValue = null;
                Object upperValue = null;
                boolean lowerExists = this.hasProperty((Object)thisObj, lower);
                if (lowerExists) {
                    lowerValue = this.read((Object)thisObj, lower);
                }
                if (upperExists = this.hasProperty((Object)thisObj, upper)) {
                    upperValue = this.read((Object)thisObj, upper);
                }
                if (lowerExists && upperExists) {
                    this.write((Object)thisObj, lower, upperValue);
                    this.write((Object)thisObj, upper, lowerValue);
                } else if (upperExists) {
                    this.write((Object)thisObj, lower, upperValue);
                    deletePropertyNode.executeEvaluated(thisObj, upper);
                } else if (lowerExists) {
                    deletePropertyNode.executeEvaluated(thisObj, lower);
                    this.write((Object)thisObj, upper, lowerValue);
                }
                long nextLower = this.nextElementIndex(thisObj, lower, len);
                long nextUpper = this.previousElementIndex(thisObj, upper);
                if (len - nextLower - 1L >= nextUpper) {
                    lower = nextLower;
                    continue;
                }
                lower = len - nextUpper - 1L;
            }
            return thisObj;
        }

        @Specialization(guards={"!isJSArrayBufferView(thisJSObj)"})
        protected Object reverse(Object thisJSObj) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }
    }

    public static abstract class JSArrayBufferViewForEachNode
    extends ArrayPrototypeBuiltins.ArrayForEachIndexCallOperation {
        public JSArrayBufferViewForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSArrayBufferView(thisJSObj)"})
        protected Object forEach(DynamicObject thisJSObj, Object callback, Object thisArg) {
            this.checkHasDetachedBuffer(thisJSObj);
            long length = JSArrayBufferView.typedArrayGetArrayType(thisJSObj).length(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length, (Object)Undefined.instance);
        }

        @Specialization(guards={"!isJSArrayBufferView(thisJSObj)"})
        protected Object forEachNonTypedArray(Object thisJSObj, Object callback, Object thisArg) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }
    }

    public static abstract class JSArrayBufferViewSetNode
    extends ArrayBufferPrototypeBuiltins.JSArrayBufferOperation {
        private final BranchProfile needErrorBranch = BranchProfile.create();
        private final ConditionProfile sameBufferProf = ConditionProfile.createBinaryProfile();
        private final ValueProfile sourceArrayProf = ValueProfile.createIdentityProfile();
        private final ValueProfile targetArrayProf = ValueProfile.createIdentityProfile();
        private final JSClassProfile sourceArrayClassProfile = JSClassProfile.create();
        private final ConditionProfile srcIsJSObject = ConditionProfile.createBinaryProfile();
        private final ConditionProfile arrayIsFastArray = ConditionProfile.createBinaryProfile();
        private final ConditionProfile arrayIsArrayBufferView = ConditionProfile.createBinaryProfile();
        private final ConditionProfile isDirectProf = ConditionProfile.createBinaryProfile();
        private final BranchProfile intToIntBranch = BranchProfile.create();
        private final BranchProfile floatToFloatBranch = BranchProfile.create();
        private final BranchProfile bigIntToBigIntBranch = BranchProfile.create();
        private final BranchProfile objectToObjectBranch = BranchProfile.create();
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private JSGetLengthNode getLengthNode;

        public JSArrayBufferViewSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSArrayBufferView(targetObj)"})
        protected Object set(DynamicObject targetObj, Object array, Object offset) {
            long targetOffsetLong = this.toInteger(offset);
            if (targetOffsetLong < 0L || targetOffsetLong > Integer.MAX_VALUE) {
                throw Errors.createRangeError("out of bounds");
            }
            this.checkHasDetachedBuffer(targetObj);
            int targetOffset = (int)targetOffsetLong;
            if (this.arrayIsArrayBufferView.profile(JSArrayBufferView.isJSArrayBufferView(array))) {
                this.setArrayBufferView(targetObj, (DynamicObject)array, targetOffset);
            } else if (this.arrayIsFastArray.profile(JSArray.isJSFastArray(array))) {
                this.setFastArray(targetObj, (DynamicObject)array, targetOffset);
            } else {
                this.setOther(targetObj, array, targetOffset);
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected Object set(Object thisObj, Object array, Object offset) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }

        private void setFastArray(DynamicObject thisObj, DynamicObject array, int offset) {
            assert (JSArrayBufferView.isJSArrayBufferView(thisObj));
            assert (JSArray.isJSFastArray(array));
            ScriptArray sourceArray = (ScriptArray)this.sourceArrayProf.profile((Object)JSAbstractArray.arrayGetArrayType(array));
            TypedArray targetArray = (TypedArray)this.targetArrayProf.profile((Object)JSArrayBufferView.typedArrayGetArrayType(thisObj));
            long sourceLen = sourceArray.length(array);
            this.rangeCheck(0L, sourceLen, offset, targetArray.length(thisObj));
            int i = 0;
            int j = offset;
            while ((long)i < sourceLen) {
                targetArray.setElement(thisObj, j, sourceArray.getElement(array, i), false);
                ++i;
                ++j;
            }
        }

        private void setOther(DynamicObject thisObj, Object array, int offset) {
            assert (JSArrayBufferView.isJSArrayBufferView(thisObj));
            assert (!JSArray.isJSFastArray(array));
            if (this.getContext().isOptionV8CompatibilityMode() && JSRuntime.isNumber(array)) {
                throw Errors.createTypeError("invalid_argument");
            }
            Object src = this.toObject(array);
            long srcLength = this.objectGetLength(src);
            TypedArray targetArray = (TypedArray)this.targetArrayProf.profile((Object)JSArrayBufferView.typedArrayGetArrayType(thisObj));
            this.rangeCheck(0L, srcLength, offset, targetArray.length(thisObj));
            boolean isJSObject = JSDynamicObject.isJSDynamicObject(src);
            int i = 0;
            int j = offset;
            while ((long)i < srcLength) {
                Object value = this.srcIsJSObject.profile(isJSObject) ? JSObject.get((DynamicObject)src, i, this.sourceArrayClassProfile) : JSInteropUtil.readArrayElementOrDefault(src, i, (Object)Undefined.instance);
                this.checkHasDetachedBuffer(thisObj);
                targetArray.setElement(thisObj, j, value, false);
                ++i;
                ++j;
            }
        }

        private void setArrayBufferView(DynamicObject targetView, DynamicObject sourceView, int offset) {
            int srcByteIndex;
            assert (JSArrayBufferView.isJSArrayBufferView(targetView));
            assert (JSArrayBufferView.isJSArrayBufferView(sourceView));
            this.checkHasDetachedBuffer(sourceView);
            TypedArray sourceArray = (TypedArray)this.sourceArrayProf.profile((Object)JSArrayBufferView.typedArrayGetArrayType(sourceView));
            TypedArray targetArray = (TypedArray)this.targetArrayProf.profile((Object)JSArrayBufferView.typedArrayGetArrayType(targetView));
            long sourceLength = sourceArray.length(sourceView);
            this.rangeCheck(0L, sourceLength, offset, targetArray.length(targetView));
            int sourceLen = (int)sourceLength;
            DynamicObject sourceBuffer = JSArrayBufferView.getArrayBuffer(sourceView);
            DynamicObject targetBuffer = JSArrayBufferView.getArrayBuffer(targetView);
            int srcByteOffset = JSArrayBufferView.typedArrayGetOffset(sourceView);
            int targetByteOffset = JSArrayBufferView.typedArrayGetOffset(targetView);
            if (this.sameBufferProf.profile(sourceBuffer == targetBuffer)) {
                int srcByteLength = sourceLen * sourceArray.bytesPerElement();
                sourceBuffer = this.cloneArrayBuffer(sourceBuffer, sourceArray, srcByteLength, srcByteOffset);
                srcByteIndex = 0;
            } else {
                srcByteIndex = srcByteOffset;
            }
            this.copyTypedArrayElementsDistinctBuffers(targetBuffer, sourceBuffer, targetArray, sourceArray, offset, targetByteOffset, sourceLen, srcByteIndex);
        }

        private void copyTypedArrayElementsDistinctBuffers(DynamicObject targetBuffer, DynamicObject sourceBuffer, TypedArray targetType, TypedArray sourceType, int targetOffset, int targetByteOffset, int sourceLength, int sourceByteIndex) {
            Object targetBackingBuffer = this.isDirectProf.profile(targetType.isDirect()) ? JSArrayBuffer.getDirectByteBuffer(targetBuffer) : (Object)JSArrayBuffer.getByteArray(targetBuffer);
            Object sourceBackingBuffer = this.isDirectProf.profile(sourceType.isDirect()) ? JSArrayBuffer.getDirectByteBuffer(sourceBuffer) : (Object)JSArrayBuffer.getByteArray(sourceBuffer);
            int targetElementSize = targetType.bytesPerElement();
            int sourceElementSize = sourceType.bytesPerElement();
            int targetByteIndex = targetByteOffset + targetOffset * targetElementSize;
            if (sourceType == targetType) {
                int sourceByteLength = sourceLength * sourceElementSize;
                if (this.isDirectProf.profile(targetType.isDirect())) {
                    Boundaries.byteBufferPutSlice((ByteBuffer)targetBackingBuffer, targetByteIndex, (ByteBuffer)sourceBackingBuffer, sourceByteIndex, sourceByteIndex + sourceByteLength);
                } else {
                    System.arraycopy(sourceBackingBuffer, sourceByteIndex, targetBackingBuffer, targetByteIndex, sourceByteLength);
                }
            } else if (sourceType instanceof TypedArray.TypedIntArray && targetType instanceof TypedArray.TypedIntArray) {
                this.intToIntBranch.enter();
                for (int i = 0; i < sourceLength; ++i) {
                    int value = ((TypedArray.TypedIntArray)sourceType).getIntImpl(sourceBackingBuffer, sourceByteIndex, i);
                    ((TypedArray.TypedIntArray)targetType).setIntImpl(targetBackingBuffer, targetByteOffset, i + targetOffset, value);
                }
            } else if (sourceType instanceof TypedArray.TypedFloatArray && targetType instanceof TypedArray.TypedFloatArray) {
                this.floatToFloatBranch.enter();
                for (int i = 0; i < sourceLength; ++i) {
                    double value = ((TypedArray.TypedFloatArray)sourceType).getDoubleImpl(sourceBackingBuffer, sourceByteIndex, i);
                    ((TypedArray.TypedFloatArray)targetType).setDoubleImpl(targetBackingBuffer, targetByteOffset, i + targetOffset, value);
                }
            } else if (sourceType instanceof TypedArray.TypedBigIntArray && targetType instanceof TypedArray.TypedBigIntArray) {
                this.bigIntToBigIntBranch.enter();
                for (int i = 0; i < sourceLength; ++i) {
                    BigInt value = ((TypedArray.TypedBigIntArray)sourceType).getBigIntImpl(sourceBackingBuffer, sourceByteIndex, i);
                    ((TypedArray.TypedBigIntArray)targetType).setBigIntImpl(targetBackingBuffer, targetByteOffset, i + targetOffset, value);
                }
            } else {
                if (sourceType instanceof TypedArray.TypedBigIntArray != targetType instanceof TypedArray.TypedBigIntArray) {
                    throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
                }
                this.objectToObjectBranch.enter();
                boolean littleEndian = ByteOrder.LITTLE_ENDIAN == ByteOrder.nativeOrder();
                for (int i = 0; i < sourceLength; ++i) {
                    Object value = sourceType.getBufferElement(sourceBuffer, sourceByteIndex + i * sourceElementSize, littleEndian);
                    targetType.setBufferElement(targetBuffer, targetByteIndex + i * targetElementSize, littleEndian, value);
                }
            }
        }

        private DynamicObject cloneArrayBuffer(DynamicObject sourceBuffer, TypedArray sourceArray, int srcByteLength, int srcByteOffset) {
            DynamicObject clonedArrayBuffer;
            if (this.isDirectProf.profile(sourceArray.isDirect())) {
                clonedArrayBuffer = JSArrayBuffer.createDirectArrayBuffer(this.getContext(), srcByteLength);
                ByteBuffer clonedBackingBuffer = JSArrayBuffer.getDirectByteBuffer(clonedArrayBuffer);
                ByteBuffer sourceBackingBuffer = JSArrayBuffer.getDirectByteBuffer(sourceBuffer);
                Boundaries.byteBufferPutSlice(clonedBackingBuffer, 0, sourceBackingBuffer, srcByteOffset, srcByteOffset + srcByteLength);
            } else {
                clonedArrayBuffer = JSArrayBuffer.createArrayBuffer(this.getContext(), srcByteLength);
                byte[] clonedBackingBuffer = JSArrayBuffer.getByteArray(clonedArrayBuffer);
                byte[] sourceBackingBuffer = JSArrayBuffer.getByteArray(sourceBuffer);
                System.arraycopy(sourceBackingBuffer, srcByteOffset, clonedBackingBuffer, 0, srcByteLength);
            }
            return clonedArrayBuffer;
        }

        private void rangeCheck(long sourceStart, long sourceLength, long targetStart, long targetLength) {
            if (sourceStart < 0L || targetStart < 0L || sourceStart > sourceLength || targetStart > targetLength || sourceLength - sourceStart > targetLength - targetStart) {
                this.needErrorBranch.enter();
                throw Errors.createRangeError("out of bounds");
            }
        }

        private Object toObject(Object array) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = (JSToObjectNode)this.insert(JSToObjectNode.createToObject(this.getContext()));
            }
            return this.toObjectNode.execute(array);
        }

        private long objectGetLength(Object thisObject) {
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = (JSGetLengthNode)this.insert(JSGetLengthNode.create(this.getContext()));
            }
            return this.getLengthNode.executeLong(thisObject);
        }

        private void checkHasDetachedBuffer(DynamicObject view) {
            if (JSArrayBufferView.hasDetachedBuffer(view, this.getContext())) {
                this.needErrorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }
    }

    public static abstract class JSArrayBufferViewSubarrayNode
    extends ArrayBufferPrototypeBuiltins.JSArrayBufferOperation {
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;

        public JSArrayBufferViewSubarrayNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSArrayBufferView(thisObj)"})
        protected DynamicObject subarray(DynamicObject thisObj, int begin, int end, @Cached(value="createIdentityProfile()") ValueProfile arrayTypeProfile) {
            TypedArray array = (TypedArray)arrayTypeProfile.profile((Object)JSArrayBufferView.typedArrayGetArrayType(thisObj));
            int length = (int)array.length(thisObj);
            int clampedBegin = ArrayBufferPrototypeBuiltins.JSArrayBufferSliceNode.clampIndex(begin, 0, length);
            int clampedEnd = ArrayBufferPrototypeBuiltins.JSArrayBufferSliceNode.clampIndex(end, clampedBegin, length);
            return this.subarrayImpl(thisObj, array, clampedBegin, clampedEnd);
        }

        @Specialization(guards={"isJSArrayBufferView(thisObj)"})
        protected DynamicObject subarray(DynamicObject thisObj, Object begin0, Object end0, @Cached(value="createIdentityProfile()") ValueProfile arrayTypeProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeBegin, @Cached(value="createBinaryProfile()") ConditionProfile negativeEnd, @Cached(value="createBinaryProfile()") ConditionProfile smallerEnd) {
            TypedArray array = (TypedArray)arrayTypeProfile.profile((Object)JSArrayBufferView.typedArrayGetArrayType(thisObj));
            long len = array.length(thisObj);
            long relativeBegin = this.toInteger(begin0);
            long beginIndex = negativeBegin.profile(relativeBegin < 0L) ? Math.max(len + relativeBegin, 0L) : Math.min(relativeBegin, len);
            long relativeEnd = end0 == Undefined.instance ? len : this.toInteger(end0);
            long endIndex = negativeEnd.profile(relativeEnd < 0L) ? Math.max(len + relativeEnd, 0L) : Math.min(relativeEnd, len);
            if (smallerEnd.profile(endIndex < beginIndex)) {
                endIndex = beginIndex;
            }
            return this.subarrayImpl(thisObj, array, (int)beginIndex, (int)endIndex);
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected DynamicObject subarrayGeneric(Object thisObj, Object begin0, Object end0) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }

        protected DynamicObject subarrayImpl(DynamicObject thisObj, TypedArray arrayType, int begin, int end) {
            assert (arrayType == JSArrayBufferView.typedArrayGetArrayType(thisObj));
            int offset = JSArrayBufferView.typedArrayGetOffset(thisObj);
            DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer(thisObj);
            return this.getArraySpeciesConstructorNode().typedArraySpeciesCreate(thisObj, arrayBuffer, offset + begin * arrayType.bytesPerElement(), end - begin);
        }

        protected ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = (ArrayPrototypeBuiltins.ArraySpeciesConstructorNode)this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), true));
            }
            return this.arraySpeciesCreateNode;
        }
    }

    public static enum TypedArrayPrototype implements BuiltinEnum<TypedArrayPrototype>
    {
        subarray(2),
        set(1),
        forEach(1),
        find(1),
        findIndex(1),
        fill(1),
        reduce(1),
        reduceRight(1),
        sort(1),
        slice(2),
        every(1),
        copyWithin(2),
        indexOf(1),
        lastIndexOf(1),
        filter(1),
        some(1),
        map(1),
        toLocaleString(0),
        join(1),
        reverse(0),
        keys(0),
        values(0),
        entries(0),
        includes(1),
        at(1);

        private final int length;

        private TypedArrayPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (this == includes) {
                return 7;
            }
            if (this == at) {
                return 13;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }
}

