/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.ObjectPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ObjectPrototypeBuiltins.class)
public final class ObjectPrototypeBuiltinsFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypeLookupGetterOrSetterNode.class)
    public static final class ObjectPrototypeLookupGetterOrSetterNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypeLookupGetterOrSetterNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private ObjectPrototypeLookupGetterOrSetterNodeGen(JSContext context, JSBuiltin builtin, boolean getter, JavaScriptNode[] arguments) {
            super(context, builtin, getter);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.lookup(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "lookup";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypeLookupGetterOrSetterNode create(JSContext context, JSBuiltin builtin, boolean getter, JavaScriptNode[] arguments) {
            return new ObjectPrototypeLookupGetterOrSetterNodeGen(context, builtin, getter, arguments);
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypeDefineGetterOrSetterNode.class)
    public static final class ObjectPrototypeDefineGetterOrSetterNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypeDefineGetterOrSetterNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;

        private ObjectPrototypeDefineGetterOrSetterNodeGen(JSContext context, JSBuiltin builtin, boolean getter, JavaScriptNode[] arguments) {
            super(context, builtin, getter);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            return this.define(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "define";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypeDefineGetterOrSetterNode create(JSContext context, JSBuiltin builtin, boolean getter, JavaScriptNode[] arguments) {
            return new ObjectPrototypeDefineGetterOrSetterNodeGen(context, builtin, getter, arguments);
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypeIsPrototypeOfNode.class)
    public static final class ObjectPrototypeIsPrototypeOfNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypeIsPrototypeOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private ObjectPrototypeIsPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0) {
                DynamicObject arguments1Value__;
                if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments1Value_) && JSGuards.isJSObject(arguments1Value__ = (DynamicObject)arguments1Value_)) {
                    return this.isPrototypeOf(arguments0Value_, arguments1Value__);
                }
                if ((state_0 & 2) != 0 && !JSGuards.isJSObject(arguments1Value_)) {
                    return this.isPrototypeOfNoObject(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0) {
                DynamicObject arguments1Value__;
                if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments1Value_) && JSGuards.isJSObject(arguments1Value__ = (DynamicObject)arguments1Value_)) {
                    return this.isPrototypeOf(arguments0Value_, arguments1Value__);
                }
                if ((state_0 & 2) != 0 && !JSGuards.isJSObject(arguments1Value_)) {
                    return this.isPrototypeOfNoObject(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            DynamicObject arguments1Value_;
            int state_0 = this.state_0_;
            if (JSTypes.isDynamicObject(arguments1Value) && JSGuards.isJSObject(arguments1Value_ = (DynamicObject)arguments1Value)) {
                this.state_0_ = state_0 |= 1;
                return this.isPrototypeOf(arguments0Value, arguments1Value_);
            }
            if (!JSGuards.isJSObject(arguments1Value)) {
                this.state_0_ = state_0 |= 2;
                return this.isPrototypeOfNoObject(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "isPrototypeOf";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "isPrototypeOfNoObject";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypeIsPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPrototypeIsPrototypeOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypeHasOwnPropertyNode.class)
    public static final class ObjectPrototypeHasOwnPropertyNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypeHasOwnPropertyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private ObjectPrototypeHasOwnPropertyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FD) == 0 && (state_0 & 0x3FF) != 0) {
                return this.execute_int0(state_0, frameValue);
            }
            return this.execute_generic1(state_0, frameValue);
        }

        private Object execute_int0(int state_0, VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doJSObjectIntKey(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic1(int state_0, VirtualFrame frameValue) {
            Object arguments0Value__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 0xF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, arguments1Value_);
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.doJSObjectStringKey((DynamicObject)arguments0Value__, arguments1Value__);
                    }
                }
                if ((state_0 & 2) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.doJSObjectIntKey((DynamicObject)arguments0Value__, arguments1Value__);
                    }
                }
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && JSGuards.isJSObject(arguments0Value__)) {
                        return this.doJSObjectAnyKey((DynamicObject)arguments0Value__, arguments1Value_);
                    }
                    if ((state_0 & 8) != 0 && JSGuards.isNullOrUndefined(arguments0Value__)) {
                        return this.hasOwnPropertyNullOrUndefined((DynamicObject)arguments0Value__, arguments1Value_);
                    }
                }
            }
            if ((state_0 & 0x3F0) != 0) {
                if ((state_0 & 0x10) != 0 && arguments0Value_ instanceof JSLazyString) {
                    arguments0Value__ = (JSLazyString)arguments0Value_;
                    return this.hasOwnPropertyLazyString((JSLazyString)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x20) != 0 && !JSGuards.isTruffleObject(arguments0Value_)) {
                    return this.hasOwnPropertyPrimitive(arguments0Value_, arguments1Value_);
                }
                if ((state_0 & 0x40) != 0 && arguments0Value_ instanceof Symbol) {
                    arguments0Value__ = (Symbol)arguments0Value_;
                    return this.hasOwnPropertySymbol((Symbol)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x80) != 0 && arguments0Value_ instanceof SafeInteger) {
                    arguments0Value__ = (SafeInteger)arguments0Value_;
                    return this.hasOwnPropertySafeInteger((SafeInteger)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x100) != 0 && arguments0Value_ instanceof BigInt) {
                    arguments0Value__ = (BigInt)arguments0Value_;
                    return this.hasOwnPropertyBigInt((BigInt)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x200) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.hasOwnPropertyForeign(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FD) == 0 && (state_0 & 0x3FF) != 0) {
                return this.executeBoolean_int2(state_0, frameValue);
            }
            return this.executeBoolean_generic3(state_0, frameValue);
        }

        private boolean executeBoolean_int2(int state_0, VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doJSObjectIntKey(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private boolean executeBoolean_generic3(int state_0, VirtualFrame frameValue) {
            Object arguments0Value__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 0xF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C00) >>> 10, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C00) >>> 10, arguments1Value_);
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.doJSObjectStringKey((DynamicObject)arguments0Value__, arguments1Value__);
                    }
                }
                if ((state_0 & 2) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.doJSObjectIntKey((DynamicObject)arguments0Value__, arguments1Value__);
                    }
                }
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && JSGuards.isJSObject(arguments0Value__)) {
                        return this.doJSObjectAnyKey((DynamicObject)arguments0Value__, arguments1Value_);
                    }
                    if ((state_0 & 8) != 0 && JSGuards.isNullOrUndefined(arguments0Value__)) {
                        return this.hasOwnPropertyNullOrUndefined((DynamicObject)arguments0Value__, arguments1Value_);
                    }
                }
            }
            if ((state_0 & 0x3F0) != 0) {
                if ((state_0 & 0x10) != 0 && arguments0Value_ instanceof JSLazyString) {
                    arguments0Value__ = (JSLazyString)arguments0Value_;
                    return this.hasOwnPropertyLazyString((JSLazyString)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x20) != 0 && !JSGuards.isTruffleObject(arguments0Value_)) {
                    return this.hasOwnPropertyPrimitive(arguments0Value_, arguments1Value_);
                }
                if ((state_0 & 0x40) != 0 && arguments0Value_ instanceof Symbol) {
                    arguments0Value__ = (Symbol)arguments0Value_;
                    return this.hasOwnPropertySymbol((Symbol)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x80) != 0 && arguments0Value_ instanceof SafeInteger) {
                    arguments0Value__ = (SafeInteger)arguments0Value_;
                    return this.hasOwnPropertySafeInteger((SafeInteger)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x100) != 0 && arguments0Value_ instanceof BigInt) {
                    arguments0Value__ = (BigInt)arguments0Value_;
                    return this.hasOwnPropertyBigInt((BigInt)arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0x200) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.hasOwnPropertyForeign(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                boolean bl;
                Object arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    int stringCast1;
                    arguments0Value_ = (DynamicObject)arguments0Value;
                    if ((exclude & 1) == 0 && (stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value)) != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSGuards.isJSObject(arguments0Value_)) {
                            state_0 |= stringCast1 << 10;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            boolean bl2 = this.doJSObjectStringKey((DynamicObject)arguments0Value_, arguments1Value_);
                            return bl2;
                        }
                    }
                    if ((exclude & 2) == 0 && arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_)) {
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            boolean bl3 = this.doJSObjectIntKey((DynamicObject)arguments0Value_, arguments1Value_);
                            return bl3;
                        }
                    }
                    if (JSGuards.isJSObject(arguments0Value_)) {
                        this.exclude_ = exclude |= 3;
                        state_0 &= 0xFFFFFFFC;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        bl = this.doJSObjectAnyKey((DynamicObject)arguments0Value_, arguments1Value);
                        return bl;
                    }
                    if (JSGuards.isNullOrUndefined(arguments0Value_)) {
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        bl = this.hasOwnPropertyNullOrUndefined((DynamicObject)arguments0Value_, arguments1Value);
                        return bl;
                    }
                }
                if (arguments0Value instanceof JSLazyString) {
                    arguments0Value_ = (JSLazyString)arguments0Value;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    bl = this.hasOwnPropertyLazyString((JSLazyString)arguments0Value_, arguments1Value);
                    return bl;
                }
                if (!JSGuards.isTruffleObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean arguments0Value_2 = this.hasOwnPropertyPrimitive(arguments0Value, arguments1Value);
                    return arguments0Value_2;
                }
                if (arguments0Value instanceof Symbol) {
                    arguments0Value_ = (Symbol)arguments0Value;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    bl = this.hasOwnPropertySymbol((Symbol)arguments0Value_, arguments1Value);
                    return bl;
                }
                if (arguments0Value instanceof SafeInteger) {
                    arguments0Value_ = (SafeInteger)arguments0Value;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    bl = this.hasOwnPropertySafeInteger((SafeInteger)arguments0Value_, arguments1Value);
                    return bl;
                }
                if (arguments0Value instanceof BigInt) {
                    arguments0Value_ = (BigInt)arguments0Value;
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    bl = this.hasOwnPropertyBigInt((BigInt)arguments0Value_, arguments1Value);
                    return bl;
                }
                if (JSGuards.isForeignObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    boolean bl4 = this.hasOwnPropertyForeign(arguments0Value, arguments1Value);
                    return bl4;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x3FF & (state_0 & 0x3FF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[11];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doJSObjectStringKey";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "doJSObjectIntKey";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "doJSObjectAnyKey";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "hasOwnPropertyNullOrUndefined";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "hasOwnPropertyLazyString";
            s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "hasOwnPropertyPrimitive";
            s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "hasOwnPropertySymbol";
            s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[7] = s;
            s = new Object[3];
            s[0] = "hasOwnPropertySafeInteger";
            s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[8] = s;
            s = new Object[3];
            s[0] = "hasOwnPropertyBigInt";
            s[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[9] = s;
            s = new Object[3];
            s[0] = "hasOwnPropertyForeign";
            s[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[10] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypeHasOwnPropertyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPrototypeHasOwnPropertyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypePropertyIsEnumerableNode.class)
    public static final class ObjectPrototypePropertyIsEnumerableNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypePropertyIsEnumerableNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private ObjectPrototypePropertyIsEnumerableNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.propertyIsEnumerable(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.propertyIsEnumerable(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "propertyIsEnumerable";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypePropertyIsEnumerableNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPrototypePropertyIsEnumerableNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypeToLocaleStringNode.class)
    public static final class ObjectPrototypeToLocaleStringNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypeToLocaleStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ObjectPrototypeToLocaleStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.toLocaleString(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "toLocaleString";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypeToLocaleStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPrototypeToLocaleStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.FormatCacheNode.class)
    public static final class FormatCacheNodeGen
    extends ObjectPrototypeBuiltins.FormatCacheNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private ExecuteCachedData executeCached_cache;

        private FormatCacheNodeGen() {
        }

        @Override
        @ExplodeLoop
        public String execute(String arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 3) != 0) {
                if ((state_0 & 1) != 0) {
                    ExecuteCachedData s1_ = this.executeCached_cache;
                    while (s1_ != null) {
                        if (s1_.cachedName_.equals(arg0Value)) {
                            return this.executeCached(arg0Value, s1_.cachedName_, s1_.cachedResult_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.executeUncached(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(String arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                int count1_ = 0;
                ExecuteCachedData s1_ = this.executeCached_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null && !s1_.cachedName_.equals(arg0Value)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 10) {
                    s1_ = new ExecuteCachedData(this.executeCached_cache);
                    s1_.cachedName_ = arg0Value;
                    s1_.cachedResult_ = this.executeUncached(arg0Value);
                    this.executeCached_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    String string = this.executeCached(arg0Value, s1_.cachedName_, s1_.cachedResult_);
                    return string;
                }
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.executeUncached(arg0Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ExecuteCachedData s1_;
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s1_ = this.executeCached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "executeCached";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<String>> cached = new ArrayList<List<String>>();
                ExecuteCachedData s1_ = this.executeCached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedName_, s1_.cachedResult_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "executeUncached";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.FormatCacheNode create() {
            return new FormatCacheNodeGen();
        }

        @GeneratedBy(value=ObjectPrototypeBuiltins.FormatCacheNode.class)
        private static final class ExecuteCachedData {
            @CompilerDirectives.CompilationFinal
            ExecuteCachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedName_;
            @CompilerDirectives.CompilationFinal
            String cachedResult_;

            ExecuteCachedData(ExecuteCachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.class)
    public static final class GetBuiltinToStringTagNodeGen
    extends ObjectPrototypeBuiltins.GetBuiltinToStringTagNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private GetBuiltinToStringTagNodeGen() {
        }

        @Override
        @ExplodeLoop
        public String execute(Object arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((state_0 & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        assert (s1_.cachedClass_ != null);
                        if (s1_.cachedClass_.isInstance(arg0Value_)) {
                            return ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.cached(arg0Value_, s1_.cachedClass_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0 && JSGuards.isJSDynamicObject(arg0Value_)) {
                    return ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.uncached(arg0Value_);
                }
                if ((state_0 & 4) != 0 && !JSGuards.isJSDynamicObject(arg0Value_)) {
                    return ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.foreign(arg0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (JSTypes.isDynamicObject(arg0Value)) {
                    DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                    if (exclude == 0) {
                        JSClass cachedClass__;
                        int count1_ = 0;
                        CachedData s1_ = this.cached_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null) {
                                assert (s1_.cachedClass_ != null);
                                if (s1_.cachedClass_.isInstance(arg0Value_)) break;
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (cachedClass__ = JSGuards.getJSClassChecked(arg0Value_)) != null && cachedClass__.isInstance(arg0Value_) && count1_ < 5) {
                            s1_ = new CachedData(this.cached_cache);
                            s1_.cachedClass_ = cachedClass__;
                            this.cached_cache = s1_;
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            String string = ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.cached(arg0Value_, s1_.cachedClass_);
                            return string;
                        }
                    }
                    if (JSGuards.isJSDynamicObject(arg0Value_)) {
                        this.exclude_ = exclude |= 1;
                        this.cached_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        String string = ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.uncached(arg0Value_);
                        return string;
                    }
                    if (!JSGuards.isJSDynamicObject(arg0Value_)) {
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        String string = ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.foreign(arg0Value_);
                        return string;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "cached";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSClass>> cached = new ArrayList<List<JSClass>>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedClass_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "uncached";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "foreign";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.GetBuiltinToStringTagNode create() {
            return new GetBuiltinToStringTagNodeGen();
        }

        @GeneratedBy(value=ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            JSClass cachedClass_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypeToStringNode.class)
    public static final class ObjectPrototypeToStringNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypeToStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private ObjectPrototypeBuiltins.GetBuiltinToStringTagNode builtinTag;
        @Node.Child
        private InteropLibrary foreignObject0_interop_;

        private ObjectPrototypeToStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state_0 & 1) != 0 && JSGuards.isJSObject(arguments0Value__) && !JSGuards.isJSProxy(arguments0Value__)) {
                    return this.doJSObject((DynamicObject)arguments0Value__, this.builtinTag);
                }
                if ((state_0 & 2) != 0 && JSGuards.isJSProxy(arguments0Value__)) {
                    return this.doJSProxy((DynamicObject)arguments0Value__, this.builtinTag);
                }
            }
            if ((state_0 & 0x3C) != 0) {
                if ((state_0 & 4) != 0 && JSGuards.isJSNull(arguments0Value_)) {
                    return this.doNull(arguments0Value_);
                }
                if ((state_0 & 8) != 0 && JSGuards.isUndefined(arguments0Value_)) {
                    return this.doUndefined(arguments0Value_);
                }
                if ((state_0 & 0x10) != 0 && this.foreignObject0_interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.doForeignObject(arguments0Value_, this.foreignObject0_interop_);
                }
                if ((state_0 & 0x20) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.foreignObject1Boundary(state_0, arguments0Value_);
                }
            }
            if ((state_0 & 0x40) != 0 && arguments0Value_ instanceof Symbol) {
                arguments0Value__ = (Symbol)arguments0Value_;
                return this.doSymbol((Symbol)arguments0Value__);
            }
            if ((state_0 & 0x80) != 0 && arguments0Value_ instanceof JSLazyString) {
                arguments0Value__ = (JSLazyString)arguments0Value_;
                return this.doLazyString((JSLazyString)arguments0Value__);
            }
            if ((state_0 & 0x100) != 0 && arguments0Value_ instanceof SafeInteger) {
                arguments0Value__ = (SafeInteger)arguments0Value_;
                return this.doSafeInteger((SafeInteger)arguments0Value__);
            }
            if ((state_0 & 0x200) != 0 && arguments0Value_ instanceof BigInt) {
                arguments0Value__ = (BigInt)arguments0Value_;
                return this.doBigInt((BigInt)arguments0Value__);
            }
            if ((state_0 & 0x400) != 0 && !JSGuards.isTruffleObject(arguments0Value_)) {
                return this.doObject(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreignObject1Boundary(int state_0, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                String string = this.doForeignObject(arguments0Value_, foreignObject1_interop__);
                return string;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                String string;
                Object arguments0Value_;
                Object arguments0Value_2;
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    arguments0Value_2 = (DynamicObject)arguments0Value;
                    if (JSGuards.isJSObject(arguments0Value_2) && !JSGuards.isJSProxy(arguments0Value_2)) {
                        if (this.builtinTag == null) {
                            this.builtinTag = (ObjectPrototypeBuiltins.GetBuiltinToStringTagNode)super.insert((Node)ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.create());
                        }
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        String string2 = this.doJSObject((DynamicObject)arguments0Value_2, this.builtinTag);
                        return string2;
                    }
                    if (JSGuards.isJSProxy(arguments0Value_2)) {
                        if (this.builtinTag == null) {
                            this.builtinTag = (ObjectPrototypeBuiltins.GetBuiltinToStringTagNode)super.insert((Node)ObjectPrototypeBuiltins.GetBuiltinToStringTagNode.create());
                        }
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        String string3 = this.doJSProxy((DynamicObject)arguments0Value_2, this.builtinTag);
                        return string3;
                    }
                }
                if (JSGuards.isJSNull(arguments0Value)) {
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_2 = this.doNull(arguments0Value);
                    return arguments0Value_2;
                }
                if (JSGuards.isUndefined(arguments0Value)) {
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_2 = this.doUndefined(arguments0Value);
                    return arguments0Value_2;
                }
                if (exclude == 0) {
                    boolean ForeignObject0_duplicateFound_ = false;
                    if ((state_0 & 0x10) != 0 && this.foreignObject0_interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value)) {
                        ForeignObject0_duplicateFound_ = true;
                    }
                    if (!ForeignObject0_duplicateFound_ && JSGuards.isForeignObject(arguments0Value) && (state_0 & 0x10) == 0) {
                        this.foreignObject0_interop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arguments0Value)));
                        this.state_0_ = state_0 |= 0x10;
                        ForeignObject0_duplicateFound_ = true;
                    }
                    if (ForeignObject0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        String string4 = this.doForeignObject(arguments0Value, this.foreignObject0_interop_);
                        return string4;
                    }
                }
                InteropLibrary foreignObject1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        this.exclude_ = exclude |= 1;
                        state_0 &= 0xFFFFFFEF;
                        this.state_0_ = state_0 |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        String string5 = this.doForeignObject(arguments0Value, foreignObject1_interop__);
                        return string5;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if (arguments0Value instanceof Symbol) {
                    arguments0Value_ = (Symbol)arguments0Value;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    string = this.doSymbol((Symbol)arguments0Value_);
                    return string;
                }
                if (arguments0Value instanceof JSLazyString) {
                    arguments0Value_ = (JSLazyString)arguments0Value;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    string = this.doLazyString((JSLazyString)arguments0Value_);
                    return string;
                }
                if (arguments0Value instanceof SafeInteger) {
                    arguments0Value_ = (SafeInteger)arguments0Value;
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    string = this.doSafeInteger((SafeInteger)arguments0Value_);
                    return string;
                }
                if (arguments0Value instanceof BigInt) {
                    arguments0Value_ = (BigInt)arguments0Value;
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    string = this.doBigInt((BigInt)arguments0Value_);
                    return string;
                }
                if (!JSGuards.isTruffleObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    String string6 = this.doObject(arguments0Value);
                    return string6;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[12];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doJSObject";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.builtinTag));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doJSProxy";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.builtinTag));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doNull";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "doUndefined";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doForeignObject";
            if ((state_0 & 0x10) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.foreignObject0_interop_));
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "doForeignObject";
            if ((state_0 & 0x20) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(new Object[0]));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[6] = s;
            s = new Object[3];
            s[0] = "doSymbol";
            s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[7] = s;
            s = new Object[3];
            s[0] = "doLazyString";
            s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[8] = s;
            s = new Object[3];
            s[0] = "doSafeInteger";
            s[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[9] = s;
            s = new Object[3];
            s[0] = "doBigInt";
            s[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[10] = s;
            s = new Object[3];
            s[0] = "doObject";
            s[1] = (state_0 & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[11] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypeToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPrototypeToStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectPrototypeBuiltins.ObjectPrototypeValueOfNode.class)
    public static final class ObjectPrototypeValueOfNodeGen
    extends ObjectPrototypeBuiltins.ObjectPrototypeValueOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private InteropLibrary valueOfForeign_interop_;

        private ObjectPrototypeValueOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSDynamicObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.valueOfJSObject((DynamicObject)arguments0Value__);
            }
            if ((state_0 & 2) != 0 && arguments0Value_ instanceof Symbol) {
                arguments0Value__ = (Symbol)arguments0Value_;
                return this.valueOfSymbol((Symbol)arguments0Value__);
            }
            if ((state_0 & 4) != 0 && arguments0Value_ instanceof JSLazyString) {
                arguments0Value__ = (JSLazyString)arguments0Value_;
                return this.valueOfLazyString((JSLazyString)arguments0Value__);
            }
            if ((state_0 & 8) != 0 && arguments0Value_ instanceof SafeInteger) {
                arguments0Value__ = (SafeInteger)arguments0Value_;
                return this.valueOfSafeInteger((SafeInteger)arguments0Value__);
            }
            if ((state_0 & 0x10) != 0 && arguments0Value_ instanceof BigInt) {
                arguments0Value__ = (BigInt)arguments0Value_;
                return this.valueOfBigInt((BigInt)arguments0Value__);
            }
            if ((state_0 & 0x60) != 0) {
                if ((state_0 & 0x20) != 0 && !JSGuards.isTruffleObject(arguments0Value_)) {
                    return this.valueOfOther(arguments0Value_);
                }
                if ((state_0 & 0x40) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.valueOfForeign(arguments0Value_, this.valueOfForeign_interop_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                Object object;
                Object arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSDynamicObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valueOfJSObject((DynamicObject)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof Symbol) {
                    arguments0Value_ = (Symbol)arguments0Value;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valueOfSymbol((Symbol)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof JSLazyString) {
                    arguments0Value_ = (JSLazyString)arguments0Value;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valueOfLazyString((JSLazyString)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof SafeInteger) {
                    arguments0Value_ = (SafeInteger)arguments0Value;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valueOfSafeInteger((SafeInteger)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof BigInt) {
                    arguments0Value_ = (BigInt)arguments0Value;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valueOfBigInt((BigInt)arguments0Value_);
                    return dynamicObject;
                }
                if (!JSGuards.isTruffleObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    object = this.valueOfOther(arguments0Value);
                    return object;
                }
                if (JSGuards.isForeignObject(arguments0Value)) {
                    this.valueOfForeign_interop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    object = this.valueOfForeign(arguments0Value, this.valueOfForeign_interop_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[8];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "valueOfJSObject";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "valueOfSymbol";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "valueOfLazyString";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "valueOfSafeInteger";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "valueOfBigInt";
            s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "valueOfOther";
            s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "valueOfForeign";
            if ((state_0 & 0x40) != 0) {
                s[1] = (byte)1;
                ArrayList<List<InteropLibrary>> cached = new ArrayList<List<InteropLibrary>>();
                cached.add(Arrays.asList(this.valueOfForeign_interop_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[7] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectPrototypeBuiltins.ObjectPrototypeValueOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPrototypeValueOfNodeGen(context, builtin, arguments);
        }
    }
}

