/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.threading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.trufflenode.JSExternalObject;
import com.oracle.truffle.trufflenode.threading.JavaMessagePortData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SharedMemMessagingManager {
    private static final Map<Long, JavaMessagePortData> activeMessagePortRefs = new ConcurrentHashMap<Long, JavaMessagePortData>();

    @CompilerDirectives.TruffleBoundary
    public static JavaMessagePortData getMessagePortDataFor(long nativePointer) {
        assert (activeMessagePortRefs.containsKey(nativePointer));
        return activeMessagePortRefs.get(nativePointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static JavaMessagePortData getJavaMessagePortDataFor(JSExternalObject nativeMessagePortData) {
        long pointer = nativeMessagePortData.getPointer();
        JavaMessagePortData data = activeMessagePortRefs.get(pointer);
        if (data == null) {
            data = new JavaMessagePortData(nativeMessagePortData);
            activeMessagePortRefs.put(pointer, data);
        }
        return data;
    }

    @CompilerDirectives.TruffleBoundary
    public static void disposeReferences(JSExternalObject nativeMessagePortData) {
        long pointer = nativeMessagePortData.getPointer();
        activeMessagePortRefs.remove(pointer);
    }
}

