/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.threading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.JSExternalObject;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingBindings;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingBuiltinsFactory;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingManager;

public class SharedMemMessagingBuiltins
extends JSBuiltinsContainer.SwitchEnum<API> {
    protected SharedMemMessagingBuiltins() {
        super("SharedMemMessaging.prototype", API.class);
    }

    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, API builtinEnum) {
        switch (builtinEnum) {
            case enter: {
                return SharedMemMessagingBuiltinsFactory.EnterNodeGen.create(context, builtin, SharedMemMessagingBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case leave: {
                return SharedMemMessagingBuiltinsFactory.LeaveNodeGen.create(context, builtin, SharedMemMessagingBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case free: {
                return SharedMemMessagingBuiltinsFactory.FreeNodeGen.create(context, builtin, SharedMemMessagingBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case encodedJavaRefs: {
                return SharedMemMessagingBuiltinsFactory.EncodedRefsNodeGen.create(context, builtin, SharedMemMessagingBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case dispose: {
                return SharedMemMessagingBuiltinsFactory.DisposeNodeGen.create(context, builtin, SharedMemMessagingBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class DisposeNode
    extends JSBuiltinNode {
        protected DisposeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object dispose(SharedMemMessagingBindings.Instance self, JSExternalObject external) {
            SharedMemMessagingManager.disposeReferences(external);
            return self;
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Fallback
        final Object incompatibleReceiver(Object self, Object external) {
            if (self instanceof SharedMemMessagingBindings.Instance) {
                throw Errors.createTypeErrorTypeXExpected((String)"external");
            }
            throw Errors.createTypeErrorIncompatibleReceiver((String)this.getBuiltin().getFullName(), (Object)self);
        }
    }

    public static abstract class LeaveNode
    extends JSBuiltinNode {
        protected LeaveNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object leave(SharedMemMessagingBindings.Instance self) {
            GraalJSAccess access = SharedMemMessagingBindings.getApiField(self);
            access.unsetCurrentMessagePortData();
            return self;
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Fallback
        final Object incompatibleReceiver(Object self) {
            throw Errors.createTypeErrorIncompatibleReceiver((String)this.getBuiltin().getFullName(), (Object)self);
        }
    }

    public static abstract class FreeNode
    extends JSBuiltinNode {
        protected FreeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object free(SharedMemMessagingBindings.Instance self) {
            GraalJSAccess access = SharedMemMessagingBindings.getApiField(self);
            access.getCurrentMessagePortData().disposeLastMessageRefs();
            return self;
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Fallback
        final Object incompatibleReceiver(Object self) {
            throw Errors.createTypeErrorIncompatibleReceiver((String)this.getBuiltin().getFullName(), (Object)self);
        }
    }

    public static abstract class EncodedRefsNode
    extends JSBuiltinNode {
        protected EncodedRefsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static boolean encodedJavaRefs(SharedMemMessagingBindings.Instance self) {
            GraalJSAccess access = SharedMemMessagingBindings.getApiField(self);
            assert (access.getCurrentMessagePortData() != null);
            return access.getCurrentMessagePortData().encodedJavaRefs();
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Fallback
        final Object incompatibleReceiver(Object self) {
            throw Errors.createTypeErrorIncompatibleReceiver((String)this.getBuiltin().getFullName(), (Object)self);
        }
    }

    public static abstract class EnterNode
    extends JSBuiltinNode {
        protected EnterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object enter(SharedMemMessagingBindings.Instance self, JSExternalObject nativeMessagePortData) {
            GraalJSAccess access = SharedMemMessagingBindings.getApiField(self);
            access.setCurrentMessagePortData(nativeMessagePortData);
            return self;
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Fallback
        public Object incompatibleReceiver(Object self, Object external) {
            if (self instanceof SharedMemMessagingBindings.Instance) {
                throw Errors.createTypeErrorTypeXExpected((String)"external");
            }
            throw Errors.createTypeErrorIncompatibleReceiver((String)this.getBuiltin().getFullName(), (Object)self);
        }
    }

    public static enum API implements BuiltinEnum<API>
    {
        enter(1),
        leave(0),
        free(0),
        encodedJavaRefs(0),
        dispose(1);

        private final int length;

        private API(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }
    }
}

