/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.node;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.ArrayBufferViewGetByteLengthNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.JSExternal;
import com.oracle.truffle.trufflenode.node.ValueTypeNodeGen;

@ImportStatic(value={JSExternal.class, JSRuntime.class, JSMap.class, JSSet.class, JSPromise.class, JSProxy.class, JSObject.class, JSDataView.class})
abstract class ValueTypeNode
extends JavaScriptBaseNode {
    protected final GraalJSAccess graalAccess;
    protected final JSContext context;
    protected final boolean useSharedBuffer;

    ValueTypeNode(GraalJSAccess graalAccess, JSContext context, boolean useSharedBuffer) {
        this.graalAccess = graalAccess;
        this.context = context;
        this.useSharedBuffer = useSharedBuffer;
    }

    public static ValueTypeNode create(GraalJSAccess graalAccess, JSContext context, boolean useSharedBuffer) {
        return ValueTypeNodeGen.create(graalAccess, context, useSharedBuffer);
    }

    protected abstract int executeInt(Object var1);

    protected JSContext getContext() {
        return this.context;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static int doUndefined(DynamicObject value) {
        return 1;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static int doNull(DynamicObject value) {
        return 2;
    }

    @Specialization
    protected static int doBoolean(boolean value) {
        return value ? 3 : 4;
    }

    @Specialization
    protected static int doString(String value) {
        return 5;
    }

    @Specialization
    protected final int doInt(int value) {
        return this.doDouble(value);
    }

    @Specialization
    protected final int doDouble(double value) {
        if (this.useSharedBuffer) {
            this.graalAccess.getSharedBuffer().putDouble(value);
        }
        return 6;
    }

    @Specialization(guards={"isNumber(value)"}, replaces={"doInt", "doDouble"})
    protected final int doNumber(Object value) {
        if (this.useSharedBuffer) {
            this.graalAccess.getSharedBuffer().putDouble(JSRuntime.doubleValue((Number)((Number)value)));
        }
        return 6;
    }

    @Specialization(guards={"isJSExternalObject(value)"})
    protected static int doExternalObject(DynamicObject value) {
        return 7;
    }

    @Specialization(guards={"isJSFunction(value)"})
    protected static int doFunction(DynamicObject value) {
        return 8;
    }

    @Specialization(guards={"isJSArray(value)"})
    protected static int doArray(DynamicObject value) {
        return 9;
    }

    @Specialization(guards={"isJSDate(value)"})
    protected static int doDate(DynamicObject value) {
        return 10;
    }

    @Specialization(guards={"isJSRegExp(value)"})
    protected static int doRegExp(DynamicObject value) {
        return 11;
    }

    @Specialization(guards={"isJSMap(value)"})
    protected static int doMap(DynamicObject value) {
        return 26;
    }

    @Specialization(guards={"isJSSet(value)"})
    protected static int doSet(DynamicObject value) {
        return 27;
    }

    @Specialization(guards={"isJSPromise(value)"})
    protected static int doPromise(DynamicObject value) {
        return 28;
    }

    @Specialization(guards={"isJSProxy(value)"})
    protected static int doProxy(DynamicObject value) {
        return 29;
    }

    @Specialization(guards={"cachedArray == value.getArrayType()"})
    protected final int doArrayBufferView(JSTypedArrayObject value, @Cached(value="value.getArrayType()") TypedArray cachedArray, @Cached(value="identifyType(cachedArray)") int cachedTypeInt, @Cached(value="create(getContext())") ArrayBufferViewGetByteLengthNode getByteLengthNode) {
        assert (JSArrayBufferView.isJSArrayBufferView((Object)value));
        if (this.useSharedBuffer) {
            this.graalAccess.getSharedBuffer().putInt(getByteLengthNode.executeInt((DynamicObject)value));
            this.graalAccess.getSharedBuffer().putInt(GraalJSAccess.arrayBufferViewByteOffset(this.context, (DynamicObject)value));
        }
        return cachedTypeInt;
    }

    @Specialization(replaces={"doArrayBufferView"})
    protected final int doArrayBufferViewOverLimit(JSTypedArrayObject value, @Cached(value="create(getContext())") ArrayBufferViewGetByteLengthNode getByteLengthNode) {
        assert (JSArrayBufferView.isJSArrayBufferView((Object)value));
        if (this.useSharedBuffer) {
            this.graalAccess.getSharedBuffer().putInt(getByteLengthNode.executeInt((DynamicObject)value));
            this.graalAccess.getSharedBuffer().putInt(GraalJSAccess.arrayBufferViewByteOffset(this.context, (DynamicObject)value));
        }
        TypedArray array = value.getArrayType();
        return this.identifyType((ScriptArray)array);
    }

    @Specialization(guards={"isJSDataView(value)"})
    protected final int doDataView(DynamicObject value) {
        if (this.useSharedBuffer) {
            this.graalAccess.getSharedBuffer().putInt(GraalJSAccess.arrayBufferViewByteLength(this.context, value));
            this.graalAccess.getSharedBuffer().putInt(GraalJSAccess.arrayBufferViewByteOffset(this.context, value));
        }
        return 30;
    }

    protected int identifyType(ScriptArray array) {
        if (array instanceof TypedArray.DirectUint8Array) {
            return 17;
        }
        if (array instanceof TypedArray.DirectUint8ClampedArray) {
            return 18;
        }
        if (array instanceof TypedArray.DirectInt8Array) {
            return 20;
        }
        if (array instanceof TypedArray.DirectUint16Array) {
            return 21;
        }
        if (array instanceof TypedArray.DirectInt16Array) {
            return 22;
        }
        if (array instanceof TypedArray.DirectUint32Array) {
            return 19;
        }
        if (array instanceof TypedArray.DirectInt32Array) {
            return 23;
        }
        if (array instanceof TypedArray.DirectFloat32Array) {
            return 24;
        }
        if (array instanceof TypedArray.DirectFloat64Array) {
            return 25;
        }
        if (array instanceof TypedArray.DirectBigInt64Array) {
            return 32;
        }
        if (array instanceof TypedArray.DirectBigUint64Array) {
            return 33;
        }
        return 14;
    }

    @Specialization(guards={"isJSDirectArrayBuffer(value)"})
    protected static int doArrayBuffer(DynamicObject value) {
        return 15;
    }

    @Specialization(guards={"isJSOrdinaryObject(value)"})
    protected static int doOrdinaryObject(DynamicObject value) {
        return 12;
    }

    @Specialization(guards={"isJSObject(value)", "!isUndefined(value)", "!isJSNull(value)", "!isJSExternalObject(value)", "!isJSFunction(value)", "!isJSArray(value)", "!isJSDate(value)", "!isJSRegExp(value)", "!isJSMap(value)", "!isJSSet(value)", "!isJSPromise(value)", "!isJSProxy(value)", "!isJSArrayBufferView(value)", "!isJSDataView(value)", "!isJSDirectArrayBuffer(value)"}, replaces={"doOrdinaryObject"})
    protected static int doObject(DynamicObject value) {
        return 12;
    }

    @Specialization(guards={"isLazyString(value)"})
    protected static int doCharSequence(CharSequence value) {
        return 13;
    }

    @Specialization
    protected static int doSymbol(Symbol value) {
        return 16;
    }

    @Specialization
    protected static int doBigInt(BigInt value) {
        return 31;
    }

    @Specialization(guards={"isForeignObject(value)"}, limit="5")
    protected final int doForeignObject(TruffleObject value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isExecutable((Object)value) || interop.isInstantiable((Object)value)) {
            return 8;
        }
        if (interop.isNull((Object)value)) {
            return 2;
        }
        if (interop.isBoolean((Object)value)) {
            try {
                return interop.asBoolean((Object)value) ? 3 : 4;
            }
            catch (UnsupportedMessageException e) {
                return ValueTypeNode.doFallback(value);
            }
        }
        if (interop.isString((Object)value)) {
            return 5;
        }
        if (interop.isNumber((Object)value)) {
            return this.graalAccess.valueTypeForeignNumber(value, interop, this.useSharedBuffer);
        }
        return 12;
    }

    @Fallback
    protected static int doFallback(Object value) {
        GraalJSAccess.valueTypeError(value);
        return -1;
    }
}

