/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.node;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.NativeAccess;
import com.oracle.truffle.trufflenode.info.FunctionTemplate;
import com.oracle.truffle.trufflenode.info.ObjectTemplate;
import com.oracle.truffle.trufflenode.node.FlattenNode;
import com.oracle.truffle.trufflenode.node.FlattenNodeGen;
import com.oracle.truffle.trufflenode.node.ObjectTemplateNode;
import com.oracle.truffle.trufflenode.node.ValueTypeNode;
import com.oracle.truffle.trufflenode.node.ValueTypeNodeGen;

public class ExecuteNativeFunctionNode
extends JavaScriptNode {
    private final GraalJSAccess graalAccess;
    private final JSContext context;
    private final FunctionTemplate functionTemplate;
    private final FunctionTemplate signature;
    private final ObjectTemplate instanceTemplate;
    private final boolean hasPropertyHandler;
    private final boolean isNew;
    private final boolean isNewTarget;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final ConditionProfile isTemplate = ConditionProfile.createBinaryProfile();
    private final ConditionProfile eightOrLessArgs = ConditionProfile.createBinaryProfile();
    private final ConditionProfile argumentLengthTwo = ConditionProfile.createBinaryProfile();
    private final int templateID;
    private final long functionPointer;
    private static final int IMPLICIT_ARG_COUNT = 2;
    private static final int EXPLICIT_ARG_COUNT = 6;
    @Node.Children
    private final ValueTypeNode[] valueTypeNodes;
    @Node.Children
    private final FlattenNode[] flattenNodes;
    private static final boolean USE_TEMPLATE_NODES = true;
    @Node.Child
    private ObjectTemplateNode instanceTemplateNode;
    @Node.Child
    private PropertySetNode setConstructorTemplateNode;
    @Node.Child
    private PropertyGetNode getConstructorTemplateNode;
    private static int sourceSectionCounter;

    ExecuteNativeFunctionNode(GraalJSAccess graalAccess, JSContext context, FunctionTemplate template, boolean isNew, boolean isNewTarget) {
        super(ExecuteNativeFunctionNode.createSourceSection());
        this.graalAccess = graalAccess;
        this.context = context;
        this.functionTemplate = template;
        this.signature = template.getSignature();
        this.instanceTemplate = template.getInstanceTemplate();
        this.hasPropertyHandler = this.instanceTemplate.hasPropertyHandler();
        this.isNew = isNew;
        this.isNewTarget = isNewTarget;
        this.templateID = template.getID();
        this.functionPointer = template.getFunctionPointer();
        this.valueTypeNodes = new ValueTypeNode[8];
        this.flattenNodes = new FlattenNode[6];
    }

    private static SourceSection createSourceSection() {
        return Source.newBuilder((String)"js", (CharSequence)"", (String)("<native$" + ++sourceSectionCounter + ">")).build().createUnavailableSection();
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.RootTag.class) {
            return true;
        }
        return tag == StandardTags.RootBodyTag.class;
    }

    public Object execute(VirtualFrame frame) {
        Object result;
        Object newTarget;
        int offset;
        Object[] arguments = frame.getArguments();
        Object thisObject = arguments[0];
        JSRealm realm = JSFunction.getRealm((DynamicObject)JSFrameUtil.getFunctionObject((Frame)frame));
        if (this.isNew) {
            DynamicObject thisDynamicObject = (DynamicObject)thisObject;
            this.objectTemplateInstantiate(frame, thisDynamicObject, realm);
            if (this.hasPropertyHandler) {
                thisObject = this.graalAccess.propertyHandlerInstantiate(this.context, realm, this.instanceTemplate, thisDynamicObject, false);
            }
            this.setConstructorTemplate(thisDynamicObject);
        } else if (this.signature != null) {
            this.checkConstructorTemplate(thisObject);
        }
        int n = offset = this.isNewTarget ? 1 : 0;
        Object object = this.isNew ? (this.isNewTarget ? arguments[2] : arguments[1]) : (newTarget = null);
        if (this.isTemplate.profile(this.functionPointer == 0L)) {
            result = thisObject;
        } else if (this.eightOrLessArgs.profile(arguments.length <= 8 + offset)) {
            int thisType = this.getValueType(0, thisObject);
            Object calleeObject = arguments[1];
            if (this.argumentLengthTwo.profile(arguments.length == 2 + offset)) {
                result = this.executeFunction0(thisObject, thisType, calleeObject, newTarget, realm);
            } else {
                this.graalAccess.resetSharedBuffer();
                Object argument1 = this.flatten(0, arguments[2 + offset]);
                int argument1Type = this.getValueType(2, argument1);
                if (arguments.length == 3 + offset) {
                    result = this.executeFunction1(thisObject, thisType, calleeObject, newTarget, argument1, argument1Type, realm);
                } else {
                    Object argument2 = this.flatten(1, arguments[3 + offset]);
                    int argument2Type = this.getValueType(3, argument2);
                    if (arguments.length == 4 + offset) {
                        result = this.executeFunction2(thisObject, thisType, calleeObject, newTarget, argument1, argument1Type, argument2, argument2Type, realm);
                    } else {
                        Object argument3 = this.flatten(2, arguments[4 + offset]);
                        int argument3Type = this.getValueType(4, argument3);
                        if (arguments.length == 5 + offset) {
                            result = this.executeFunction3(thisObject, thisType, calleeObject, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, realm);
                        } else {
                            Object argument4 = this.flatten(3, arguments[5 + offset]);
                            int argument4Type = this.getValueType(5, argument4);
                            if (arguments.length == 6 + offset) {
                                result = this.executeFunction4(thisObject, thisType, calleeObject, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, argument4, argument4Type, realm);
                            } else {
                                Object argument5 = this.flatten(4, arguments[6 + offset]);
                                int argument5Type = this.getValueType(6, argument5);
                                if (arguments.length == 7 + offset) {
                                    result = this.executeFunction5(thisObject, thisType, calleeObject, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, argument4, argument4Type, argument5, argument5Type, realm);
                                } else {
                                    assert (arguments.length == 8 + offset);
                                    Object argument6 = this.flatten(5, arguments[7 + offset]);
                                    int argument6Type = this.getValueType(7, argument6);
                                    result = this.executeFunction6(thisObject, thisType, calleeObject, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, argument4, argument4Type, argument5, argument5Type, argument6, argument6Type, realm);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            result = this.executeFunction(arguments, realm);
        }
        return this.graalAccess.correctReturnValue(result);
    }

    private void objectTemplateInstantiate(VirtualFrame frame, DynamicObject thisObject, JSRealm realm) {
        if (this.instanceTemplateNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.instanceTemplateNode = (ObjectTemplateNode)this.insert((Node)ObjectTemplateNode.fromObjectTemplate(this.instanceTemplate, this.context, this.graalAccess));
        }
        this.instanceTemplateNode.executeWithObject(frame, thisObject);
    }

    private void setConstructorTemplate(DynamicObject thisObject) {
        if (this.setConstructorTemplateNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setConstructorTemplateNode = (PropertySetNode)this.insert((Node)PropertySetNode.createSetHidden((HiddenKey)FunctionTemplate.CONSTRUCTOR, (JSContext)this.context));
        }
        this.setConstructorTemplateNode.setValue((Object)thisObject, (Object)this.functionTemplate);
    }

    private Object getConstructorTemplate(DynamicObject thisObject) {
        Object result;
        if (this.getConstructorTemplateNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getConstructorTemplateNode = (PropertyGetNode)this.insert((Node)PropertyGetNode.createGetHidden((HiddenKey)FunctionTemplate.CONSTRUCTOR, (JSContext)this.context));
        }
        return (result = this.getConstructorTemplateNode.getValue((Object)thisObject)) == Undefined.instance ? null : result;
    }

    private void checkConstructorTemplate(Object thisObject) {
        FunctionTemplate constructorTemplate;
        FunctionTemplate functionTemplate = constructorTemplate = thisObject instanceof DynamicObject ? (FunctionTemplate)this.getConstructorTemplate((DynamicObject)thisObject) : null;
        while (constructorTemplate != this.signature && constructorTemplate != null) {
            constructorTemplate = constructorTemplate.getParent();
        }
        if (constructorTemplate == null) {
            this.errorBranch.enter();
            ExecuteNativeFunctionNode.illegalInvocation();
        }
    }

    private static void illegalInvocation() {
        throw Errors.createTypeError((String)"Illegal invocation");
    }

    private int getValueType(int index, Object argument) {
        if (this.valueTypeNodes[index] == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.valueTypeNodes[index] = (ValueTypeNode)this.insert((Node)ValueTypeNodeGen.create(this.graalAccess, this.context, index >= 2));
        }
        int type = this.valueTypeNodes[index].executeInt(argument);
        assert (type == this.graalAccess.valueType(argument, false));
        return type;
    }

    private Object flatten(int index, Object argument) {
        if (this.flattenNodes[index] == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.flattenNodes[index] = (FlattenNode)this.insert((Node)FlattenNodeGen.create());
        }
        return this.flattenNodes[index].execute(argument);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction(Object[] arguments, JSRealm realm) {
        return NativeAccess.executeFunction(this.templateID, arguments, this.isNew, this.isNewTarget, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction0(Object thisObject, int thisType, Object calleeObject, Object newTarget, JSRealm realm) {
        return NativeAccess.executeFunction0(this.templateID, thisObject, thisType, newTarget, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction1(Object thisObject, int thisType, Object calleeObject, Object newTarget, Object argument, int argumentType, JSRealm realm) {
        return NativeAccess.executeFunction1(this.templateID, thisObject, thisType, newTarget, argument, argumentType, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction2(Object thisObject, int thisType, Object calleeObject, Object newTarget, Object argument1, int argument1Type, Object argument2, int argument2Type, JSRealm realm) {
        return NativeAccess.executeFunction2(this.templateID, thisObject, thisType, newTarget, argument1, argument1Type, argument2, argument2Type, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction3(Object thisObject, int thisType, Object calleeObject, Object newTarget, Object argument1, int argument1Type, Object argument2, int argument2Type, Object argument3, int argument3Type, JSRealm realm) {
        return NativeAccess.executeFunction3(this.templateID, thisObject, thisType, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction4(Object thisObject, int thisType, Object calleeObject, Object newTarget, Object argument1, int argument1Type, Object argument2, int argument2Type, Object argument3, int argument3Type, Object argument4, int argument4Type, JSRealm realm) {
        return NativeAccess.executeFunction4(this.templateID, thisObject, thisType, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, argument4, argument4Type, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction5(Object thisObject, int thisType, Object calleeObject, Object newTarget, Object argument1, int argument1Type, Object argument2, int argument2Type, Object argument3, int argument3Type, Object argument4, int argument4Type, Object argument5, int argument5Type, JSRealm realm) {
        return NativeAccess.executeFunction5(this.templateID, thisObject, thisType, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, argument4, argument4Type, argument5, argument5Type, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeFunction6(Object thisObject, int thisType, Object calleeObject, Object newTarget, Object argument1, int argument1Type, Object argument2, int argument2Type, Object argument3, int argument3Type, Object argument4, int argument4Type, Object argument5, int argument5Type, Object argument6, int argument6Type, JSRealm realm) {
        return NativeAccess.executeFunction6(this.templateID, thisObject, thisType, newTarget, argument1, argument1Type, argument2, argument2Type, argument3, argument3Type, argument4, argument4Type, argument5, argument5Type, argument6, argument6Type, realm);
    }

    public static class NativeFunctionRootNode
    extends JavaScriptRootNode {
        @Node.Child
        private JavaScriptNode node;
        private final GraalJSAccess graalAccess;
        private final JSContext context;
        private final FunctionTemplate template;
        private final boolean isNew;
        private final boolean isNewTarget;

        public NativeFunctionRootNode(GraalJSAccess graalAccess, JSContext context, FunctionTemplate template, boolean isNew, boolean isNewTarget) {
            this.graalAccess = graalAccess;
            this.template = template;
            this.context = context;
            this.isNew = isNew;
            this.isNewTarget = isNewTarget;
        }

        public Object execute(VirtualFrame frame) {
            if (this.node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.node = (JavaScriptNode)this.insert((Node)new ExecuteNativeFunctionNode(this.graalAccess, this.context, this.template, this.isNew, this.isNewTarget));
            }
            return this.node.execute(frame);
        }

        public String getName() {
            return JSFunction.getFunctionData((DynamicObject)this.template.getFunctionObject(this.context.getRealm())).getName();
        }

        public boolean isFunction() {
            return true;
        }
    }
}

