/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@CompilerDirectives.ValueType
public final class LLVMI8Vector
extends LLVMVector {
    private final byte[] vector;

    public static LLVMI8Vector create(byte[] vector) {
        return new LLVMI8Vector(vector);
    }

    private LLVMI8Vector(byte[] vector) {
        this.vector = vector;
    }

    public byte getValue(int index) {
        return this.vector[index];
    }

    @Override
    public int getLength() {
        return this.vector.length;
    }

    @Override
    public Type getElementType() {
        return PrimitiveType.I8;
    }

    @Override
    public Object getElement(int index) {
        return index >= 0 && index < this.vector.length ? Byte.valueOf(this.vector[index]) : null;
    }
}

