/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types.visitors;

import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.OpaqueType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class RecursiveTypeCheckVisitor
implements TypeVisitor {
    private final Type root;

    public static void check(Type root, Type addedType) {
        if (root instanceof PointerType && RecursiveTypeCheckVisitor.isNamedStruct(addedType)) {
            return;
        }
        new RecursiveTypeCheckVisitor(root).check(addedType);
    }

    private RecursiveTypeCheckVisitor(Type root) {
        this.root = root;
    }

    private static boolean isNamedStruct(Type type) {
        return type instanceof StructureType && ((StructureType)type).isNamed();
    }

    private void check(Type type) {
        if (type == null) {
            return;
        }
        if (type == this.root) {
            throw new LLVMParserException("Invalid bitcode: recursive " + type.getClass().getSimpleName());
        }
        type.accept(this);
    }

    @Override
    public void visit(ArrayType type) {
        this.check(type.getElementType());
    }

    @Override
    public void visit(VectorType type) {
        this.check(type.getElementType());
    }

    @Override
    public void visit(StructureType type) {
        for (int i = 0; i < type.getNumberOfElementsInt(); ++i) {
            this.check(type.getElementType(i));
        }
    }

    @Override
    public void visit(FunctionType type) {
        this.check(type.getReturnType());
        for (int i = 0; i < type.getNumberOfArguments(); ++i) {
            this.check(type.getArgumentType(i));
        }
    }

    @Override
    public void visit(PointerType type) {
        Type pointeeType = type.getPointeeType();
        if (RecursiveTypeCheckVisitor.isNamedStruct(pointeeType)) {
            return;
        }
        this.check(pointeeType);
    }

    @Override
    public void visit(PrimitiveType type) {
    }

    @Override
    public void visit(MetaType type) {
    }

    @Override
    public void visit(VariableBitWidthType type) {
    }

    @Override
    public void visit(VoidType type) {
    }

    @Override
    public void visit(OpaqueType type) {
    }
}

