/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class VectorType
extends AggregateType {
    private Type elementType;
    private final int length;

    public VectorType(Type elementType, int length) {
        if (elementType != null && !(elementType instanceof PrimitiveType) && !(elementType instanceof PointerType)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new AssertionError((Object)("Invalid ElementType of Vector: " + elementType.getClass().getSimpleName()));
        }
        this.elementType = elementType;
        this.length = length;
    }

    public Type getElementType() {
        CompilerAsserts.neverPartOfCompilation();
        return this.elementType;
    }

    @Override
    public long getBitSize() throws Type.TypeOverflowException {
        return VectorType.multiplyUnsignedExact(this.getElementType().getBitSize(), this.length);
    }

    @Override
    public long getNumberOfElements() {
        return Integer.toUnsignedLong(this.length);
    }

    public int getNumberOfElementsInt() {
        return this.length;
    }

    public void setElementType(Type elementType) {
        CompilerAsserts.neverPartOfCompilation();
        if (!(elementType instanceof PrimitiveType) && !(elementType instanceof PointerType)) {
            throw new AssertionError((Object)("Invalid ElementType of Vector: " + (elementType == null ? "null" : elementType.getClass().getSimpleName())));
        }
        this.verifyCycleFree(elementType);
        this.elementType = elementType;
    }

    @Override
    public Type getElementType(long index) {
        return this.getElementType();
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        return this.getElementType().getAlignment(targetDataLayout);
    }

    @Override
    public long getSize(DataLayout targetDataLayout) throws Type.TypeOverflowException {
        return VectorType.multiplyUnsignedExact(this.getElementType().getSize(targetDataLayout), Integer.toUnsignedLong(this.length));
    }

    @Override
    public long getOffsetOf(long index, DataLayout targetDataLayout) throws Type.TypeOverflowException {
        return VectorType.multiplyUnsignedExact(this.getElementType().getSize(targetDataLayout), index);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("< %d x %s >", this.getNumberOfElements(), this.getElementType());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getElementType() == null ? 0 : this.getElementType().hashCode());
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VectorType other = (VectorType)obj;
        if (this.getElementType() == null ? other.getElementType() != null : !this.getElementType().equals(other.getElementType())) {
            return false;
        }
        return this.length == other.length;
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return nodeFactory.createZeroVectorInitializer(this.getNumberOfElementsInt(), this);
    }
}

