/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class StructureType
extends AggregateType {
    private final String name;
    private final boolean isPacked;
    private final boolean isNamed;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Type[] types;
    private long size = -1L;

    private StructureType(String name, boolean isPacked, boolean isNamed, Type[] types) {
        this.name = name;
        this.isPacked = isPacked;
        this.isNamed = isNamed;
        this.types = types;
    }

    public static StructureType createNamed(String name, boolean isPacked, Type type0) {
        return new StructureType(name, isPacked, true, new Type[]{type0});
    }

    public static StructureType createNamed(String name, boolean isPacked, Type type0, Type type1) {
        return new StructureType(name, isPacked, true, new Type[]{type0, type1});
    }

    public static StructureType createNamedFromList(String name, boolean isPacked, ArrayList<Type> types) {
        return new StructureType(name, isPacked, true, types.toArray(Type.EMPTY_ARRAY));
    }

    public static StructureType createUnnamed(boolean isPacked, Type type0) {
        return new StructureType("<anon>", isPacked, false, new Type[]{type0});
    }

    public static StructureType createUnnamed(boolean isPacked, Type type0, Type type1) {
        return new StructureType("<anon>", isPacked, false, new Type[]{type0, type1});
    }

    public static StructureType createUnnamed(boolean isPacked, Type type0, Type type1, Type type2) {
        return new StructureType("<anon>", isPacked, false, new Type[]{type0, type1, type2});
    }

    public StructureType(String name, boolean isPacked, int numElements) {
        this(name, isPacked, true, new Type[numElements]);
    }

    public StructureType(boolean isPacked, int numElements) {
        this("<anon>", isPacked, false, new Type[numElements]);
    }

    public void setElementType(int idx, Type type) {
        this.verifyCycleFree(type);
        this.types[idx] = type;
    }

    public boolean isPacked() {
        return this.isPacked;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNamed() {
        return this.isNamed;
    }

    @Override
    public long getBitSize() throws Type.TypeOverflowException {
        if (this.isPacked) {
            try {
                return Arrays.stream(this.types).mapToLong(Type::getBitSizeUnchecked).reduce(0L, Type::addUnsignedExactUnchecked);
            }
            catch (Type.TypeOverflowExceptionUnchecked e) {
                throw e.getCause();
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("TargetDataLayout is necessary to compute Padding information!");
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public long getNumberOfElements() {
        return this.types.length;
    }

    public int getNumberOfElementsInt() {
        return this.types.length;
    }

    @Override
    public Type getElementType(long index) {
        assert (index == (long)((int)index));
        return this.types[(int)index];
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        return this.isPacked ? 1 : this.getLargestAlignment(targetDataLayout);
    }

    @Override
    public long getSize(DataLayout targetDataLayout) throws Type.TypeOverflowException {
        if (this.size != -1L) {
            return this.size;
        }
        long sumByte = 0L;
        for (Type elementType : this.types) {
            if (!this.isPacked) {
                sumByte = StructureType.addUnsignedExact(sumByte, Type.getPadding(sumByte, elementType, targetDataLayout));
            }
            sumByte = StructureType.addUnsignedExact(sumByte, elementType.getSize(targetDataLayout));
        }
        long padding = 0L;
        if (!this.isPacked && sumByte != 0L) {
            padding = Type.getPadding(sumByte, this.getAlignment(targetDataLayout));
        }
        this.size = Math.addExact(sumByte, padding);
        return this.size;
    }

    @Override
    public long getOffsetOf(long index, DataLayout targetDataLayout) throws Type.TypeOverflowException {
        long offset = 0L;
        int i = 0;
        while ((long)i < index) {
            Type elementType = this.types[i];
            if (!this.isPacked) {
                offset = StructureType.addUnsignedExact(offset, Type.getPadding(offset, elementType, targetDataLayout));
            }
            offset = StructureType.addUnsignedExact(offset, elementType.getSize(targetDataLayout));
            ++i;
        }
        if (!this.isPacked && this.getSize(targetDataLayout) > offset) {
            assert (index == (long)((int)index));
            offset = Math.addExact(offset, (long)Type.getPadding(offset, this.types[(int)index], targetDataLayout));
        }
        return offset;
    }

    private int getLargestAlignment(DataLayout targetDataLayout) {
        int largestAlignment = 0;
        for (Type elementType : this.types) {
            largestAlignment = Math.max(largestAlignment, elementType.getAlignment(targetDataLayout));
        }
        return largestAlignment;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (!this.isNamed()) {
            return Arrays.stream(this.types).map(String::valueOf).collect(Collectors.joining(", ", "%{", "}"));
        }
        return this.name;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isPacked ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureType other = (StructureType)obj;
        if (this.isPacked != other.isPacked) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.types, other.types);
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        try {
            long structSize = this.getSize(dataLayout);
            if (structSize == 0L) {
                LLVMNativePointer minusOneNode = LLVMNativePointer.create(-1L);
                return CommonNodeFactory.createLiteral(minusOneNode, new PointerType(this));
            }
            LLVMExpressionNode addressnode = stackFactory.createGetStackSpace(nodeFactory, this);
            return nodeFactory.createZeroNode(addressnode, structSize);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }
}

