/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class MetaType
extends Type {
    public static final MetaType UNKNOWN = new MetaType("unknown");
    public static final MetaType LABEL = new MetaType("label");
    public static final MetaType TOKEN = new MetaType("token");
    public static final MetaType METADATA = new MetaType("metadata");
    public static final MetaType X86MMX = new MetaType("x86mmx");
    public static final MetaType DEBUG = new MetaType("debug");
    private final String name;
    private final Object identity;

    private MetaType(String name) {
        this.name = name;
        this.identity = new Object();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaType other = (MetaType)obj;
        return !(this.identity == null ? other.identity != null : !this.identity.equals(other.identity));
    }

    @Override
    public long getBitSize() {
        return 0L;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        return 8;
    }

    @Override
    public long getSize(DataLayout targetDataLayout) {
        return 0L;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        if (this == DEBUG) {
            return CommonNodeFactory.createSimpleConstantNoArray(null, this);
        }
        throw new LLVMParserException("Unsupported Type for Zero Constant: " + this);
    }
}

