/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FunctionType
extends Type {
    private Type returnType;
    private final Type[] argumentTypes;
    private final boolean isVarargs;

    private FunctionType(Type returnType, Type[] argumentTypes, boolean isVarargs) {
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.isVarargs = isVarargs;
    }

    public static FunctionType create(Type returnType, Type arg0, boolean isVarargs) {
        return new FunctionType(returnType, new Type[]{arg0}, isVarargs);
    }

    public FunctionType(Type returnType, Type.TypeArrayBuilder argumentTypes, boolean isVarargs) {
        this(returnType, FunctionType.getRawTypeArray(argumentTypes), isVarargs);
    }

    public FunctionType(Type returnType, int numArguments, boolean isVarargs) {
        this(returnType, new Type[numArguments], isVarargs);
    }

    public static FunctionType copy(FunctionType type) {
        return new FunctionType(type.returnType, (Type[])type.argumentTypes.clone(), type.isVarargs);
    }

    public void setArgumentType(int idx, Type type) {
        this.verifyCycleFree(type);
        this.argumentTypes[idx] = type;
    }

    public List<Type> getArgumentTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.argumentTypes));
    }

    public Type getArgumentType(int idx) {
        return this.argumentTypes[idx];
    }

    public int getNumberOfArguments() {
        return this.argumentTypes.length;
    }

    public Type getReturnType() {
        CompilerAsserts.neverPartOfCompilation();
        return this.returnType;
    }

    public void setReturnType(Type returnType) {
        CompilerAsserts.neverPartOfCompilation();
        this.verifyCycleFree(returnType);
        this.returnType = returnType;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    @Override
    public long getBitSize() {
        return 0L;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        if (targetDataLayout != null) {
            return targetDataLayout.getBitAlignment(this) / 8;
        }
        return 8;
    }

    @Override
    public long getSize(DataLayout targetDataLayout) {
        return 8L;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReturnType()).append(" (");
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.argumentTypes[i]);
        }
        if (this.isVarargs) {
            if (this.argumentTypes.length > 0) {
                sb.append(", ");
            }
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.argumentTypes);
        result = 31 * result + (this.isVarargs ? 1231 : 1237);
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionType other = (FunctionType)obj;
        if (!Arrays.equals(this.argumentTypes, other.argumentTypes)) {
            return false;
        }
        if (this.isVarargs != other.isVarargs) {
            return false;
        }
        return !(this.getReturnType() == null ? other.getReturnType() != null : !this.getReturnType().equals(other.getReturnType()));
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return CommonNodeFactory.createSimpleConstantNoArray(null, this);
    }
}

