/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pthread;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMPThreadStart;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class LLVMPThreadContext {
    private final TruffleLanguage.Env env;
    private final Object threadLock;
    private final ConcurrentMap<Long, Object> threadReturnValueStorage;
    private final ConcurrentMap<Long, Thread> threadStorage;
    private volatile boolean isCreateThreadAllowed;
    private int pThreadKey;
    private final Object pThreadKeyLock;
    private final ConcurrentMap<Integer, ConcurrentMap<Long, LLVMPointer>> pThreadKeyStorage;
    private final ConcurrentMap<Integer, LLVMPointer> pThreadDestructorStorage;
    private final CallTarget pthreadCallTarget;

    public LLVMPThreadContext(TruffleLanguage.Env env, LLVMLanguage language, DataLayout dataLayout) {
        this.env = env;
        this.threadLock = new Object();
        this.threadReturnValueStorage = new ConcurrentHashMap<Long, Object>();
        this.threadStorage = new ConcurrentHashMap<Long, Thread>();
        this.pThreadKey = 0;
        this.pThreadKeyLock = new Object();
        this.pThreadKeyStorage = new ConcurrentHashMap<Integer, ConcurrentMap<Long, LLVMPointer>>();
        this.pThreadDestructorStorage = new ConcurrentHashMap<Integer, LLVMPointer>();
        NodeFactory nodeFactory = language.getActiveConfiguration().createNodeFactory(language, dataLayout);
        FrameDescriptor descriptor = LLVMPThreadStart.LLVMPThreadFunctionRootNode.createFrameDescriptor();
        this.pthreadCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new LLVMPThreadStart.LLVMPThreadFunctionRootNode(language, descriptor, nodeFactory));
        this.isCreateThreadAllowed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void joinAllThreads() {
        Collection threadsToJoin;
        Iterator iterator = this.threadLock;
        synchronized (iterator) {
            this.isCreateThreadAllowed = false;
            threadsToJoin = this.threadStorage.values();
        }
        for (Thread createdThread : threadsToJoin) {
            try {
                createdThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createPThreadKey(LLVMPointer destructor) {
        Object object = this.pThreadKeyLock;
        synchronized (object) {
            ++this.pThreadKey;
            this.registerPThreadKey(this.pThreadKey, destructor);
            return this.pThreadKey;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void registerPThreadKey(int key, LLVMPointer destructor) {
        this.pThreadDestructorStorage.put(key, destructor);
        this.pThreadKeyStorage.put(key, new ConcurrentHashMap());
    }

    public int getNumberOfPthreadKeys() {
        return this.pThreadKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void deletePThreadKey(int keyId) {
        Object object = this.pThreadKeyLock;
        synchronized (object) {
            this.pThreadKeyStorage.remove(keyId);
            this.pThreadDestructorStorage.remove(keyId);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getSpecific(int keyId) {
        ConcurrentMap value = (ConcurrentMap)this.pThreadKeyStorage.get(keyId);
        if (value != null) {
            long threadId = Thread.currentThread().getId();
            return (LLVMPointer)value.get(threadId);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean setSpecific(int keyId, LLVMPointer value) {
        ConcurrentMap specificStore = (ConcurrentMap)this.pThreadKeyStorage.get(keyId);
        if (specificStore != null) {
            specificStore.put(Thread.currentThread().getId(), value);
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getAndRemoveSpecificUnlessNull(int keyId) {
        long threadId;
        LLVMPointer keyMapping;
        ConcurrentMap value = (ConcurrentMap)this.pThreadKeyStorage.get(keyId);
        if (value != null && (keyMapping = (LLVMPointer)value.get(threadId = Thread.currentThread().getId())) != null && !keyMapping.isNull()) {
            value.remove(threadId);
            return keyMapping;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getDestructor(int keyId) {
        return (LLVMPointer)this.pThreadDestructorStorage.get(keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Thread createThread(Runnable runnable) {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.isCreateThreadAllowed) {
                Thread thread = this.env.createThread(runnable);
                this.threadStorage.put(thread.getId(), thread);
                return thread;
            }
            return null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Thread getThread(long threadID) {
        return (Thread)this.threadStorage.get(threadID);
    }

    @CompilerDirectives.TruffleBoundary
    public void clearThreadId() {
        this.threadStorage.remove(Thread.currentThread().getId());
    }

    @CompilerDirectives.TruffleBoundary
    public void setThreadReturnValue(long threadId, Object value) {
        this.threadReturnValueStorage.put(threadId, value);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getThreadReturnValue(long threadId) {
        return this.threadReturnValueStorage.get(threadId);
    }

    public CallTarget getPthreadCallTarget() {
        return this.pthreadCallTarget;
    }
}

