/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPointerImpl.class)
final class LLVMPointerImplGen {
    private LLVMPointerImplGen() {
    }

    static {
        LibraryExport.register(LLVMPointerImpl.class, (LibraryExport[])new LibraryExport[]{new DynamicDispatchLibraryExports()});
    }

    @GeneratedBy(value=LLVMPointerImpl.class)
    private static final class DynamicDispatchLibraryExports
    extends LibraryExport<DynamicDispatchLibrary> {
        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, LLVMPointerImpl.class, false);
        }

        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached();
        }

        @GeneratedBy(value=LLVMPointerImpl.class)
        private static final class Uncached
        extends DynamicDispatchLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return receiver instanceof LLVMPointerImpl;
            }

            @CompilerDirectives.TruffleBoundary
            public Object cast(Object receiver) {
                return (LLVMPointerImpl)receiver;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Class<?> dispatch(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return arg0Value.dispatch(ConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=LLVMPointerImpl.class)
        private static final class Cached
        extends DynamicDispatchLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isNativeProfile_;

            protected Cached() {
            }

            public Object cast(Object receiver) {
                return (LLVMPointerImpl)receiver;
            }

            public boolean accepts(Object receiver) {
                return receiver instanceof LLVMPointerImpl;
            }

            public Class<?> dispatch(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    return arg0Value.dispatch(this.isNativeProfile_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Class<?> executeAndSpecialize(LLVMPointerImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.isNativeProfile_ = ConditionProfile.create();
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Class<?> clazz = arg0Value.dispatch(this.isNativeProfile_);
                    return clazz;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

