/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=ReferenceLibrary.class, receiverType=LLVMPointerImpl.class)})
abstract class CommonPointerLibraries {
    CommonPointerLibraries() {
    }

    @ExportMessage
    static boolean isReadable(LLVMPointerImpl receiver) {
        return false;
    }

    @ExportMessage
    static byte readI8(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I8 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static short readI16(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I16 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static int readI32(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I32 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static float readFloat(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Float directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static long readI64(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type I64 directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static double readDouble(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Double directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static LLVMPointer readPointer(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Pointer directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static Object readGenericI64(LLVMPointerImpl receiver, long offset) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot read a value of type Object directly from a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static boolean isWritable(LLVMPointerImpl receiver) {
        return false;
    }

    @ExportMessage
    static void writeI8(LLVMPointerImpl receiver, long offset, byte value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I8 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeI16(LLVMPointerImpl receiver, long offset, short value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I16 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeI32(LLVMPointerImpl receiver, long offset, int value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I32 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeFloat(LLVMPointerImpl receiver, long offset, float value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Float directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeI64(LLVMPointerImpl receiver, long offset, long value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type I64 directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeGenericI64(LLVMPointerImpl receiver, long offset, Object value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Object directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writeDouble(LLVMPointerImpl receiver, long offset, double value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Double directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static void writePointer(LLVMPointerImpl receiver, long offset, LLVMPointer value) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot write a value of type Pointer directly to a pointer. Perhaps a getObject() call is missing.");
    }

    @ExportMessage
    static boolean hasMembers(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Struct;
    }

    @ExportMessage
    static Object getMembers(LLVMPointerImpl receiver, boolean includeInternal, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) throws UnsupportedMessageException {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Clazz)) {
            LLVMInteropType.Clazz clazz = (LLVMInteropType.Clazz)receiver.getExportType();
            return new ClassKeys(clazz);
        }
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            return new Keys(struct);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isMemberReadable(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Clazz)) {
            LLVMInteropType.Clazz clazz = (LLVMInteropType.Clazz)receiver.getExportType();
            LLVMInteropType.StructMember member = clazz.findMember(ident);
            if (member == null) {
                LLVMInteropType.Method method = clazz.findMethod(ident);
                return method != null;
            }
            return member != null;
        }
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            LLVMInteropType.StructMember member = struct.findMember(ident);
            return member != null;
        }
        return false;
    }

    @ExportMessage
    static Object readMember(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="getMember") @Cached LLVMForeignGetMemberPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignReadNode read) throws UnsupportedMessageException, UnknownIdentifierException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, ident);
        return read.execute(ptr, ptr.getExportType());
    }

    @ExportMessage
    static boolean isMemberModifiable(LLVMPointerImpl receiver, String ident, @Cached.Shared(value="isObject") @Cached ConditionProfile isObject) {
        if (isObject.profile(receiver.getExportType() instanceof LLVMInteropType.Struct)) {
            LLVMInteropType.Struct struct = (LLVMInteropType.Struct)receiver.getExportType();
            LLVMInteropType.StructMember member = struct.findMember(ident);
            if (member == null) {
                return false;
            }
            return member.type instanceof LLVMInteropType.Value;
        }
        return false;
    }

    @ExportMessage
    static boolean isMemberInvocable(LLVMPointerImpl receiver, String ident) {
        LLVMInteropType type = receiver.getExportType();
        if (type instanceof LLVMInteropType.Clazz) {
            LLVMInteropType.Clazz clazz = (LLVMInteropType.Clazz)type;
            return clazz.findMethod(ident) != null;
        }
        return false;
    }

    static LLVMInteropType.Clazz asClazz(LLVMPointerImpl receiver) throws UnsupportedMessageException {
        LLVMInteropType type = receiver.getExportType();
        if (!(type instanceof LLVMInteropType.Clazz)) {
            throw UnsupportedMessageException.create();
        }
        return (LLVMInteropType.Clazz)type;
    }

    static Object[] addSelfObject(Object receiver, Object[] rawArgs) {
        Object[] newArguments = new Object[rawArgs.length + 1];
        newArguments[0] = receiver;
        for (int i = 0; i < rawArgs.length; ++i) {
            newArguments[i + 1] = rawArgs[i];
        }
        return newArguments;
    }

    static LLVMFunction getLLVMFunction(LLVMContext context, LLVMInteropType.Method method, LLVMInteropType.Clazz clazz, String member) throws UnknownIdentifierException {
        if (method == null) {
            throw UnknownIdentifierException.create((String)member);
        }
        LLVMFunction llvmFunction = context.getGlobalScope().getFunction(method.getLinkageName());
        if (llvmFunction == null) {
            CompilerDirectives.transferToInterpreter();
            String clazzName = clazz.toString().startsWith("class ") ? clazz.toString().substring(6) : clazz.toString();
            String msg = String.format("No implementation of declared method %s::%s (%s) found", clazzName, method.getName(), method.getLinkageName());
            throw new LLVMLinkerException(msg);
        }
        return llvmFunction;
    }

    @ExportMessage
    static boolean isMemberInsertable(LLVMPointerImpl receiver, String ident) {
        return false;
    }

    @ExportMessage
    static void writeMember(LLVMPointerImpl receiver, String ident, Object value, @Cached.Shared(value="getMember") @Cached LLVMForeignGetMemberPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignWriteNode write) throws UnsupportedMessageException, UnknownIdentifierException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, ident);
        write.execute(ptr, ptr.getExportType(), value);
    }

    @ExportMessage
    static boolean hasArrayElements(LLVMPointerImpl receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Array;
    }

    @ExportMessage
    static long getArraySize(LLVMPointerImpl receiver, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) throws UnsupportedMessageException {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            return ((LLVMInteropType.Array)receiver.getExportType()).length;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isArrayElementReadable(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            long length = ((LLVMInteropType.Array)receiver.getExportType()).length;
            return Long.compareUnsigned(idx, length) < 0;
        }
        return false;
    }

    @ExportMessage
    static Object readArrayElement(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="getIndex") @Cached LLVMForeignGetIndexPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignReadNode read) throws UnsupportedMessageException, InvalidArrayIndexException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, idx);
        return read.execute(ptr, ptr.getExportType());
    }

    @ExportMessage
    static boolean isArrayElementModifiable(LLVMPointerImpl receiver, long idx, @Cached.Shared(value="isArray") @Cached ConditionProfile isArray) {
        if (isArray.profile(receiver.getExportType() instanceof LLVMInteropType.Array)) {
            LLVMInteropType.Array arrayType = (LLVMInteropType.Array)receiver.getExportType();
            if (arrayType.elementType instanceof LLVMInteropType.Value) {
                long length = arrayType.length;
                return Long.compareUnsigned(idx, length) < 0;
            }
            return false;
        }
        return false;
    }

    @ExportMessage
    static boolean isArrayElementInsertable(LLVMPointerImpl receiver, long idx) {
        return false;
    }

    @ExportMessage
    static void writeArrayElement(LLVMPointerImpl receiver, long idx, Object value, @Cached.Shared(value="getIndex") @Cached LLVMForeignGetIndexPointerNode getElementPointer, @Cached.Exclusive @Cached LLVMForeignWriteNode write) throws UnsupportedMessageException, InvalidArrayIndexException {
        LLVMPointer ptr = getElementPointer.execute(receiver.getExportType(), receiver, idx);
        write.execute(ptr, ptr.getExportType(), value);
    }

    @ExportMessage
    static boolean hasLanguage(LLVMPointerImpl receiver) {
        return true;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(LLVMPointerImpl receiver) {
        return LLVMLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static String toDisplayString(LLVMPointerImpl receiver, boolean allowSideEffects) {
        return receiver.toString();
    }

    @ExportMessage
    static Object getMetaObject(LLVMPointerImpl receiver) throws UnsupportedMessageException {
        LLVMInteropType type = receiver.getExportType();
        if (type != null) {
            return type;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(LLVMPointerImpl receiver) {
        return receiver.getExportType() != null;
    }

    @ExportMessage
    static int identityHashCode(LLVMPointerImpl receiver) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError();
    }

    @ExportMessage
    static class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doPointer(LLVMPointerImpl receiver, LLVMPointerImpl other, @Cached LLVMAddressEqualsNode.Operation equals) {
            return TriState.valueOf((boolean)equals.executeWithTarget(receiver, other));
        }

        @Fallback
        static TriState doOther(LLVMPointerImpl receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }

    @ExportMessage
    static class IsSame {
        IsSame() {
        }

        @Specialization
        static boolean doNative(LLVMPointerImpl receiver, LLVMPointerImpl other, @Cached LLVMAddressEqualsNode.Operation equals) {
            return equals.executeWithTarget(receiver, other);
        }

        @Fallback
        static boolean doOther(LLVMPointerImpl receiver, Object other) {
            return false;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class ClassKeys
    implements TruffleObject {
        private final LLVMInteropType.Clazz type;

        private ClassKeys(LLVMInteropType.Clazz type) {
            this.type = type;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.type.getMemberCount() + this.type.getMethodCount();
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return Long.compareUnsigned(idx, this.getArraySize()) < 0;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            try {
                int index = (int)idx;
                if (index < this.type.getMemberCount()) {
                    return this.type.getMember((int)index).name;
                }
                return this.type.getMethod(index - this.type.getMemberCount()).getName();
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)idx);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class Keys
    implements TruffleObject {
        private final LLVMInteropType.Struct type;

        private Keys(LLVMInteropType.Struct type) {
            this.type = type;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.type.getMemberCount();
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return Long.compareUnsigned(idx, this.getArraySize()) < 0;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            try {
                return this.type.getMember((int)((int)idx)).name;
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)idx);
            }
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class InvokeMember {
        InvokeMember() {
        }

        @Specialization(guards={"asClazz(receiver)==clazz", "member.equals(methodName)", "argCount==arguments.length"}, assumptions={"getLanguage().singleContextAssumption"})
        static Object doCached(LLVMPointerImpl receiver, String member, Object[] arguments, @CachedContext(value=LLVMLanguage.class) LLVMContext context, @CachedLibrary(limit="5") InteropLibrary interop, @Cached(value="asClazz(receiver)") LLVMInteropType.Clazz clazz, @Cached(value="clazz.findMethodByArguments(receiver, member, arguments)") LLVMInteropType.Method method, @Cached(value="arguments.length") int argCount, @Cached(value="method.getName()") String methodName, @Cached(value="getLLVMFunction(context, method, clazz, member)") LLVMFunction llvmFunction) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            Object[] newArguments = CommonPointerLibraries.addSelfObject(receiver, arguments);
            return interop.execute((Object)context.getSymbol(llvmFunction), newArguments);
        }

        @Specialization(replaces={"doCached"})
        static Object doResolve(LLVMPointerImpl receiver, String member, Object[] arguments, @CachedContext(value=LLVMLanguage.class) LLVMContext context, @CachedLibrary(limit="5") InteropLibrary interop, @Cached LLVMDynAccessSymbolNode dynAccessSymbolNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            Object[] newArguments = CommonPointerLibraries.addSelfObject(receiver, arguments);
            LLVMInteropType.Clazz newClazz = CommonPointerLibraries.asClazz(receiver);
            LLVMInteropType.Method newMethod = newClazz.findMethodByArguments(receiver, member, arguments);
            LLVMFunction newLLVMFunction = CommonPointerLibraries.getLLVMFunction(context, newMethod, newClazz, member);
            LLVMPointer newReceiver = dynAccessSymbolNode.execute(newLLVMFunction);
            return interop.execute((Object)newReceiver, newArguments);
        }
    }
}

