/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreVectorNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeField(name="vectorLength", type=int.class)
public abstract class LLVMStoreVectorNode
extends LLVMStoreNode {
    public abstract int getVectorLength();

    public abstract void executeWithTarget(LLVMPointer var1, Object var2);

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMDoubleVector vector, @CachedLanguage LLVMLanguage language) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = language.getLLVMMemory();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putDouble((Node)this, currentPtr, vector.getValue(i));
            currentPtr += 8L;
        }
    }

    LLVMStoreVectorNode createRecursive() {
        return LLVMStoreVectorNodeGen.create(null, null, this.getVectorLength());
    }

    @Specialization(guards={"isAutoDerefHandle(language, address)"})
    protected void writeVectorDerefHandle(LLVMNativePointer address, Object value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached(value="createRecursive()") LLVMStoreVectorNode store) {
        store.executeWithTarget(getReceiver.execute(address), value);
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMFloatVector vector, @CachedLanguage LLVMLanguage language) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = language.getLLVMMemory();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putFloat((Node)this, currentPtr, vector.getValue(i));
            currentPtr += 4L;
        }
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMI16Vector vector, @CachedLanguage LLVMLanguage language) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = language.getLLVMMemory();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI16((Node)this, currentPtr, vector.getValue(i));
            currentPtr += 2L;
        }
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMI1Vector vector, @CachedLanguage LLVMLanguage language) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = language.getLLVMMemory();
        long basePtr = address.asNative();
        for (int byteOffset = 0; byteOffset < this.getVectorLength() / 8 + 1; ++byteOffset) {
            long byteAddr = basePtr + (long)byteOffset;
            int b = memory.getI8((Node)this, byteAddr);
            for (int bitOffset = 0; bitOffset < 8 && byteOffset * 8 + bitOffset < this.getVectorLength(); ++bitOffset) {
                int mask = 1 << bitOffset & 0xFF;
                int maskInvert = ~mask & 0xFF;
                int v = vector.getValue(byteOffset * 8 + bitOffset) ? 1 : 0;
                b = b & maskInvert | v << bitOffset & mask;
            }
            memory.putI8((Node)this, byteAddr, (byte)b);
        }
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMI32Vector vector, @CachedLanguage LLVMLanguage language) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = language.getLLVMMemory();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI32((Node)this, currentPtr, vector.getValue(i));
            currentPtr += 4L;
        }
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMI64Vector vector, @CachedLanguage LLVMLanguage language) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = language.getLLVMMemory();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI64((Node)this, currentPtr, vector.getValue(i));
            currentPtr += 8L;
        }
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMI8Vector vector, @CachedLanguage LLVMLanguage language) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = language.getLLVMMemory();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI8((Node)this, currentPtr, vector.getValue(i));
            ++currentPtr;
        }
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    @ExplodeLoop
    protected void writeVector(LLVMNativePointer address, LLVMPointerVector value, @CachedLanguage LLVMLanguage language, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode write) {
        assert (value.getLength() == this.getVectorLength());
        long offset = 0L;
        for (int i = 0; i < this.getVectorLength(); ++i) {
            write.executeWithTarget(address, offset, value.getValue(i));
            offset += 8L;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMI1Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI8(address.getObject(), curOffset, value.getValue(i) ? (byte)1 : 0);
            ++curOffset;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMI8Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI8(address.getObject(), curOffset, value.getValue(i));
            ++curOffset;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMI16Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI16(address.getObject(), curOffset, value.getValue(i));
            curOffset += 2L;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMI32Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI32(address.getObject(), curOffset, value.getValue(i));
            curOffset += 4L;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMFloatVector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeFloat(address.getObject(), curOffset, value.getValue(i));
            curOffset += 4L;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMDoubleVector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeDouble(address.getObject(), curOffset, value.getValue(i));
            curOffset += 8L;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMI64Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI64(address.getObject(), curOffset, value.getValue(i));
            curOffset += 8L;
        }
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected void writeVector(LLVMManagedPointer address, LLVMPointerVector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writePointer(address.getObject(), curOffset, value.getValue(i));
            curOffset += 8L;
        }
    }
}

