/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMIVarBitStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMIVarBitStoreNode
extends LLVMStoreNode {
    protected abstract void executeWithTarget(LLVMManagedPointer var1, LLVMIVarBit var2);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, LLVMIVarBit value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putIVarBit((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, LLVMIVarBit value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached LLVMIVarBitStoreNode store) {
        store.executeWithTarget(getReceiver.execute(addr), value);
    }

    @Specialization(limit="3")
    protected static void doOpManaged(LLVMManagedPointer address, LLVMIVarBit value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        byte[] bytes = value.getBytes();
        long curOffset = address.getOffset();
        for (int i = bytes.length - 1; i >= 0; --i) {
            nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
            ++curOffset;
        }
    }

    public static LLVMIVarBitStoreNode create() {
        return LLVMIVarBitStoreNodeGen.create(null, null);
    }

    public static abstract class LLVMIVarBitOffsetStoreNode
    extends LLVMOffsetStoreNode {
        public static LLVMIVarBitOffsetStoreNode create() {
            return LLVMIVarBitStoreNodeGen.LLVMIVarBitOffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMIVarBitOffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMIVarBitStoreNodeGen.LLVMIVarBitOffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, LLVMIVarBit var4);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, LLVMIVarBit value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putIVarBit((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, LLVMIVarBit value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached LLVMIVarBitOffsetStoreNode store) {
            store.executeWithTarget(getReceiver.execute(addr), offset, value);
        }

        @Specialization(limit="3")
        protected static void doOpManaged(LLVMManagedPointer address, long offset, LLVMIVarBit value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            byte[] bytes = value.getBytes();
            long curOffset = address.getOffset() + offset;
            for (int i = bytes.length - 1; i >= 0; --i) {
                nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
                ++curOffset;
            }
        }
    }
}

