/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMFloatStoreNode
extends LLVMStoreNode {
    public abstract void executeWithTarget(LLVMPointer var1, float var2);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, float value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putFloat((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, float value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMFloatStoreNode.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(limit="3")
    protected static void doOpManaged(LLVMManagedPointer address, float value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeFloat(address.getObject(), address.getOffset(), value);
    }

    public static LLVMFloatStoreNode create() {
        return LLVMFloatStoreNodeGen.create(null, null);
    }

    @GenerateUncached
    public static abstract class LLVMFloatOffsetStoreNode
    extends LLVMOffsetStoreNode {
        public static LLVMFloatOffsetStoreNode create() {
            return LLVMFloatStoreNodeGen.LLVMFloatOffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMFloatOffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMFloatStoreNodeGen.LLVMFloatOffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, float var4);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, float value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putFloat((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, float value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMFloatOffsetStoreNode.doOpManaged(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(limit="3")
        protected static void doOpManaged(LLVMManagedPointer address, long offset, float value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writeFloat(address.getObject(), address.getOffset() + offset, value);
        }
    }
}

