/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.rmw;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="pointerNode"), @NodeChild(type=LLVMExpressionNode.class, value="valueNode")})
public abstract class LLVMI64RMWNode
extends LLVMExpressionNode {

    public static abstract class LLVMI64RMWXorNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI64(this, address, value, (a, b) -> a ^ b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTargetGeneric(address)).asNative();
                write.executeWithTarget(address, result ^ value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWOrNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI64(this, address, value, (a, b) -> a | b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTargetGeneric(address)).asNative();
                write.executeWithTarget(address, result | value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWNandNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI64(this, address, value, (a, b) -> a & b ^ 0xFFFFFFFFFFFFFFFFL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTargetGeneric(address)).asNative();
                write.executeWithTarget(address, result & value ^ 0xFFFFFFFFFFFFFFFFL);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWAndNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndOpI64(this, address, value, (a, b) -> a & b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTargetGeneric(address)).asNative();
                write.executeWithTarget(address, result & value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWSubNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndSubI64(this, address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTargetGeneric(address)).asNative();
                write.executeWithTarget(address, result - value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWAddNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndAddI64(this, address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTargetGeneric(address)).asNative();
                write.executeWithTarget(address, result + value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWXchgNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getAndSetI64(this, address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(LLVMManagedPointer address, long value, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                Object result = read.executeWithTargetGeneric(address);
                write.executeWithTarget(address, value);
                return result;
            }
        }
    }
}

