/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@NodeField(name="vectorLength", type=int.class)
public abstract class LLVMLoadVectorNode
extends LLVMLoadNode {
    public abstract int getVectorLength();

    public static abstract class LLVMLoadDoubleVectorNode
    extends LLVMLoadVectorNode {
        LLVMLoadDoubleVectorNode createRecursive() {
            return LLVMLoadVectorNodeFactory.LLVMLoadDoubleVectorNodeGen.create(null, this.getVectorLength());
        }

        public abstract LLVMDoubleVector executeWithTarget(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMDoubleVector doDoubleVectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            double[] vector = new double[this.getVectorLength()];
            long currentPtr = addr.asNative();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = memory.getDouble((Node)this, currentPtr);
                currentPtr += 8L;
            }
            return LLVMDoubleVector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMDoubleVector doDoubleVector(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMLoadDoubleVectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        @ExplodeLoop
        protected LLVMDoubleVector doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            double[] vector = new double[this.getVectorLength()];
            long curOffset = addr.getOffset();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = nativeRead.readDouble(addr.getObject(), curOffset);
                curOffset += 8L;
            }
            return LLVMDoubleVector.create(vector);
        }
    }

    public static abstract class LLVMLoadFloatVectorNode
    extends LLVMLoadVectorNode {
        LLVMLoadFloatVectorNode createRecursive() {
            return LLVMLoadVectorNodeFactory.LLVMLoadFloatVectorNodeGen.create(null, this.getVectorLength());
        }

        public abstract LLVMFloatVector executeWithTarget(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMFloatVector doFloatVectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            float[] vector = new float[this.getVectorLength()];
            long currentPtr = addr.asNative();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = memory.getFloat((Node)this, currentPtr);
                currentPtr += 4L;
            }
            return LLVMFloatVector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMFloatVector doFloatVectorDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMLoadFloatVectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        @ExplodeLoop
        protected LLVMFloatVector doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            float[] vector = new float[this.getVectorLength()];
            long curOffset = addr.getOffset();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = nativeRead.readFloat(addr.getObject(), curOffset);
                curOffset += 4L;
            }
            return LLVMFloatVector.create(vector);
        }
    }

    public static abstract class LLVMLoadPointerVectorNode
    extends LLVMLoadVectorNode {
        static LLVMLoadPointerVectorNode create(int length) {
            return LLVMLoadVectorNodeFactory.LLVMLoadPointerVectorNodeGen.create(null, length);
        }

        public abstract LLVMPointerVector executeWithTarget(Object var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMPointerVector doPointerVectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMPointer[] vector = new LLVMPointer[this.getVectorLength()];
            long currentPtr = addr.asNative();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = memory.getPointer((Node)this, currentPtr);
                currentPtr += 8L;
            }
            return LLVMPointerVector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMPointerVector doPointerVectorDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="create(getVectorLength())") LLVMLoadPointerVectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        @ExplodeLoop
        protected LLVMPointerVector doForeignPointers(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            LLVMPointer[] vector = new LLVMPointer[this.getVectorLength()];
            long curOffset = addr.getOffset();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = nativeRead.readPointer(addr.getObject(), curOffset);
                curOffset += 8L;
            }
            return LLVMPointerVector.create(vector);
        }
    }

    public static abstract class LLVMLoadI64VectorNode
    extends LLVMLoadVectorNode {
        LLVMLoadI64VectorNode createRecursive() {
            return LLVMLoadVectorNodeFactory.LLVMLoadI64VectorNodeGen.create(null, this.getVectorLength());
        }

        public abstract LLVMVector executeWithTarget(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMI64Vector doI64VectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            long[] vector = new long[this.getVectorLength()];
            long currentPtr = addr.asNative();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = memory.getI64((Node)this, currentPtr);
                currentPtr += 8L;
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMVector doI64VectorDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMLoadI64VectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3", rewriteOn={UnexpectedResultException.class})
        @ExplodeLoop
        protected LLVMI64Vector doI64Vector(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
            long[] vector = new long[this.getVectorLength()];
            long curOffset = addr.getOffset();
            int i = 0;
            try {
                for (i = 0; i < vector.length; ++i) {
                    vector[i] = nativeRead.readI64(addr.getObject(), curOffset);
                    curOffset += 8L;
                }
                return LLVMI64Vector.create(vector);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                LLVMPointer[] ptrVector = new LLVMPointer[this.getVectorLength()];
                for (int j = 0; j < i; ++j) {
                    ptrVector[j] = LLVMNativePointer.create(vector[j]);
                }
                ptrVector[i] = LLVMTypesGen.asPointer(e.getResult());
                ++i;
                curOffset += 8L;
                while (i < ptrVector.length) {
                    Object obj = nativeRead.readGenericI64(addr.getObject(), curOffset);
                    curOffset += 8L;
                    ptrVector[i] = obj instanceof Long ? LLVMNativePointer.create((Long)obj) : LLVMPointer.cast(obj);
                    ++i;
                }
                throw new UnexpectedResultException((Object)LLVMPointerVector.create(ptrVector));
            }
        }

        @Specialization(replaces={"doI64Vector"})
        @ExplodeLoop
        protected LLVMPointerVector doPointerVector(LLVMManagedPointer addr, @Cached(value="create(getVectorLength())") LLVMLoadPointerVectorNode load) {
            return load.executeWithTarget(addr);
        }
    }

    public static abstract class LLVMLoadI32VectorNode
    extends LLVMLoadVectorNode {
        LLVMLoadI32VectorNode createRecursive() {
            return LLVMLoadVectorNodeFactory.LLVMLoadI32VectorNodeGen.create(null, this.getVectorLength());
        }

        public abstract LLVMI32Vector executeWithTarget(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMI32Vector doI32VectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            int[] vector = new int[this.getVectorLength()];
            long currentPtr = addr.asNative();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = memory.getI32((Node)this, currentPtr);
                currentPtr += 4L;
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMI32Vector doI32VectorDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMLoadI32VectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        @ExplodeLoop
        protected LLVMI32Vector doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            int[] vector = new int[this.getVectorLength()];
            long curOffset = addr.getOffset();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = nativeRead.readI32(addr.getObject(), curOffset);
                curOffset += 4L;
            }
            return LLVMI32Vector.create(vector);
        }
    }

    public static abstract class LLVMLoadI16VectorNode
    extends LLVMLoadVectorNode {
        LLVMLoadI16VectorNode createRecursive() {
            return LLVMLoadVectorNodeFactory.LLVMLoadI16VectorNodeGen.create(null, this.getVectorLength());
        }

        public abstract LLVMI16Vector executeWithTarget(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMI16Vector doI16VectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            short[] vector = new short[this.getVectorLength()];
            long currentPtr = addr.asNative();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = memory.getI16((Node)this, currentPtr);
                currentPtr += 2L;
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMI16Vector doI16VectorDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMLoadI16VectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        @ExplodeLoop
        protected LLVMI16Vector doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            short[] vector = new short[this.getVectorLength()];
            long curOffset = addr.getOffset();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = nativeRead.readI16(addr.getObject(), curOffset);
                curOffset += 2L;
            }
            return LLVMI16Vector.create(vector);
        }
    }

    public static abstract class LLVMLoadI8VectorNode
    extends LLVMLoadVectorNode {
        LLVMLoadI8VectorNode createRecursive() {
            return LLVMLoadVectorNodeFactory.LLVMLoadI8VectorNodeGen.create(null, this.getVectorLength());
        }

        public abstract LLVMI8Vector executeWithTarget(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMI8Vector doI8VectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            byte[] vector = new byte[this.getVectorLength()];
            long currentPtr = addr.asNative();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = memory.getI8((Node)this, currentPtr);
                ++currentPtr;
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMI8Vector doI8VectorDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMLoadI8VectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        @ExplodeLoop
        protected LLVMI8Vector doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            byte[] vector = new byte[this.getVectorLength()];
            long curOffset = addr.getOffset();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = nativeRead.readI8(addr.getObject(), curOffset);
                ++curOffset;
            }
            return LLVMI8Vector.create(vector);
        }
    }

    public static abstract class LLVMLoadI1VectorNode
    extends LLVMLoadVectorNode {
        LLVMLoadI1VectorNode createRecursive() {
            return LLVMLoadVectorNodeFactory.LLVMLoadI1VectorNodeGen.create(null, this.getVectorLength());
        }

        public abstract LLVMI1Vector executeWithTarget(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        @ExplodeLoop
        protected LLVMI1Vector doI1VectorNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            boolean[] vector = new boolean[this.getVectorLength()];
            long basePtr = addr.asNative();
            for (int byteOffset = 0; byteOffset < vector.length / 8 + 1; ++byteOffset) {
                byte b = memory.getI8((Node)this, basePtr + (long)byteOffset);
                for (int bitOffset = 0; bitOffset < 8 && byteOffset * 8 + bitOffset < vector.length; ++bitOffset) {
                    int mask = 1 << bitOffset & 0xFF;
                    vector[byteOffset * 8 + bitOffset] = (b & mask) >> bitOffset == 1;
                }
            }
            return LLVMI1Vector.create(vector);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMI1Vector doI1VectorDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached(value="createRecursive()") LLVMLoadI1VectorNode load) {
            return load.executeWithTarget(getReceiver.execute(addr));
        }

        @Specialization(limit="3")
        @ExplodeLoop
        protected LLVMI1Vector doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            boolean[] vector = new boolean[this.getVectorLength()];
            long curOffset = addr.getOffset();
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = nativeRead.readI8(addr.getObject(), curOffset) != 0;
                ++curOffset;
            }
            return LLVMI1Vector.create(vector);
        }
    }
}

