/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI8LoadNode
extends LLVMLoadNode {
    public static LLVMI8LoadNode create() {
        return LLVMI8LoadNodeGen.create(null);
    }

    public abstract byte executeWithTarget(Object var1);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected byte doI8Native(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
        return language.getLLVMMemory().getI8((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected byte doI8DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doI8Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected byte doI8Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI8(addr.getObject(), addr.getOffset());
    }

    @GenerateUncached
    public static abstract class LLVMI8OffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMI8OffsetLoadNode create() {
            return LLVMI8LoadNodeGen.LLVMI8OffsetLoadNodeGen.create();
        }

        public abstract byte executeWithTarget(LLVMPointer var1, long var2);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected byte doI8Native(LLVMNativePointer addr, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getI8((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected byte doI8DerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doI8Managed(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3")
        protected byte doI8Managed(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readI8(addr.getObject(), addr.getOffset() + offset);
        }
    }
}

