/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDerefHandleGetReceiverNode.class)
public final class LLVMDerefHandleGetReceiverNodeGen
extends LLVMDerefHandleGetReceiverNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMDerefHandleGetReceiverNodeGen() {
    }

    @Override
    public LLVMManagedPointer execute(LLVMNativePointer arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
            LLVMContext pointer_context__ = (LLVMContext)lLVMLanguageContextReference__.get();
            return this.doPointer(arg0Value, pointer_context__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    public LLVMManagedPointer execute(long arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
            LLVMContext long_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
            return this.doLong(arg0Value, long_context__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private LLVMManagedPointer executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            LLVMContext pointer_context__ = null;
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__2 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                }
                pointer_context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.doPointer(arg0Value_, pointer_context__);
                return lLVMManagedPointer;
            }
            LLVMContext long_context__ = null;
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__3 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                }
                long_context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.doLong(arg0Value_, long_context__);
                return lLVMManagedPointer;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMDerefHandleGetReceiverNode create() {
        return new LLVMDerefHandleGetReceiverNodeGen();
    }

    public static LLVMDerefHandleGetReceiverNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMDerefHandleGetReceiverNode.class)
    private static final class Uncached
    extends LLVMDerefHandleGetReceiverNode {
        private final TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_ = this.lookupContextReference(LLVMLanguage.class);

        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMManagedPointer execute(LLVMNativePointer arg0Value) {
            return this.doPointer(arg0Value, (LLVMContext)this.lLVMLanguageContextReference_.get());
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMManagedPointer execute(long arg0Value) {
            return this.doLong(arg0Value, (LLVMContext)this.lLVMLanguageContextReference_.get());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

