/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVM80BitFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVM80BitFloatLoadNode
extends LLVMLoadNode {
    static LLVM80BitFloatLoadNode create() {
        return LLVM80BitFloatLoadNodeGen.create(null);
    }

    public abstract LLVM80BitFloat executeWithTarget(LLVMManagedPointer var1);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected LLVM80BitFloat do80BitFloatNative(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
        return language.getLLVMMemory().get80BitFloat(this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected LLVM80BitFloat do80BitFloatDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @Cached LLVM80BitFloatLoadNode load) {
        return load.executeWithTarget(getReceiver.execute(addr));
    }

    @Specialization(limit="3")
    @ExplodeLoop
    protected LLVM80BitFloat doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        byte[] result = new byte[10];
        long curOffset = addr.getOffset();
        for (int i = 0; i < result.length; ++i) {
            result[i] = nativeRead.readI8(addr.getObject(), curOffset);
            ++curOffset;
        }
        return LLVM80BitFloat.fromBytes(result);
    }
}

