/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.AllocateReadOnlyGlobalsBlockNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class AllocateReadOnlyGlobalsBlockNode
extends LLVMNode
implements LLVMAllocateNode {
    private final long size;
    @Node.Child
    LLVMToNativeNode toNative;

    public AllocateReadOnlyGlobalsBlockNode(long size) {
        this.size = size;
        this.toNative = LLVMToNativeNode.createToNativeWithTarget();
    }

    public static AllocateReadOnlyGlobalsBlockNode create(StructureType type, DataLayout dataLayout) throws Type.TypeOverflowException {
        return AllocateReadOnlyGlobalsBlockNodeGen.create(type.getSize(dataLayout));
    }

    @Specialization(limit="1")
    public LLVMPointer executeWithTarget(@CachedContext(value=LLVMLanguage.class) LLVMContext ctx, @Bind(value="ctx.getAllocateGlobalsBlockFunction()") Object allocateGlobalsBlock, @CachedLibrary(value="allocateGlobalsBlock") InteropLibrary interop) {
        try {
            Object ret = interop.execute(allocateGlobalsBlock, new Object[]{this.size});
            return this.toNative.executeWithTarget(ret);
        }
        catch (InteropException ex) {
            throw new OutOfMemoryError("could not allocate globals block");
        }
    }
}

