/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.rust;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMExitException;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMPanic
extends LLVMIntrinsic {
    protected PanicLocType createPanicLocation() {
        LLVMFunctionStartNode startNode = (LLVMFunctionStartNode)this.getRootNode();
        DataLayout dataSpecConverter = startNode.getDatalayout();
        return PanicLocType.create(dataSpecConverter);
    }

    @Specialization
    protected Object doOp(LLVMPointer panicLocVar, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createPanicLocation()") PanicLocType panicLoc, @CachedLanguage LLVMLanguage language) {
        LLVMNativePointer pointer = toNative.executeWithTarget(panicLocVar);
        throw panicLoc.read(language.getLLVMMemory(), pointer.asNative(), this);
    }

    private static final class StrSliceType {
        private final long lengthOffset;
        private final Type type;

        private StrSliceType(DataLayout dataLayout, Type type) {
            try {
                this.lengthOffset = ((StructureType)type).getOffsetOf(1L, dataLayout);
            }
            catch (Type.TypeOverflowException e) {
                throw new AssertionError((Object)e);
            }
            this.type = type;
        }

        @CompilerDirectives.TruffleBoundary
        String read(LLVMMemory memory, long address) {
            long strAddr = memory.getPointer(null, address).asNative();
            int strLen = memory.getI32(null, address + this.lengthOffset);
            StringBuilder strBuilder = new StringBuilder();
            for (int i = 0; i < strLen; ++i) {
                strBuilder.append((char)Byte.toUnsignedInt(memory.getI8(null, strAddr)));
                ++strAddr;
            }
            return strBuilder.toString();
        }

        public Type getType() {
            return this.type;
        }

        static StrSliceType create(DataLayout dataLayout) {
            StructureType type = StructureType.createUnnamed(false, new PointerType(PrimitiveType.I8), PrimitiveType.I64);
            return new StrSliceType(dataLayout, type);
        }
    }

    static final class PanicLocType {
        private static final int EXIT_CODE_PANIC = 101;
        private final StrSliceType strslice;
        private final long offsetFilename;
        private final long offsetLineNr;

        private PanicLocType(DataLayout dataLayout, Type type, StrSliceType strslice) {
            this.strslice = strslice;
            StructureType structureType = (StructureType)((PointerType)type).getElementType(0L);
            try {
                this.offsetFilename = structureType.getOffsetOf(1L, dataLayout);
                this.offsetLineNr = structureType.getOffsetOf(2L, dataLayout);
            }
            catch (Type.TypeOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        LLVMExitException read(LLVMMemory memory, long address, Node location) {
            String desc = this.strslice.read(memory, address);
            String filename = this.strslice.read(memory, address + this.offsetFilename);
            int linenr = memory.getI32(null, address + this.offsetLineNr);
            System.err.printf("thread '%s' panicked at '%s', %s:%d%n", Thread.currentThread().getName(), desc, filename, linenr);
            System.err.print("note: No backtrace available");
            return LLVMExitException.exit(101, location);
        }

        static PanicLocType create(DataLayout dataLayout) {
            CompilerAsserts.neverPartOfCompilation();
            StrSliceType strslice = StrSliceType.create(dataLayout);
            PointerType type = new PointerType(StructureType.createUnnamed(false, strslice.getType(), strslice.getType(), PrimitiveType.I32));
            return new PanicLocType(dataLayout, type, strslice);
        }
    }
}

