/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild
public abstract class LLVMVAStart
extends LLVMExpressionNode {
    private final int numberOfExplicitArguments;

    public LLVMVAStart(int numberOfExplicitArguments) {
        this.numberOfExplicitArguments = numberOfExplicitArguments;
    }

    private static Object[] getArgumentsArray(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        Object[] newArguments = new Object[arguments.length - 1];
        System.arraycopy(arguments, 1, newArguments, 0, newArguments.length);
        return newArguments;
    }

    @Specialization(limit="1")
    protected Object vaStart(VirtualFrame frame, LLVMManagedPointer targetAddress, @CachedLibrary(value="targetAddress.getObject()") LLVMVaListLibrary vaListLibrary) {
        vaListLibrary.initialize(targetAddress.getObject(), LLVMVAStart.getArgumentsArray(frame), this.numberOfExplicitArguments);
        return null;
    }

    Object createNativeVAListWrapper(LLVMNativePointer targetAddress, LLVMLanguage lang) {
        return lang.getCapability(PlatformCapability.class).createNativeVAListWrapper(targetAddress, this.getRootNode());
    }

    @Specialization
    protected Object vaStart(VirtualFrame frame, LLVMNativePointer targetAddress, @CachedLanguage LLVMLanguage lang, @Cached NativeLLVMVaListHelper nativeLLVMVaListHelper) {
        return nativeLLVMVaListHelper.execute(frame, this.createNativeVAListWrapper(targetAddress, lang), this.numberOfExplicitArguments);
    }

    static abstract class NativeLLVMVaListHelper
    extends LLVMNode {
        NativeLLVMVaListHelper() {
        }

        public abstract Object execute(VirtualFrame var1, Object var2, int var3);

        @Specialization(limit="1")
        protected Object vaStart(VirtualFrame frame, Object nativeVaListWrapper, int numberOfExplicitArguments, @CachedLibrary(value="nativeVaListWrapper") LLVMVaListLibrary vaListLibrary) {
            vaListLibrary.initialize(nativeVaListWrapper, LLVMVAStart.getArgumentsArray(frame), numberOfExplicitArguments);
            return null;
        }
    }
}

